#include <dir.h>
#include <alloc.h>
#include <errno.h>
#include <io.h>
#include <sys\stat.h>
#include <ctype.h>
#include <dos.h>
#include <process.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "..\fontload.h"

/*
 [ ] A base port ne fixed 220h legyen!
 [ ] Mic-bemenet allitasa!
 [ ] karakterek visszaallitasa
 [ ] Eger kezeles!!!

 [] Mute-okat is!
 [] ANSI kepet hatternek!
 [] left/right teljes support!
*/

enum tkim { mic, line, cd, synth, master, codec /*melyik? */ };
#define M_MIC    0
#define M_LINE   1
#define M_CD     2
#define M_MASTER 4

#define VACCOL         WHITE+BLINK
#define VDECOL         LIGHTGREEN+BLINK // LIGHTGRAY+BLINK
#define VDPOSCOL(xx)   (((xx>12)?LIGHTBLUE:((xx>2)?LIGHTGREEN:LIGHTRED))+BLINK)

#define TOLO1   "ǝ"
//#define VOLACT  "ќ"
//#define VOLMUTE "Ҝ"
#define VOLACT  "Ҟ"
#define VOLMUTE "ӛ"

extern "C" void far Mixer_font( void );
extern char MIXPAN;
char far *vidmem =  (char *)0xB8000000;
char far *fontmem = (char *)0xA0000000;
extern "C" void far CGenModeSet(void);
extern "C" void far CGenModeClear(void);
extern "C" void far WaitVsyncStart(void);

int mxval[10]={    0x0,   0x8,0x10,   0x18,   0x28}; // portok
//char *outok[]={"Mic","Line","CD","Synth","Master"};

int globlock=1;

void kilepo( char *st )
{
 printf(st);
 exit(1);
}

void _16BackColors( int on )
{
 union REGS regs;

 regs.h.ah = 0x10;
 regs.h.al = 3;
 regs.h.bl = (on==1) ? 0 : 1;
 int86(0x10, &regs, &regs);
}

//--------------------------------------------------------------------

void mixset( tkim me, int vleft, int vright ) // vol: 0-127 (?)
{
 int ref=mxval[me];

 outportb(0x220+0x506,ref|2);
 outportb(0x220+0x106,vleft);

 outportb(0x220+0x506,ref|3);
 outportb(0x220+0x106,vright);
}

struct smutes
 {
  int line;   // 1-on
  int mic;
  int master;
 }
  mstat;

int lmut=-1;

void mutechan( tkim me, int dis )
{
 int ik;
 ik=16|8|(mstat.line?0:1)|(mstat.mic?4:0)|(mstat.master?0:2);
 switch (me)
 {
  case    mic:ik=(ik&(~4))|(dis?0:4);
              if (lmut!=ik)
               outportb(0x220,ik);
              lmut=ik;
              mstat.mic=!dis;
             break;
  case   line:ik=(ik&(~1))|(dis?1:0);
              if (lmut!=ik)
               outportb(0x220,ik);
              lmut=ik;
              mstat.line=!dis;
             break;
  case master:ik=(ik&(~2))|(dis?2:0);
              if (lmut!=ik)
               outportb(0x220,ik);
              lmut=ik;
              mstat.master=!dis;
             break;
  case     cd:
  case  synth:mixset(me,0,0);
             break;
 }
}

void drawglock( void )
{
 textattr((globlock?LIGHTGREEN:LIGHTRED)+BLINK);
 gotoxy(59,6);
 cputs(globlock?"џ":"М");
}

//----------------------------------------------------------

class cvolbar
 {
  int x,y;
  int y2;
  int magas;
  //, curp, lastp;

  int mmix;
  int pleft,pright,bmutel,bmuter;
  int lleft,lright,lmutel,lmuter;
  int locked;
  int forc,lchan;
  int gotfocus;

  char ltil[10],rtil[10];
  int lt,rt;

 public:
  cvolbar( int xx, int yy, int mmagas, int ertb, int ertj /*szazalek*/, int tyx );
  //~cvolbar( void );
  void draw( void );
  void redraw(void);
  void getfocus(void);
  void localfoc(void);
  void losefocus(void);
  int getdbleft(void); // get volume
  int getdbright(void);
  int getmutel(void) { return bmutel; };
  int getmuter(void) { return bmutel; }; // !!!
  void setmute( int mu ) { bmutel=mu; };
  int gettype(void) { return mmix; }; // get volume

  int use( void );
  void setvol(void);
 };

cvolbar::cvolbar( int xx, int yy, int mmagas, int ertb, int ertj /*szazalek*/, int tyx )
{
 x=xx; y=yy; y2=yy+mmagas;
 magas=mmagas-1;
 int curp=magas-((ertb*magas)/100); // itt nem lesz igy jo
 int curr=magas-((ertj*magas)/100); // itt nem lesz igy jo
 mmix=tyx;

 lleft=lright=0;
 forc=1;
 pleft=curp;
 pright=curr;
 lchan=3;
 locked=1; //
 bmutel=0;
 lmutel=-1;
 gotfocus=0;
 lt=-1; rt=-1;
}

void cvolbar::draw(void)
{
 int c;
 //textattr((gotfocus)?VACCOL:VDECOL);
 /*
 for (c=0;c<=magas;c++)
   {
    gotoxy(x-2,y+c);
    if (c!=pleft)
     putch('');
    gotoxy(x+1,y+c);
    if (c!=pright)
     putch('');
   }
 */
 //gotoxy(x-2,y+2+magas);
 //puts((!bmutel)?VOLACT:VOLMUTE);

 forc=1;
 redraw();
}

void cvolbar::redraw(void)
{
 if (lleft!=pleft || forc)
  {
   if (lt!=-1)
    puttext(x-3,lt,x-1,lt,ltil);

   lt=y+pleft;
   gettext(x-3,lt,x-1,lt,ltil);

   if ((lchan&1) && gotfocus) textattr(VACCOL);
    else if (!locked && lchan!=1) textattr(VDPOSCOL(pleft));
     else textattr(VDPOSCOL(pleft));
   gotoxy(x-2-1,y+pleft);
   cputs(TOLO1);
  }

 if (lright!=pright || forc)
  {
   if (rt!=-1)
    puttext(x,rt,x+3,rt,rtil);

   rt=y+pright;
   gettext(x,rt,x+3,rt,rtil);
   if ((lchan&2) && gotfocus) textattr(VACCOL);
    else if (!locked && lchan!=2) textattr(VDPOSCOL(pright));
     else textattr(VDPOSCOL(pright));
   gotoxy(x+1-1,y+pright);
   cputs(TOLO1);
  }

 //gotoxy(x-2,y+2+magas);
 textattr((!bmutel)?BLUE+BLINK:LIGHTRED+BLINK);
 gotoxy(x-1+4,y-2);
 cputs((!bmutel)?VOLACT:VOLMUTE);

 lleft=pleft;
 lright=pright;
 forc=0;
}

void cvolbar::localfoc(void)
{
 forc=1;
 redraw();
 /*
 textattr((lchan&1)?LIGHTGREEN:WHITE);
 gotoxy(x-2-1,y+pleft);
 cputs(TOLO1);

 textattr((lchan&2)?LIGHTGREEN:WHITE);
 gotoxy(x+1-1,y+pright);
 cputs(TOLO1);
 */
}

void cvolbar::getfocus(void)
{
 gotfocus=1;
 draw();
}

void cvolbar::losefocus(void)
{
 gotfocus=0;
 draw();
}

void cvolbar::setvol(void)
{
 float a;
 int b,d;

 a=((float)magas-lleft)/magas;
 if (a>0)
  b=((log(a)+3)/3)*127;
 else
  b=0;

 a=((float)magas-lright)/magas;
 if (a>0)
  d=((log(a)+3)/3)*127;
 else
  d=0;
 /*
 int b;
 b=curp*(-56)/magas;
 b=((b<<1)+0x7F);
 */

 if (!bmutel)
  {
   if (lmutel)
    mutechan(mmix,0);
   mixset(mmix,b,d);
  }
 else
  mutechan(mmix,1);

 lmutel=bmutel;
}

int cvolbar::getdbleft(void)
{
 return( lleft*(-56)/magas );
}

int cvolbar::getdbright(void)
{
 return( lright*(-56)/magas );
}


int cvolbar::use(void)
{
 int kilep=0;
 int kar,kar2;

 locked=globlock;

 if (locked)
  lchan=3;
 else
  if (lchan==3)
   lchan=1;

 setvol();
 getfocus();
 localfoc();
 while (!kilep)
  {
   kar=255;
   if (kbhit())
    kar=toupper(getch());
   if (kar==0)
    kar2=getch();

   switch (kar)
   {
    case 27:kilep=1;
           break;
    case'M':bmutel=!bmutel;  // mute
            setvol();
            redraw();
           break;
    case'L':if (locked) // lock balance
             { locked=0; lchan=1; }
            else
             { locked=1; lchan=3; }
            forc=1;
            redraw();
            globlock=locked;
            drawglock();
           break;
    case  0:
            switch (kar2)
            {
             case 72:if (lchan&1)
                      if (pleft>0) pleft--;
                     if (lchan&2)
                      if (pright>0) pright--;
                    break;
             case 80:if (lchan&1)
                      if (pleft<magas) pleft++;
                     if (lchan&2)
                      if (pright<magas) pright++;
                    break;
             case 75:if (locked || lchan==1) { kilep=1; break; }
                     lchan=1;
                     localfoc();
                    break;
             case 77:if (locked || lchan==2) { kilep=1; break; }
                     lchan=2;
                     localfoc();
                    break;
            }
            redraw();
            setvol();
           break;

   }
  }
 losefocus();
 if (kar==27)
  return 0;

 return kar2;
}

//----------------------------------------------------------
int beallx[4*20];
struct
 {
  int left;
  int right;
  int mutel;
  int muter;
 }
  cfgvoc[20];

int svmaps[20]={line,mic,cd,synth,codec,master};


void ultracfgread(void)
{
 char *p, *q;
 int c;

 p=getenv("ULTRADIR");
 if (!p)
  kilepo("\n\nULTRADIR environment variable not set, exiting...\n");

 char pt[MAXPATH];
 strcpy(pt,p);
 strcat(pt,"\\ULTRAMIX.INI");
 FILE *f;
 f=fopen(pt,"rt");
 if (!f)
  kilepo("\n\nCannot open ULTRAMIX.INI (in Ultradir)\n");

 char sor[130];
 int sta=-1;
 while (!feof(f))
  {
   fgets(sor,128,f);
   if (sor[strlen(sor)-1]=='\n')
    sor[strlen(sor)-1]=0;

   if ((sta<0) && (stricmp(sor,"[DOS Levels]")==0))
    {
     sta=0;
     continue;
    }

   if (sta>=0)
    {
     q=strchr(sor,'=');
     q++;
     beallx[sta]=atoi(q);
     sta++;
    }

   if (sta>80-2)
    break;
  }
 fclose(f);

 int d;
 for (c=0;c<6;c++)
  {
   d=svmaps[c];
   cfgvoc[d].left =beallx[c*4];
   cfgvoc[d].right=beallx[c*4+1];
   cfgvoc[d].mutel=beallx[c*4+2];
   cfgvoc[d].muter=beallx[c*4+3];
  }
}

void ultracfgwrite(void)
{
 char *p, *q;
 int c;

 int d;
 for (c=0;c<6;c++)
  {
   d=svmaps[c];
   beallx[c*4]=cfgvoc[d].left ;
   beallx[c*4+1]=cfgvoc[d].right;
   beallx[c*4+2]=cfgvoc[d].mutel;
   beallx[c*4+3]=cfgvoc[d].muter;
  }

 p=getenv("ULTRADIR");
 if (!p)
  kilepo("\n\nULTRADIR environment variable not set, exiting...\n");

 char pt[MAXPATH];
 char pt2[MAXPATH];

 strcpy(pt,p);
 strcat(pt,"\\ULTRAMIX.INI");
 FILE *f;
 f=fopen(pt,"rt");
 if (!f)
  kilepo("\n\nCannot open ULTRAMIX.INI (in Ultradir)\n");

 FILE *g;
 strcpy(pt2,p);
 strcat(pt2,"\\ULTRAMIX.IN~");
 g=fopen(pt2,"wt");
 if (!g)
  kilepo("\n\nCannot open ULTRAMIX.IN~ for save tmp file (in Ultradir)\n");

 char sor[130],sor2[130];
 int sta=-1;
 while (!feof(f))
  {
   sor[0]=0;
   fgets(sor,128,f);
   strcpy(sor2,sor);
   if (sor[strlen(sor)-1]=='\n')
    sor[strlen(sor)-1]=0;

   while (sor[strlen(sor)-1]==' ')
    sor[strlen(sor)-1]=0;

   if (sor[0]=='\0') // !! revise
    sta=-1;

   if ((sta<0) && (stricmp(sor,"[DOS Levels]")==0))
    {
     sta=0;
     fputs(sor,g);
     fputs("\n",g);
     continue;
    }

   if (sta>=0)
    {
     q=strchr(sor,'=');
     *(++q)=0;
     fprintf(g,"%s%d\n",sor,beallx[sta]);
     sta++;
     continue;
    }

   if (sta>80-2)
    break;

   fputs(sor2,g);
  }
 fclose(f);
 fclose(g);

 if (unlink(pt)==-1)
  if (errno==EACCES)
   {
    chmod(pt,S_IREAD|S_IWRITE);
    unlink(pt);
   };
 rename(pt2,pt);
}


//-----------------------------------------------------------------------

void main( void )
{
 char origscr[4000];
 char far *origfont;

 ultracfgread();

 font mixfont;

 mixfont.memload((char far *)Mixer_font);

 text_info ti;

 gettextinfo(&ti);

 WaitVsyncStart();
 origfont=(char far *)farmalloc(8192);
 CGenModeSet();
 _fmemcpy(origfont,fontmem,32*256);
 CGenModeClear();


 _16BackColors(1);
 mixfont.set();
 _setcursortype(_NOCURSOR);
 _fmemcpy(origscr,vidmem,4000);

 //most az osszekeveres:
 char *p=&MIXPAN;
 int c,d;

 _fmemcpy(&p[0],&origscr[0],2*80);
 for (c=21;c<24;c++)
  _fmemcpy(&p[c*160],&origscr[c*160],2*80);

 for (c=1;c<21;c++)
  {
   _fmemcpy(&p[c*160],&origscr[c*160],2*6);
   _fmemcpy(&p[c*160+2*71],&origscr[c*160+2*71],2*9);
  }

 _fmemcpy(vidmem,&MIXPAN,4000);
 drawglock();

 cvolbar *vols[10];

 mstat.line=cfgvoc[M_LINE].mutel;
 mstat.mic=cfgvoc[M_MIC].mutel;
 mstat.master=cfgvoc[M_MASTER].mutel;
 for (c=0;c<5;c++)
  {
   vols[c]=new cvolbar(16+9*c,5,16,100-cfgvoc[c].left*100/(-56),
    100-cfgvoc[c].right*100/(-56),c);
   vols[c]->setmute(cfgvoc[c].mutel);
  }

 textattr(7);
 for (c=0;c<5;c++)
  {
   vols[c]->draw();
   //gotoxy(16+9*c-2,3);
   //cputs(outok[c]);
   vols[c]->setvol();
  }

 int ki=0;
 int cur=0,re;
 while (!ki)
  {
   re=vols[cur]->use();
   switch(re)
   {
    case 0:ki=1;
          break;
    case 75:if (cur>0)
             cur--;
           break;
    case 77:if (cur<5-1)
             cur++;
           break;
   }
  }

 for (c=0;c<5;c++)
  {
   d=vols[c]->gettype();
   cfgvoc[d].left=vols[c]->getdbleft();
   cfgvoc[d].right=vols[c]->getdbright();
   cfgvoc[d].mutel=vols[c]->getmutel();
   cfgvoc[d].muter=vols[c]->getmuter();
  }


 ultracfgwrite();
 textattr(ti.attribute);
 //clrscr();
 _16BackColors(0);


 WaitVsyncStart();
 _fmemcpy(vidmem,origscr,4000);
 CGenModeSet();
 _fmemcpy(fontmem,origfont,32*256);
 CGenModeClear();
 gotoxy(ti.curx,ti.cury);
 _setcursortype(_NORMALCURSOR);
 //textmode(ti.currmode);
}
