Unit Matrix3D;

Interface

 Const
   D  = 200;
   KX = 719;
   KY = 347;

 Type
   HPont = object
     x,y,z : real;
     h     : Word;
   end;

   NSzog = Array[1..8] of HPont;

 Procedure Eltol(Pont : HPont; Var Eltol : HPont; x,y : real);
 Procedure Nagyit(Pont : HPont; Var Nagyit : HPont; a,b : Real);
 Procedure ForgatX(Pont : HPont; Var Forgat : HPont; a : Real);
 Procedure ForgatY(Pont : HPont; Var Forgat : HPont; a : Real);
 Procedure ForgatZ(Pont : HPont; Var Forgat : HPont; a : Real);
 Procedure Meginicializalom_a_grafikamat;
 Procedure SetUp;
 Procedure BClr;
 Procedure Draw;

Var
  DKocka : NSzog;

Implementation

 Uses Graph, Crt;

 Procedure BClr;

 Var
  ch : char;

 Begin
   While KeyPressed do ch:=ReadKey;
 End;

 Procedure Meginicializalom_a_grafikamat;

 Var
  i,j : Integer;

 Begin
  i:=detect;
  initgraph(i,j,'F:\PROGS\TURBO\TP\BGI');
  OutTextXY(150,170,'Video Card detected and put into Graphics Mode');
  Delay(1500);
  cleardevice;
  Line(0,getmaxy div 2,getmaxx,getmaxy div 2);
  Line(getmaxx div 2,0,getmaxx div 2,getmaxy);
 End;


 Procedure Eltol(Pont : HPont; Var Eltol : HPont; x,y : real);

 Begin
   Eltol.X:=Pont.X+X;
   Eltol.Y:=Pont.Y+Y;
   Eltol.Z:=Pont.Z;
   Eltol.h:=1;
 End;

 Procedure Nagyit(Pont : HPont; Var Nagyit : HPont; a,b : Real);

 Begin
  Nagyit.x:=(Pont.x*a);
  Nagyit.y:=(Pont.y*b);
  Nagyit.h:=1;
 End;

 Procedure ForgatX(Pont : HPont; Var Forgat : HPont; a : Real);

 Begin
   Forgat.X:=Pont.X;
   Forgat.Y:=(Pont.Y*Cos(a)+Pont.Z*-Sin(a));
   Forgat.Z:=(Pont.Y*Sin(a)+Pont.Z*Cos(a));
   Forgat.H:=1;
 End;

 Procedure ForgatY(Pont : HPont; Var Forgat : HPont; a : Real);

 Begin
   Forgat.X:=(Pont.X*Cos(a)+Pont.Z*-Sin(a));
   Forgat.Y:=Pont.Y;
   Forgat.Z:=(Pont.X*Sin(a)+Pont.Z*Cos(a));
   Forgat.H:=1;
 End;

 Procedure ForgatZ(Pont : HPont; Var Forgat : HPont; a : Real);

 Begin
   Forgat.X:=(Pont.X*Cos(a)+Pont.Y*-Sin(a));
   Forgat.Y:=(Pont.X*Sin(a)+Pont.Y*Cos(a));
   Forgat.Z:=Pont.Z;
   Forgat.H:=1;
 End;

 Procedure SetUp;

 Begin
   With DKocka[1] do
   begin
     X:=2; Y:=-2;
     Z:=-2; H:=2;
   end;
   With DKocka[2] do
   begin
     X:=2; Y:=-2;
     Z:=2; H:=2;
   end;
   With DKocka[3] do
   begin
     X:=-2; Y:=-2;
     Z:=2; H:=2;
   end;
   With DKocka[4] do
   begin
     X:=-2; Y:=-2;
     Z:=-2; H:=2;
   end;
   With DKocka[5] do
   begin
     X:=2; Y:=2;
     Z:=-2; H:=2;
   end;
   With DKocka[6] do
   begin
     X:=2; Y:=2;
     Z:=2; H:=2;
   end;
   With DKocka[7] do
   begin
     X:=-2; Y:=2;
     Z:=2; H:=2;
   end;
   With DKocka[8] do
   begin
     X:=-2; Y:=2;
     Z:=-2; H:=2;
   end;
 End;

 Procedure Draw;

 Begin
   With DKocka[1] do
   begin
     Line(Round(D*X/(Z+10)+KX/2), Round(KY/2-D*Y/(Z+10)),
          Round(D*DKocka[2].X/(DKocka[2].Z+10)+KX/2),
          Round(KY/2-(D*DKocka[2].Y/(DKocka[2].Z+10))));

     Line(Round(D*X/(Z+10)+KX/2), Round(KY/2-D*Y/(Z+10)),
          Round(D*DKocka[4].X/(DKocka[4].Z+10)+KX/2),
          Round(KY/2-(D*DKocka[4].Y/(DKocka[4].Z+10))));

     Line(Round(D*X/(Z+10)+KX/2), Round(KY/2-D*Y/(Z+10)),
          Round(D*DKocka[5].X/(DKocka[5].Z+10)+KX/2),
          Round(KY/2-(D*DKocka[5].Y/(DKocka[5].Z+10))));
   end;

   With DKocka[6] do
   begin
     Line(Round(D*X/(Z+10)+KX/2), Round(KY/2-D*Y/(Z+10)),
          Round(D*DKocka[2].X/(DKocka[2].Z+10)+KX/2),
          Round(KY/2-(D*DKocka[2].Y/(DKocka[2].Z+10))));

     Line(Round(D*X/(Z+10)+KX/2), Round(KY/2-D*Y/(Z+10)),
          Round(D*DKocka[5].X/(DKocka[5].Z+10)+KX/2),
          Round(KY/2-(D*DKocka[5].Y/(DKocka[5].Z+10))));

     Line(Round(D*X/(Z+10)+KX/2), Round(KY/2-D*Y/(Z+10)),
          Round(D*DKocka[7].X/(DKocka[7].Z+10)+KX/2),
          Round(KY/2-(D*DKocka[7].Y/(DKocka[7].Z+10))));
   end;

   With DKocka[3] do
   begin
     Line(Round(D*X/(Z+10)+KX/2), Round(KY/2-D*Y/(Z+10)),
          Round(D*DKocka[2].X/(DKocka[2].Z+10)+KX/2),
          Round(KY/2-(D*DKocka[2].Y/(DKocka[2].Z+10))));

     Line(Round(D*X/(Z+10)+KX/2), Round(KY/2-D*Y/(Z+10)),
          Round(D*DKocka[4].X/(DKocka[4].Z+10)+KX/2),
          Round(KY/2-(D*DKocka[4].Y/(DKocka[4].Z+10))));

     Line(Round(D*X/(Z+10)+KX/2), Round(KY/2-D*Y/(Z+10)),
          Round(D*DKocka[7].X/(DKocka[7].Z+10)+KX/2),
          Round(KY/2-(D*DKocka[7].Y/(DKocka[7].Z+10))));
   end;

   With DKocka[8] do
   begin
     Line(Round(D*X/(Z+10)+KX/2), Round(KY/2-D*Y/(Z+10)),
          Round(D*DKocka[5].X/(DKocka[5].Z+10)+KX/2),
          Round(KY/2-(D*DKocka[5].Y/(DKocka[5].Z+10))));

     Line(Round(D*X/(Z+10)+KX/2), Round(KY/2-D*Y/(Z+10)),
          Round(D*DKocka[4].X/(DKocka[4].Z+10)+KX/2),
          Round(KY/2-(D*DKocka[4].Y/(DKocka[4].Z+10))));

     Line(Round(D*X/(Z+10)+KX/2), Round(KY/2-D*Y/(Z+10)),
          Round(D*DKocka[7].X/(DKocka[7].Z+10)+KX/2),
          Round(KY/2-(D*DKocka[7].Y/(DKocka[7].Z+10))));
   end;
 End;

End.
