#include <alloc.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <dos.h>


#include "..\fontload.h"


font::font( char *fnev )
{
 loaded=0;
 mialloc=0;

 filenev=(char *)malloc(strlen(fnev)+1);
 strcpy(filenev,fnev);
}

int font::load( void )
{
 if ( !filenev )
  return(-1);

 if ( loaded )
  return(-1);

 int fh;
 if ( (fh=open(filenev,O_BINARY | O_RDWR))==-1)
  return(-1);
 fontdata=(char *)malloc(4096);
 if ( (read(fh,fontdata,4096))==-1)
  {
   free(fontdata);
   return(-1);
  }
 close(fh);
 mialloc = 1;
 loaded = 1;
 return(0);
}

extern "C" void far WaitVsyncStart(void); //***!fixup

int font::set( void )
{
 if ( !loaded ) return( -1 );


 REGPACK reg;

 reg.r_ax = 0x1100;                // Set CHARACTER SET
 reg.r_bx = 0x1000;               // Font Block & Count of bytes
 reg.r_cx = 0x0100;              // Number of chars
 reg.r_dx = 0x0;                // Offset
 reg.r_es = FP_SEG(fontdata);
 reg.r_bp = FP_OFF(fontdata);

 WaitVsyncStart();
 intr(0x10, &reg);

 return(0);
}


int font::mem( char *data )
{
 if ( !data ) return( -1 );
 if ( mialloc )
  {
   free(fontdata);
   mialloc=0;
  }
 fontdata=data;
 loaded=1;
 return(0);
}

int font::memload( char far *data )
{
 if ( !data ) return( -1 );
 if ( mialloc )
  {
   free(fontdata);
   mialloc=0;
  }
 fontdata=(char *)malloc(4096);
 mialloc = 1;
 _fmemcpy(fontdata,data,4096);
 loaded=1;
 return(0);
}

int font::unload( void )
{
 if ( !fontdata ) return(-1);
 free(fontdata);
 mialloc=0;
 loaded=0;
 return(0);
}

void font::~font( void )
{
 if ( filenev ) free(filenev);

 if ( !loaded ) return;

 if ( mialloc ) free(fontdata);
}

