 /* This program traps disk errors and prompts the user for action. */
/* Try running it with no disk in drive A to invoke its functions. */

#include <stdio.h>
#include <ctype.h>
#include <dos.h>
#include <fcntl.h>

int buf[500];

/* define the error messages for trapping disk problems */
static char *err_msg[] =
{
  "write protect",   "unknown unit",
  "drive not ready", "unknown command",
  "data error (CRC)","bad request",
  "seek error",      "unknown media type",
  "sector not found","printer out of paper",
  "write fault",     "read fault",
  "general failure", "reserved",
  "reserved",        "invalid disk change"
};

static void mesg(char *s)
{
  while (*s)
    bdos(2,*s++,0);
}

static int getkey(void)
{
  return (bdos(7, 0, 0) & 0xff);
}

error_win(char *msg)
{
  int c;

  /* prompt user to press a key to abort, retry, ignore, fail */
  while(1)
  {
    mesg(msg);
    c = tolower(getkey());
    mesg("\r\n");
    switch (c)
    {
    case 'a':
      return (_HARDERR_ABORT);
    case 'r':
      return (_HARDERR_RETRY);
    case 'i':
      return (_HARDERR_IGNORE);
    case 'f':
      return (_HARDERR_FAIL);
    }
  }
}

/* pragma warn -par reduces warnings which occur due to the */
/* nonuse of the parameter devhdr */
#pragma warn -par

void far handler(unsigned deverr, unsigned errval, unsigned far *devhdr)
{
  static char msg[80];
  int drive;
  int errorno;

  /* if this not disk error then another device having trouble */
  if (deverr & 0x8000) {
    error_win("Device error");     /* report the error */

    /* return to the program directly requesting abort */
    _hardretn(5);                  /* 5 = DOS "access denied" error */
  }
  drive = deverr & 0x00FF;          /* otherwise it was disk error */
  errorno = errval & 0x00FF;

  /* report which error it was */
  sprintf(msg, "Error: %s on drive %c\r\nA)bort, R)etry, I)gnore, F)ail: ",
    err_msg[errorno], 'A' + drive);

  /* return to program via dos interrupt 0x23 with abort, retry */
  /* or ignore as input by the user */
  _hardresume(error_win(msg));
}

#pragma warn +par

int main(void)
{
  int handle;

  /* install our handler on the hardware problem interrupt */
  _harderr(handler);
  printf("Make sure there is no disk in drive A:\n");
  printf("Press any key ....\n");
  getkey();
  printf("Trying to access drive A:\n");
  printf("_dos_open returned 0x%x\n",
    _dos_open("A:temp.dat", O_RDONLY, &handle));
  return 0;
}
