#include <dos.h>
#include <string.h>

const
 EMSLapMeret = 0x4000 ;

#define EMSint  0x67

//Type
//  EMSTomb = Array[1..255] Of Record
//                               Kezeloszam,
//                               Lapszam     : Word ;
//                             End ;
/*
struct
 {
  unsigned kezeloszam;
  unsigned lapszam;
 }
  EMSTomb[256];
*/
//Var
//  EMSOk : Byte ;

int EMSOk;

/*
Function  EMSHibaSzoveg(EMMHibaKod: Byte) : String ;
Function  EMSJelen : Boolean ;
Function  EMSKeretCim : Word ;
Function  EMSSzabad : Word ;
Function  EMSTeljes : Word ;
Procedure EMSFoglal(Var EMMKezelo: Word; EMSLapszam: Word) ;
Procedure EMSKeret(EMMKezelo: Word; EMSLap: Word; KeretLap: Byte);
Procedure EMSFelszabadit(EMMKezelo: Word) ;
Function  EMSVerzio : Word ;
Function  EMSKezelokSzama : Word ;
Function  EMSLapszam(EMMKezelo: Word) : Word ;
Procedure EMSKezeloInfo(Var EMMKezelokSzama: Word ;
                        Var EMMKezelok) ;

Implementation
*/

char *EMShibaszoveg( int EMMHibaKod )
{
 switch (EMMHibaKod)
  {
   case 0x00:return("EMS van, hardver rendben");
   case 0x80:return("EMS szoftver hiba");
   case 0x81:return("EMS hardver hiba");
   case 0x83:return("Az EMM nem tart nyilvn ilyen kezelszmot");
   case 0x84:return("Nincs ilyen EMM funkci");
   case 0x85:return("Minden EMM kezelszm foglalt");
   case 0x86:return("Mentsi/visszatltsi hiba");
   case 0x87:return("Nincs elg EMS lap");
   case 0x88:return("Nincs elg szabad EMS lap");
   case 0x89:return("0 lapot nem lehet alloklni");
   case 0x8A:return("A lapszm nem esik az EMM kezel tartomnyba");
   case 0x8B:return("A lapszm nem esik a keret tartomnyba");
   case 0x8C:return("Hardver mentsi terlet betelt");
   case 0x8D:return("Hardver mentsi terlet foglalt");
   case 0x8E:return("Nincs ilyen hardver mentsi terlet");
   case 0x8F:return("Nincs ilyen EMM alfunkci");
   default:return("Ismeretlen vagy 4.0-s/nl jabb verzi hibakdja");
  }
}

/*
Function  EMSJelen : Boolean ;
  Type
    KarTomb = Array[1..8] Of Char ;
  Const
    EMSEllenorzo : KarTomb = 'EMMXXXX0' ;
  Var
    R         : Registers ;
    EMSVektor : Pointer ;
  Begin
    With R Do
      Begin
        GetIntVec($67,EMSVektor) ;
        EMSVektor := Ptr(Seg(EMSVektor^),10) ;
        EMSJelen := KarTomb(EMSVektor^) = EMSEllenorzo ;
        EMSOk := AH ;
      End ;
  End ;
*/


                          /*  Alap funkcik  */

int EMSjelen( void )
{
 char far *EMSVektor;
 void interrupt ( *EMSHandler)(...);
 char EMSEllenorzo[] = "EMMXXXX0";

 EMSHandler = getvect(EMSint);
 EMSVektor = (char far *)MK_FP( FP_SEG((char far *)EMSHandler),0xA);
 if (_fstrncmp(EMSVektor,EMSEllenorzo,8))
  return 0;

 union REGS regs;

 regs.h.ah = 0x40;  // EMS int check
 int86(EMSint, &regs, &regs);
 EMSOk=regs.h.ah;
 return 1;
}

unsigned EMSkeretcim( void )
{
 union REGS regs;

 regs.h.ah = 0x41;
 int86(EMSint, &regs, &regs);
 EMSOk=regs.h.ah;
 return regs.x.bx;
}

int EMSszabad( void )
{
 union REGS regs;

 regs.h.ah = 0x42;
 int86(EMSint, &regs, &regs);
 EMSOk=regs.h.ah;
 return regs.x.bx;
}

int EMSteljes( void )
{
 union REGS regs;

 regs.h.ah = 0x42;
 int86(EMSint, &regs, &regs);
 EMSOk=regs.h.ah;
 return regs.x.dx;
}

void EMSfoglal( int *EMMKezelo, int EMSLapszam )
{
 union REGS regs;

 regs.h.ah = 0x43;
 regs.x.bx = EMSLapszam;
 int86(EMSint, &regs, &regs);
 EMSOk=regs.h.ah;
 (*EMMKezelo)=regs.x.dx;
}

void EMSkeret( int EMMKezelo, int EMSLap, char keretlap )
{
 union REGS regs;

 regs.h.ah = 0x44;
 regs.h.al = keretlap;
 regs.x.dx = EMMKezelo;
 regs.x.bx = EMSLap;
 int86(EMSint, &regs, &regs);
 EMSOk=regs.h.ah;
}

void EMSfelszabadit( int EMMKezelo )
{
 union REGS regs;

 regs.h.ah = 0x45;
 regs.x.dx = EMMKezelo;
 int86(EMSint, &regs, &regs);
 EMSOk=regs.h.ah;
}

int EMSverzio( void )
{
 union REGS regs;

 regs.h.ah = 0x46;
 int86(EMSint, &regs, &regs);
 EMSOk=regs.h.ah;
 return( ((int)(regs.h.al & 0xF) << 8) + (int)(regs.h.al & 0xF0) >> 4 );
}

int EMSkezelokszama( void )
{
 union REGS regs;

 regs.h.ah = 0x4B;
 int86(EMSint, &regs, &regs);
 EMSOk=regs.h.ah;
 return regs.x.bx;
}

int EMSlapszam( int EMMKezelo )
{
 union REGS regs;

 regs.h.ah = 0x4C;
 regs.x.dx = EMMKezelo;
 int86(EMSint, &regs, &regs);
 EMSOk=regs.h.ah;
 return regs.x.bx;
}

/*
Procedure EMSKezeloInfo(Var EMMKezelokSzama: Word ;
                        Var EMMKezelok) ;
  Var
    R : Registers ;
  Begin
    With R Do
      Begin
        AH := $4D ;
        ES := Seg(EMMKezelok) ;
        DI := Ofs(EMMKezelok) ;
        Intr($67,R) ;
        EMMKezelokSzama := BX ;
        EMSOk := AH ;
      End ;
  End ;

End.
*/