/* draw.c */
/* Vonalrajzol s krhz rutinok. */

#include <if.h>


/* Cursor. */
static int curx=0, cury=0;
static int curcolor=0;


/* Szn bellts. */
void grsetcolor(int color){

  curcolor=color;
}


/* Szn lekrdezse. Visszatr a sznkddal. */
int grgetcolor(void){

  return(curcolor);
}


/* A cursort (x,y)-ba viszi. */
void grmoveto(int x, int y){

  curx=x; cury=y;
}


/* x lekrdezse. */
int grgetx(void){

  return(curx);
}


/* y lekrdezse. */
int grgety(void){

  return(cury);
}


/* Vonalhzs (x0,y0)-bl (x1,y1)-ba. */
void grline(int x0, int y0, int x1, int y1){
  int dd;
  int dx, dy;

	/*-------*/
	/* \3|2/ */
	/* 4\|/1 */
	/* --*-- */
	/* 5/|\8 */
	/* /6|7\ */
	/*-------*/

  grputpixel(x0,y0,curcolor);
  if (y1>y0){				/* 1,2,3,4 */
    dy=y1-y0;
    if (x1>x0){				/* 1,2 */
      dx=x1-x0;
      if (dx>dy){			/* 1 */
	dd=dx/2;
	while (x0!=x1){
	  dd+=dy;
	  if (dd>dx){
	    grputpixel(++x0,++y0,curcolor);
	    dd-=dx;
	  } else {
	    grputpixel(++x0,y0,curcolor);
	  }
	}
      } else {				/* 2 */
	dd=dy/2;
	while (y0!=y1){
	  dd+=dx;
	  if (dd>dy){
	    grputpixel(++x0,++y0,curcolor);
	    dd-=dy;
	  } else {
	    grputpixel(x0,++y0,curcolor);
	  }
	}
      }
    } else {				/* 3,4 */
      dx=x0-x1;
      if (dx>dy){			/* 4 */
	dd=dx/2;
	while (x0!=x1){
	  dd+=dy;
	  if (dd>dx){
	    grputpixel(--x0,++y0,curcolor);
	    dd-=dx;
	  } else {
	    grputpixel(--x0,y0,curcolor);
	  }
	}
      } else {				/* 3 */
	dd=dy/2;
	while (y0!=y1){
	  dd+=dx;
	  if (dd>dy){
	    grputpixel(--x0,++y0,curcolor);
	    dd-=dy;
	  } else {
	    grputpixel(x0,++y0,curcolor);
	  }
	}
      }
    }
  } else {				/* 5,6,7,8 */
    dy=y0-y1;
    if (x1>x0){				/* 7,8 */
      dx=x1-x0;
      if (dx>dy){			/* 8 */
	dd=dx/2;
	while (x0!=x1){
	  dd+=dy;
	  if (dd>dx){
	    grputpixel(++x0,--y0,curcolor);
	    dd-=dx;
	  } else {
	    grputpixel(++x0,y0,curcolor);
	  }
	}
      } else {				/* 7 */
	dd=dy/2;
	while (y0!=y1){
	  dd+=dx;
	  if (dd>dy){
	    grputpixel(++x0,--y0,curcolor);
	    dd-=dy;
	  } else {
	    grputpixel(x0,--y0,curcolor);
	  }
	}
      }
    } else {				/* 5,6 */
      dx=x0-x1;
      if (dx>dy){			/* 5 */
	dd=dx/2;
	while (x0!=x1){
	  dd+=dy;
	  if (dd>dx){
	    grputpixel(--x0,--y0,curcolor);
	    dd-=dx;
	  } else {
	    grputpixel(--x0,y0,curcolor);
	  }
	}
      } else {				/* 6 */
	dd=dy/2;
	while (y0!=y1){
	  dd+=dx;
	  if (dd>dy){
	    grputpixel(--x0,--y0,curcolor);
	    dd-=dy;
	  } else {
	    grputpixel(x0,--y0,curcolor);
	  }
	}
      }
    }
  }
}


/* Vonalhzs a cursortl (x1,y1)-ba */
void grlineto(int x1, int y1){

  grline(curx,cury,x1,y1);
  curx=x1; cury=y1;
}


/* Kr rajzolsa. Kzppont (x0,y0), sugr r. */
void grcircle(int x0, int y0, int r){
  int x, y;
  int xy;

/* xy===x*x+y*y-r*r-r */
  xy=-r; x=0; y=r;
  grputpixel(x0,y0+r,curcolor);
  grputpixel(x0,y0-r,curcolor);
  grputpixel(x0+r,y0,curcolor);
  grputpixel(x0-r,y0,curcolor);
  while (y>x){
    xy+=((x++)<<1)+1;
    if (xy>0) xy+=-((y--)<<1)+1;
    grputpixel(x0+x,y0+y,curcolor);
    grputpixel(x0-x,y0+y,curcolor);
    grputpixel(x0-x,y0-y,curcolor);
    grputpixel(x0+x,y0-y,curcolor);
    grputpixel(x0+y,y0+x,curcolor);
    grputpixel(x0-y,y0+x,curcolor);
    grputpixel(x0-y,y0-x,curcolor);
    grputpixel(x0+y,y0-x,curcolor);
  }
}







