/*--->  Teszt Monitor a filekezelok tesztelesehez  <---*/
/*--->        dBase C-interface tesztelese         <---*/
/*
 *	Egy parancsfile-bol olvassa a vegrehajtando
 *	parancsokat es az eredmenyfile-ba irja ki
 */

/*$-g*/
#include <stdio.h>

#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

#define	CREAT		'k'
#define	OPEN		'o'
#define	CLOSE		'c'

#define	FIRST		's'
#define	LAST		'a'
#define	NEXT		'n'
#define	PREV		'p'

#define	ADD		'i'
#define	FILL		'f'
#define	DELETE		'd'
#define	READ		'r'
#define	READUPDATE	'R'
#define	UPDATE		'u'
#define	LIST		'l'

#define	MAXBUFF		100


char	cmdbuff[MAXBUFF];


char	starttime[9];		/* bufferek ido lekerdezesehez	*/
char	endtime[9];


char	*ndxid1 = NULL;
char	*ndxid2 = NULL;
char	*dbfid  = NULL;

char	*ndxname1 = "PROBA.001";
char	*ndxname2 = "PROBA.002";
char	*dbfname  = "PROBA.DAT";

LOCK	lock;

struct	 RECORD
	{
	int	recnum;
	char	binrecnum[20];
	char	text[50];
	} datarec;


dBFIELD dbfield[3];


main()
{
char	ch;
char	*q;
char	*fgets();


if (is_network() == 1)
	printf("Halozat !\n\n");
else
	printf("Nem halozat !\n\n");


strcpy(lock.s_name,dbfname);

while (fgets(cmdbuff,MAXBUFF,stdin) != NULL)
	{
	sscanf(cmdbuff,"%c",&ch);
	q = cmdbuff + 1;

	switch (ch) {
	case CREAT:
		do_creat();
		break;
	case OPEN:
		do_open();
		break;
	case CLOSE:
		do_close();
		break;

	case FIRST:
		do_first(q);
		break;
	case LAST:
		do_last(q);
		break;
	case NEXT:
		do_next(q);
		break;
	case PREV:
		do_prev(q);
		break;

	case ADD:
		do_add(q);
		break;
	case FILL:
		do_fill(q);
		break;
	case DELETE:
		do_delete(q);
		break;
	case READ:
		do_read(q);
		break;

	case READUPDATE:
		do_readupd(q);
		break;
	case UPDATE:
		do_update(q);
		break;

	case LIST:
		do_list(q);

	}
	}


} /* main */



int do_creat()
/*
 *	Adatfile + ket indexfile letrehozasa standard parameterekkel
 */

{
if (dBicreat(ndxname1,"recnum",8,'N') != 0)
	fatal("Elso indexfile letrehozasi hiba !");

if (dBicreat(ndxname2,"binrecnum",20,'C') != 0)
	fatal("Masodik indexfile letrehozasi hiba !");

} /* end of do_creat() */



int do_open()
/*
 *	Az adatbazis megnyitasa
 */

{
if (read_lock(&lock) != 0)
	{
	error("Olvasasi muvelet nem indithato !");
	return;
	}

if (dBiopen(ndxname1,&ndxid1) != 0)
	fatal("Elso indexfile nyitasi hiba !");

if (dBiopen(ndxname2,&ndxid2) != 0)
	fatal("Masodik indexfile nyitasi hiba !");

read_release(&lock);
} /* end of do_open() */

 do_close()
/*
 *	Az adatbazis zarasa
 */

{
if (wlock() != 0)
	return;

if (dBiclose(ndxid1) != 0)
	fatal("Elso indexfile zarasi hiba !");

if (dBiclose(ndxid2) != 0)
	fatal("Masodik indexfile zarasi hiba !");

wrelease();
} /* end of do_close() */


int do_first(q)
/*
 *	A megadott indexfile elejere pozicional
 */
char	*q;		/* parancsbuffer	*/

{
int	indexnum;
int	rc;

sscanf(q,"%d",&indexnum);
if (indexnum == 1)
	rc = dBrewind(ndxid1);
else
	rc = dBrewind(ndxid2);

if (rc != 0)
	fatal("Indexfile pozicionalasi hiba !");

} /* end of do_first() */
	


int do_last(q)
/*
 *	A megadott indexfile vegere pozicional
 */
char	*q;		/* parancsbuffer	*/

{
int	indexnum;
int	rc;

sscanf(q,"%d",&indexnum);
if (indexnum == 1)
	rc = dBfwd(ndxid1);
else
	rc = dBfwd(ndxid2);

if (rc != 0)
	fatal("Indexfile pozicionalasi hiba !");

} /* end of do_last() */
	


int do_next(q)
/*
 *	A megadott indexfile szerint a kovetkezo rekordot olvassa be
 */
char	*q;		/* parancsbuffer	*/

{
int	indexnum;

sscanf(q,"%d",&indexnum);
nextrec(indexnum);

} /* end of do_next() */



nextrec(indexnum)
/*
 *	Eloveszi a kovetkezo rekordot
 */
int	indexnum;		/* melyik indexfile alapjan	*/

{
int	rc;
char	key[100];
RECNUM	recno;

if (rlock() != 0)
	return;

if (indexnum == 1)
	rc = dBnkey(ndxid1,key,&recno);
else
	rc = dBgetnr(ndxid2,key,&recno);

if (rc != 0)
	error("Nincs kovetkezo rekord !");
else
	{
	fprintf(stdout,"Key: %s\n",key);
	fprintf(stdout,"Recno: %ld\n",recno);
	}

rrelease();
return(rc);
} /* end of do_next() */



int do_prev(q)
/*
 *	A megadott indexfile szerint az elozo rekordot olvassa be
 */
char	*q;		/* parancsbuffer	*/

{
int	indexnum;

sscanf(q,"%d",&indexnum);
prevrec(indexnum);

} /* end of do_prev() */



int prevrec(indexnum)
/*
 *	Eloveszi az elozo rekordot
 */
int	indexnum;	/* melyik indexfile-bol	*/

{
int	rc;
char	key[100];
RECNUM	recno;

if (rlock() != 0)
	return;

if (indexnum == 1)
	rc = dBpkey(ndxid1,key,&recno);
else
	rc = dBpkey(ndxid2,key,&recno);

if (rc != 0)
	error("Nincs elozo rekord !");
else
	{
	fprintf(stdout,"Key: %s\n",key);
	fprintf(stdout,"Recno: %ld\n",recno);
	}

rrelease();
return(rc);
} /* end of prevrec() */



int do_add(q)
/*
 *	Adatrekord bevitele az adatbazisba
 */
char	*q;		/* parancsbuffer	*/

{
sscanf(q,"%d %s",&datarec.recnum,datarec.text);
itoa(datarec.recnum,datarec.binrecnum,2);

addrec();

} /* end of do_add() */


int addrec()
/*
 *	Adatrekord beszurasa
 */

{
char	key[128];
RECNUM	recno;

itoa(datarec.recnum,key,10);

scankey(key,key,20,'N');

if (wlock() != 0)
	return;

if (dBputrk(dbfid,ndxid1,key,(char *)&datarec) != 0)
	fatal("dBputrk hiba !");

if (dBtkey(ndxid1,key,&recno) != 0)
	fatal("dBputrk utan nincs meg a kulcs !");

scankey(&datarec.binrecnum[0],key,20,'C');

if (dBakey(ndxid2,key,recno) != 0)
	fatal("dBputrk utan masodik kulcs beszurasa !");

wrelease();
} /* end of addrec() */



int do_fill(q)
/*
 *	Az adatbazis ciklikus feltoltese
 */
char	*q;		/* parancsbuffer	*/

{
int	from,to,diff;

sscanf(q,"%d %d %d %s",&from,&to,&diff,datarec.text);

for (; from != to; from+=diff)
	{
	fprintf(stdout,"%d\n",from);
	datarec.recnum = from;
	itoa(from,datarec.binrecnum,2);
	addrec();
	}

} /* end of do_fill() */



int do_delete(q)
/*
 *	Rekord fizikai torlese az adatbazisbol
 */
char	*q;		/* parancsbuffer	*/

{
int	index;
char	key[128];
int	rc;
RECNUM	recno;

sscanf(q,"%d",&index);

if (wlock() != 0)
	return;

if (findkey(1,index,key,&recno) != 0)
	return;


if (lock_record(dbfname,(DBFFILE *)dbfid,recno) == 2)
	{
	error("The record is locked !");
	return;
	} 
release_record(dbfname,(DBFFILE *)dbfid,recno);


if (dBrmvkey(ndxid1,key,recno) != 0)
	fatal("Megtalalt kulcs torlese !");

if (findkey(2,index,key,&recno) != 0)
	return;

if (dBrmvkey(ndxid2,key,recno) != 0)
	fatal("Megtalalt kulcs torlese !");

if (dBdelete(dbfid,recno) != 0)
	fatal("Kulcshoz tartozo rekord torlese !");

wrelease();
} /* end of do_delete() */


int findkey(indexnum,index,key,recno)
/*
 *	A megadott indexfileban elokeresi a kulcsot
 */
int	indexnum;
int	index;
char	*key;
RECNUM	*recno;

{
int	rc = 0;
char	*idxid;

if (indexnum == 1)
	{
	idxid = ndxid1;
	itoa(index,key,10);
	scankey(key,key,20,'N');
	}
else
	{
	idxid = ndxid2;
	itoa(index,key,2);
	scankey(key,key,20,'C');
	}

if ((rc = dBtkey(idxid,key,recno)) != 0)
	error("Nincs meg a keresett kulcs !");

return(rc);
} /* end of findkey() */


int do_read(q)
/*
 *	Adott kulcs szerint adatrekord beolvasasa
 */
char	*q;		/* parancsbuffer	*/

{
int	indexnum;
int	index;

sscanf(q,"%d %d",&indexnum,&index);
readrec(indexnum,index);

} /* end of do_read() */


int readrec(indexnum,index)
/*
 *	Generalja a kulcsot es a tenyleges beolvasast vegzi
 */
int	indexnum;
int	index;

{
char	key[128];
int	rc = 0;
char	*idxid;
char 	status;

if (indexnum == 1)
	{
	idxid = ndxid1;
	itoa(index,key,10);
	scankey(key,key,20,'N');
	}
else
	{
	idxid = ndxid2;
	itoa(index,key,2);
	scankey(key,key,20,'C');
	}

if (rlock() != 0)
	return;

if ((rc = dBgetrk(dbfid,idxid,key,(char *)&datarec,&status)) != 0)
	error("Nincs meg az adatrekord !");
else
	printrec(&datarec);

rrelease();
return(rc);
} /* end of readrec() */



int do_list(q)
/*
 *	Adatbazis listazasa
 */
char	*q;		/* parancsbuffer	*/

{
int	indexnum;
int	from,count,dir;
int	rc;

sscanf(q,"%d %d %d %d",&indexnum,&from,&count,&dir);

rc = readrec(indexnum,from);
while ((rc == 0) && (--count > 0))
	if (dir < 0)
		rc = prevrec(indexnum);
	else
		rc = nextrec(indexnum);

} /* end of do_list() */




int do_readupd(q)
/*
 *	Adott kulcs szerint adatrekord beolvasasa modositasra
 */
char	*q;		/* parancsbuffer	*/

{
int	indexnum;
int	index;
char	key[128];
RECNUM	recno;
int	rc = 0;
char	*idxid;
char	status;

sscanf(q,"%d %d",&indexnum,&index);
if (indexnum == 1)
	{
	idxid = ndxid1;
	itoa(index,key,10);
	scankey(key,key,20,'N');
	}
else
	{
	idxid = ndxid2;
	itoa(index,key,2);
	scankey(key,key,20,'C');
	}

if (rlock() != 0)
	return;

if ((rc = dBtkey(idxid,key,&recno)) != 0)
	error("Nincs meg a kulcs !");

if (rc == 0)
	if ((rc = dBgetr(dbfid,recno,(char *)&datarec,&status)) != 0)
		error("Olvasasi hiba !");

if (rc == 0)
	switch (rc = lock_record(dbfname,(DBFFILE *)dbfid,recno))
	{
	case 1:
		error("Two locks in the same program is impossible !");
		break;
	case 2:
		error("The record is locked !");
		break;
	} 

if (rc == 0)
	printrec(&datarec);

rrelease();
return(rc);
} /* end of do_readupd() */




int do_update(q)
/*
 *	Adatrekord felulirasa az adatbazisban
 */
char	*q;		/* parancsbuffer	*/

{
char	key[128];
RECNUM	recno;

sscanf(q,"%d %s",&datarec.recnum,datarec.text);
itoa(datarec.recnum,datarec.binrecnum,2);

itoa(datarec.recnum,key,10);

scankey(key,key,20,'N');

if (wlock() != 0)
	return;

if (dBtkey(ndxid1,key,&recno) != 0)
	fatal("Nincs meg a felulirando rekord !");

if (dBupdr(dbfid,recno,(char *)&datarec) != 0)
	fatal("dBupdr hiba !");

release_record(dbfname,(DBFFILE *)dbfid,recno);
wrelease();
} /* end of do_update() */



int calculate(stop,start)
/*
 *	Start, stop ido oo:pp:mm formaban
 *	Kiszamolja a ketto kulonbseget masodpercben
 */
char	*start,*stop;

{
register int	diff_in_sec = 0;

diff_in_sec = (atoi(stop) - atoi(start)) * 60;
diff_in_sec += (atoi(stop+3) - atoi(start+3));
diff_in_sec *= 60;
diff_in_sec += atoi(stop+6);
diff_in_sec -= atoi(start+6);

return(diff_in_sec);
}


scankey(inbuff,key,keylen,keytype)
char	*inbuff;
char	*key;
int	keylen;
char	keytype;

{
BYTE	akey[128];
int	i, rc, inputlen;
BYTE	*cptr1,*cptr2;


cptr1 = akey;
for (i=1; i<=keylen; i++)
	*cptr1++ = ' ';

strcpy(akey,inbuff);

inputlen = strlen(akey);
*(akey + inputlen) = ' ';

if (keytype != 'C')
	{
	*(akey + inputlen) = 0;
	*key = 'N';
	rc = dBatokey(akey, key);
	if (rc != SUCCESS)
	{
		fprintf(stderr,"Failure in converting ASCII to NUMERIC KEY");
		return(rc);
	}
}
else
{
	cptr1 = key + (keylen-1);
	cptr2 = akey + inputlen;
	for (; cptr2 >= akey; )
		*cptr1-- = *cptr2--;
	for (; cptr1 >= key; )
		*cptr1-- = ' ';
}

return(SUCCESS);

} /* end of scankey() */



int rlock()
/*
 *	Read lock az adatbazisra + adminisztracio kezelese
 */

{
int	rc;

if ((rc = read_lock(&lock)) != 0)
	error("Olvasasi muvelet nem indithato !");
else
	{
/*	dBclrbuf((DBFFILE *)dbfid);*/
	dBclibuf((NDXFILE *)ndxid1);
	dBclibuf((NDXFILE *)ndxid2);
	}
return(rc);
} /* end of rlock() */


int rrelease()
/*

 *	Read lock felszabaditasa
 */

{
read_release(&lock);
} /* end of rrelease() */


int wlock()
/*
 *	Write lock az adatbazisra + adminisztracio
 */

{
int	rc;

if ((rc = write_lock(&lock)) != 0)
	error("Irasi muvelet nem indithato !");
else
	{
/*	dBclrbuf((DBFFILE *)dbfid);*/
	dBclibuf((NDXFILE *)ndxid1);
	dBclibuf((NDXFILE *)ndxid2);
	}
return(rc);
} /* end of wlock() */


int wrelease()
/*
 *	Write lock felszabaditasa
 */

{
/*dBflush(dbfid);*/
dBiflsh(ndxid1);
dBiflsh(ndxid2);

write_release(&lock);
} /* end of wrelease() */


int printrec(rec)
/*
 *	Adatrekord kiirasa
 */
struct RECORD *rec;

{
fprintf(stdout,"%d - %20s - %s\n",rec->recnum,rec->binrecnum,rec->text);
}



int fatal(msg)
/*
 *	Hibauzenet + abortal
 */
char	*msg;

{
fprintf(stdout,"\n\n%s\n",msg);
exit(1);
}


int error(msg)
/*
 *	Hibauzenet
 */
char	*msg;

{
fprintf(stdout,"\n%s\n",msg);
}


/*--->  end of TESZT.C  <---*/

