/***************************************************************
 * Copyright (C) 1984, 1985, 1986   -   All Rights Reserved    *
 *                                                             *
 * Lattice, Inc.                                               *
 * Glen Ellyn, Illinois                                        *
 * U. S. A.                                                    *
 *                                                             *
 * Author: Billy Shakespeare & Company                         *
 ***************************************************************/
/*****************************
 *        STDYDBC1.C         *
 *****************************/
 /***********************************************************************
 * This file contains study-functions that call the dBC functions that  *
 * access a data file(.DBF).                                            *
 ************************************************************************/


#include <stdio.h>
/*$-g*/
#include "dbc.h"
/*$+g*/

/* extern statements for refering global data */
extern char dbfname[], ndxname[], dbtname[];
extern char *dbfid, *ndxid, *dbtid;
#define LENGTH 4100
extern char recbuf[];

/* extern function statements */
extern void readin(), gendump(); /* written in STUDYDBC.C */


/******* tBcreate *********/
int tBcreat()
{
int nofields, j;
dBFIELD *fields, *fldptr;
int i, rc;
char cbuf[40], *cptr;
extern long inputnum();
extern int dBcreat();
extern char *malloc();
extern int  free();

printf("\nSYNOPSIS:     int dBcreat(dbfname, nofields, fields)");
printf("\n                     char    *dbfname;");
printf("\n                     char    nofields;");
printf("\n                     dBFIELD fields[];");

if (!(fields = (dBFIELD *) malloc( (U2BYTES) sizeof(dBFIELD) * 128)))
{
	printf("\nSTUDYDBC: not enough memory space available");
	return(-1);
}

printf("\n\ndbfname == %s", dbfname);
if (!dbfname[0])
{
	printf("\nYou have not specify a data file name.");
	printf("\nSpecify the file name by entering selection 90");
	printf("\nbefore you create the file");
	return(-1);
}

printf("\nEnter number of fields per record(nofields) > ");
nofields = (int) inputnum();
fldptr = fields;
for (i=1; i<=nofields; i++, fldptr++)
{
	printf("\n\n *** FIELD NUMBER : %d ***", i);
	printf("\nEnter field name > ");
	readin(cbuf);
        for (j=0, cptr=cbuf; j<=9; j++) fldptr->fieldnm[j] = *cptr++;
					fldptr->fieldnm[10] = 0;
	printf("\nEnter field type:");
	printf("\nC {character}, N {numeric}, L {logical}, D {date}");
	printf(" or M {Memo} > ");
	readin(cbuf);
	fldptr->type = *cbuf;
	printf("\nEnter field width:");
	printf("\n(any integer value if field type is 'L', 'D' or 'M') > ");
	j = (int) inputnum();
	fldptr->width = (char) j;
	printf("\nEnter number of decimal places:");
	printf("\n(any integer value if field type is NOT 'N' > ");
	j = (int) inputnum();
	fldptr->dec = (char) j;
}

rc = dBcreat(dbfname, (FLDNUM) nofields, fields);

free( (char*) fields);

return(rc);
} /* end of tBcreat() */


/********* tBopen ********/
int tBopen()
{
int rc;
extern int dBopen();

printf("\nSYNOPSIS:     int dBopen(dbfname, dbffd)");
printf("\n\ndbfname == %s", dbfname);

if (dbfid != (char *) 0)
{
	printf("\n\007Data file already open!");
	printf("\nIf you want to open another date file, ");
	printf("close the current one first.");
	return(-1);
}
if (!dbfname[0])
{
	printf("\nYou have not specify a data file name.");
	printf("\nSpecify the file name by entering selection 90");
	printf("\nbefore you open the file");
	return(-1);
}

printf("\nOpening the data file: %s .............", dbfname);

rc = dBopen(dbfname, &dbfid);

if (rc == SUCCESS) printf("File successfully opened!");

return(rc);

} /* end of tBopen() */

/********* tBclose ********/
int tBclose()
{
int rc;
extern int dBclose();

printf("\nSYNOPSIS:     int dBclose(dbffd)");
printf("\n\nClosing the data file: %s .............", dbfname);

rc = dBclose(dbfid);

dbfid = (char *) 0;

return(rc);

} /* end of tBclose() */


/****** tBgetr ********/
int tBgetr()
{
RECNUM recno;
int rc;
RECLEN reclen;
char month, day, year;
FLDNUM nofields;
dBFIELD *fields;
char status;
extern int dBgetf(), dBgetr();
extern long inputnum();
extern char *malloc();
extern int  free();

printf("\nSYNOPSIS:     int dBgetr(dbffd, recno, recbuf, status)");

if (!(fields = (dBFIELD *) malloc( (U2BYTES) sizeof(dBFIELD) * 128)))
{
	printf("\nSTUDYDBC: not enough memory space available");
	return(-1);
}

printf("\nEnter recno > ");
recno = (RECNUM) inputnum();

rc = dBgetf(dbfid, &reclen, &month, &day, &year, &nofields, fields);

free( (char*) fields);

if (rc != SUCCESS)
{
	printf("\nSTUDYDBC: error detected by dBgetf() ");
	return(rc);
}

rc = dBgetr(dbfid, recno, recbuf, &status);
if (rc != SUCCESS) return(rc);

printf("\nrecord status = ");
if (status == ACTIVE) printf("ACTIVE");
else		      printf("INACTIVE");

gendump(recbuf, reclen);

return(SUCCESS);
} /* end of tBgetr() */

/******** tBgetf **********/
int tBgetf()
{
RECLEN reclen;
BYTE   month, day, year;
FLDNUM nofields;
dBFIELD *fields, *fldptr;
int i, rc;
extern int dBgetf();
extern char *malloc();
extern int  free();

printf("\nSYNOPSIS:     int dBgetf(dbffd, reclen, month, day, year,");
printf("\n                         nofields, fields)");

if (!(fields = (dBFIELD *) malloc( (U2BYTES) sizeof(dBFIELD) * 128)))
{
	printf("\nSTUDYDBC: not enough memory space available");
	return(-1);
}

rc = dBgetf(dbfid, &reclen, &month, &day, &year, &nofields, fields);

if (rc != SUCCESS)
{
	free( (char *) fields);
	return(rc);
}

printf("\n\nreclen   = %d", reclen);
printf("\nmonth    = %d", month);
printf("\nday      = %d", day);
printf("\nyear     = %d", year);
printf("\nnofields = %d", nofields);
fldptr = fields;
for (i=1; i<=nofields; i++, fldptr++)
{
	printf("\n\n *** FIELD NUMBER : %d ***", i);
	printf("\nfield name : %s", fldptr->fieldnm);
	printf("\nfield type : %c", fldptr->type);
	printf("\nfield width : %d", fldptr->width);
	printf("\n# of decimal places : %d", fldptr->dec);
}
free( (char*) fields);

return(SUCCESS);
} /* end of tBgetf() */

/******* tBputr ********/
int tBputr()
{
int rc;
RECNUM recno; 
extern int dBputr();
extern long inputnum();
extern int scanrec();


printf("\nSYNOPSIS:     int dBputr(dbffd, recno, recbuf)");
printf("\n\nEnter recno > ");
recno = (RECNUM) inputnum();
if ((rc = scanrec(recbuf)) != SUCCESS) return(rc);

rc = dBputr(dbfid, recno, recbuf);
return(rc);

} /* end of tBputr() */


/******* tBupdr *********/
int tBupdr()
{
int rc;
RECNUM recno; 
extern long inputnum();
extern int scanrec();
extern int dBupdr();


printf("\nSYNOPSIS:     int dBupdr(dbffd, recno, recbuf)");
printf("\nEnter recno > ");
recno = (RECNUM) inputnum();
if ((rc = scanrec(recbuf)) != SUCCESS) return(rc);

rc = dBupdr(dbfid, recno, recbuf);
return(rc);

} /* end of tBupdr() */


/******* tBdelete *******/
int tBdelete()
{
int rc;
RECNUM recno;
extern int dBdelete();
extern long inputnum();

printf("\nSYNOPSIS:     int dBdelete(dbffd, recno)");

printf("\n\nEnter recno > ");
recno = (RECNUM) inputnum();

rc = dBdelete(dbfid, recno);
return(rc);

} /* end of tBdelete() */


/******* tBrecall *******/
int tBrecall()
{
int rc;
RECNUM recno;
extern int dBrecall();
extern long inputnum();


printf("\nSYNOPSIS:     int dBrecall(dbffd, recno)");

printf("\n\nEnter recno > ");
recno = (RECNUM) inputnum();

rc = dBrecall(dbfid, recno);
return(rc);

} /* end of tBrecall() */


/******** tBsize ******/
int tBsize()
{
int rc;
RECNUM recno;
extern int dBsize();

printf("\nSYNOPSIS:     int dBsize(dbffd, size)");

rc = dBsize(dbfid, &recno);

if (rc != SUCCESS) return(rc);

printf("\n\nNumber of records allocated = %u", recno);

return(rc);

} /* end of tBsize() */


/******** tBrmvr ********/
int tBrmvr()
{
RECNUM recno;
int rc;
extern int dBrmvr();
extern long inputnum();

printf("\nSYNOPSIS:     int dBrmvr(dbffd, recno)");
printf("\n\nEnter recno > ");
recno = (RECNUM) inputnum();
rc = dBrmvr(dbfid, recno);

return(rc);

} /* end of tBrmvr() */


/******* tBflush *******/
int tBflush()
{
int rc;
extern int dBflush();

printf("\nSYNOPSIS:     int dBflush(dbffd)\n");
rc = dBflush(dbfid);

return(rc);

} /* end of tBflush() */


int scanrec(recbuf)
	char *recbuf;
{
int inputlen;
int i, j, rc;
RECLEN reclen;
char month, day, year;
FLDNUM nofields;
dBFIELD *fields, *fldptr;
char buffer[256], *bufptr;
char field[64];
char *cptr, *cp;
extern int dBgetf(), dBatofld();
extern int strlen(), free();
extern char *malloc();

if (!(fields = (dBFIELD *) malloc( (U2BYTES) sizeof(dBFIELD) * 128)))
{
	printf("\nSTUDYDBC: not enough memory space available");
	return(-1);
}
printf("\nCalling dBgetf() to get the data file information.............");
rc = dBgetf(dbfid, &reclen, &month, &day, &year, &nofields, fields);
if (rc != SUCCESS)
{
	printf("\ndBgetf() failed : ");
	free( (char*) fields);
	return(rc);
}

for (i=1, cptr=recbuf; i<=LENGTH; i++) *cptr++ = ' ';
printf("\nEnter record >>> ");
cp = cptr = recbuf;
fldptr = fields;
for (i=1; i <= nofields; i++, fldptr++)
{
    cptr = cp;
    while (1)
    { /* dummy loop */
	printf("\nFIELD %d : %s   TYPE = %c\n>", i, fldptr->fieldnm,
                                                    fldptr->type);
	readin(buffer);
	if (fldptr->type == 'N')
	{
	    printf("     Calling dBatofld() for ASCII to numeric field");
	    printf(" conversion............");
	    if (dBatofld(buffer, (int) fldptr->width, (int) fldptr->dec, field)
		!= SUCCESS)
	    {
		printf("\nbad input for this field: try again");
		continue;
	    }
	    printf("\nConversion Complete!");
	    inputlen = (int) fldptr->width;
	    bufptr = field;
	}
	else if (fldptr->type == 'M')
	{
	    inputlen = strlen(buffer);
	    for (j=1; j<=(fldptr->width - inputlen); j++) *cptr++ = ' ';
	    bufptr = buffer;
	}
	else
	{
	    inputlen = strlen(buffer);
	    bufptr = buffer;
	}
	break; /* get out of while(1) loop */
    } /* end of while (1) loop */

    for (j=1; j<=fldptr->width && j<=inputlen; j++) *cptr++ = *bufptr++;
    cp += fldptr->width;
}
free( (char*) fields);

return(SUCCESS);
} /* end of scanrec() */


/******* tBmcreate *********/
int tBmcreat()
{
int rc;

printf("\nSYNOPSIS:     int dBmcreat(dbtname)");
printf("\n                     char    *dbtname;");

printf("\n\ndbtname == %s", dbtname);
if (!dbtname[0])
{
	printf("\nYou have not specify a memo file name.");
	printf("\nSpecify the file name by entering selection 92");
	printf("\nbefore you create the file");
	return(-1);
}

rc = dBmcreat(dbtname);

return(rc);

} /* end of tBmcreat() */


/********* tBmopen ********/
int tBmopen()
{
int rc;
extern int dBmopen();

printf("\nSYNOPSIS:     int dBmopen(dbtname, dbtfd)");

if (dbtid != (char *) 0)
{
	printf("\n\007Menu file already open!");
	printf("\nIf you want to open another date file, ");
	printf("close the current one first.");
	return(-1);
}
if (!dbtname[0])
{
	printf("\nYou have not specify a memo file name.");
	printf("\nSpecify the file name by entering selection 92");
	printf("\nbefore you open the file");
	return(-1);
}

printf("\nOpening the menu file: %s .............", dbtname);

rc = dBmopen(dbtname, &dbtid);

if (rc == SUCCESS) printf("File successfully opened!");

return(rc);

} /* end of tBmopen() */

/********* tBmclose ********/
int tBmclose()
{
int rc;
extern int dBmclose();

printf("\nSYNOPSIS:     int dBmclose(dbtfd)");
printf("\n\nClosing the memo file: %s .............", dbtname);

rc = dBmclose(dbtid);

dbtid = (char *) 0;

return(rc);

} /* end of tBmclose() */


/****** tBgetm ********/
int tBgetm()
{
int rc;
extern int dBgetm();
char *memobuf, *mptr;
char field[10];
long fldnum;
int  i;
extern char *malloc();
extern U2BYTES _dbcmsiz;
extern int  free();
extern long inputnum();

printf("\nSYNOPSIS:     int dBgetm(dbtfd, field, memo)");
printf("\n\nA memo field in a data file is 10 bytes long and it contains a");
printf("\nmemo location number of the memo file.  dBgetm requires the memo");
printf("\nfield as an input parameter.  Since, you are just learning the");
printf("\ndBgetm itself, let's simulate a memo field by hand.");
printf("\n\nIf you don't what number you can specify, try 1 for learning");
printf("\npurpose.  It always works assuming that the memo file has at least");
printf("\n1 memo in it.");
printf("\nRefer to the dBC manual for more information.");
printf("\n\nEnter a memo location number of your choice > ");

if (!(memobuf = malloc( (U2BYTES) _dbcmsiz)))
{
	printf("\nSTUDYDBC: not enough memory space available");
	return(-1);
}

fldnum = inputnum();
if (fldnum < 1L)
{
        printf("\n\nYou entered a 0 or negative number.");
	printf("   The number is reset to 1 for further processing");
        fldnum = 1L;
}

/* field simulation */
mptr = field;
for (i=1; i<=10; i++) *mptr++ = ' ';
mptr--;
for (i=1; i<=10; i++)
{
	*mptr--	= ((char) (fldnum % 10L)) + '0';
        fldnum /= 10L;
	if (fldnum == 0L) break;
}
printf("\nfields contents: [");
mptr = field;
for (i=1; i<=10; i++) printf("%c", *mptr++);
printf("]");
		
rc = dBgetm(dbtid, field, memobuf);
if (rc != SUCCESS) return(rc);
printf("\nMEMO READ:\n[");
mptr = memobuf;
while(*mptr) printf("%c", *mptr++);
printf("]");

free(memobuf);
return(SUCCESS);
} /* end of tBgetm() */


/******* tBputm ********/
int tBputm()
{
int i, rc;
char *memobuf, *mptr;
char field[10];
extern char *malloc();
extern U2BYTES _dbcmsiz;
extern int free(), dBputm();

printf("\nSYNOPSIS:     int dBputm(dbtfd, memo, field)");
if (!(memobuf = malloc( (U2BYTES) _dbcmsiz + 100))) /* 100 => for safety */
{
	printf("\nSTUDYDBC: not enough memory space available");
	return(-1);
}

printf("\n\nEnter memo > ");
readin(memobuf);

rc = dBputm(dbtid, memobuf, field);

free(memobuf);

if (rc != SUCCESS) return(rc);

printf("\nYour memo entered the memo file.  \nfield returned: [");
mptr = field;
for (i=1; i<=10; i++) printf("%c", *mptr++);
printf("] <== Use this as the contents of a memo field");
printf("\nin the associated data file.");
printf("\nRefer to the dBC manual for more information.");

return(SUCCESS);

} /* end of tBputm() */
