/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*   DBRMVR.C                                           */
/********************************************************/

int dBrmvr(dbffd, recno)			/* error assignment: 600 */
	char	 *dbffd;
	RECNUM   recno;
{
DBFFILE *dbfptr;
RECNUM  size;
int    rc;
extern int _dbfoff(), dBsize(), _getbuf(), dBflush();
extern int _dbcerr;


dbfptr = (DBFFILE *) dbffd;

if (_dbfoff(dbfptr)) {
	return(1);
}

if ((rc = dBsize(dbffd, &size)) != 0) return(rc);
if ((recno > size) || !recno) {
	_dbcerr = 601;
	return(3); /* record number too big or zero */
}

if (!dbfptr->_bfptr) {
	/* attach I/O buffer */
	if (_getbuf( dbfptr->_bufsize, dbfptr ) == 1) {
		return(1);
	}
	dbfptr->_first = recno;
	dbfptr->_bfhas = 0;
}
else {
	/* I/O buffer already attached */
	if (dbfptr->_dbfmode & 0x01) {
		dbfptr->_first = recno;
		dbfptr->_bfhas = 0;
	} else if (dbfptr->_dbfmode & 0x0e) {
		if (dBflush(dbffd) != 0) {
			_rlsbuf(dbfptr);
			return(4);
		}
		dbfptr->_first = recno;
	} else if (dbfptr->_dbfmode & 0x10) {
		dbfptr->_first = recno;
	}
}

dbfptr->_bfhas = 1;

dbfptr->_dbfmode = 0x10;

if (dBflush(dbffd) != 0) {
	_rlsbuf(dbfptr);
	return(4);
}

dbfptr->_dbfmode = 0x01;

return(0);

} /* end of dBrmvr() */
