/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*  DBREVKEY.C                                          */
/********************************************************/

extern void _copykey(), _copyup();

/*
 *   dBrmvkey(index file descriptor, key, record number)
 */
int dBrmvkey(ndxfd, key, recno)
	char   *ndxfd;
	char   *key;
	RECNUM recno;
{
NDXFILE  *ndxptr;
BYTE	 updflag;
BYTE	 *updbuf;
int	 rc;

ndxptr = (NDXFILE *) ndxfd;

if (_ndxoff(ndxptr)) return(1);

ndxptr->_svptr = ndxptr->_svector;
ndxptr->_svptr->_nxusage &= 0x3f;

updbuf = (BYTE *) 0;
switch(rc = _rmvkey(ndxptr, ndxptr->_rootblk, recno, key, &updflag, &updbuf))
{
case 0:
	memcpy(ndxptr->_actkey,key,ndxptr->_keylen);
	ndxptr->_actpointer = recno;
	break;
case 1:
case 4:
	_errrls(ndxptr);
}

if (updbuf) free(updbuf);

ndxptr->_svector[0]._nxusage |= 0x80;

return(rc);
} /* end of dBrmvkey() */


/****************************************************************************
* NAME         _rmvkey
* 
* CALLED BY    dBrmvkey
*
* ABSTRACT     remove a key
*
* DESCRIPTION  This function removes a key.  As a result of the removal,
*	       its parent index may be updated.
*	       This parent update is recursively repeated until
*	       root block.  This removal method simply adjusts the contents
*	       of an index(.NDX) file and does not removed the space itself.
*	       The space remains unchanged after the key removal.
*****************************************************************************/
static int complen, incrment, keytype;

static int _rmvkey(ndxptr, thisblk, recno, key, pardel, parupd)
	NDXFILE  *ndxptr;
	BLKNO    thisblk;
	RECNUM   recno;
	char     *key;
	BYTE	 *pardel;  /* if non-zero, parent must be removed */
	BYTE	 **parupd; /* if non-NULL, parent must be updated */
{
BYTE *blkptr, *bufptr;
BYTE found;
int  foundix, lasthiix;
BLKNO nextblk;  /*     0: this block contains keys and associated record #
		   non-0: this block contains indices to another block */
BYTE *tempcp;
BYTE keynum;
BYTE updflag; /* used for 'pardel' parameter to _rmvkey */
BYTE *updbuf; /* used for 'parupd' parameter to _rmvkey */
int rc, comprc;
extern int _dbcerr;
extern int _rdblk(), _picklix();
extern int _comparek(), _nkeycomp();
extern NBYTES _nbytes();

/* read entire block */
if ((rc = _rdblk(ndxptr, thisblk)) != 0) return(rc);
blkptr = ndxptr->_svptr->_nxbfptr;
bufptr = blkptr;

keynum = *bufptr;
bufptr += 4;

nextblk = (BLKNO) _nbytes(bufptr);
if (keynum == 0)
{
	_dbcerr = 1701;
	return(7); /* initial .NDX file with no keys in it */
}

keytype  = ndxptr->_keytype;
complen  = ndxptr->_keylen;
incrment = ndxptr->_kptrlen;
found = 0; /* not found the right key yet */
for (foundix=1; foundix<=keynum; foundix++, bufptr += incrment)
{
    if (keytype == 0) 
	comprc = _comparek(bufptr + 8, key, complen);
    else
	comprc = _nkeycomp(bufptr + 8, key, complen);

    if (comprc == 0)
    { /* left less than right */
	/* not found yet: keep searching */
	if (foundix < keynum) continue;
	if (!nextblk) break; /* not found */
	/* dBASE might not have put an accurate key in the last
	   key position in the non-lowest level block */
    }
    if (comprc == 2 && !nextblk) /* left greater than right & lowest blk */
	break; /* not found */

    /* at this point, the "bufptr" is pointing to a key that this key is
        interested in */

    nextblk = (BLKNO) _nbytes(bufptr);

    updflag = 0;
    updbuf  = (BYTE *) 0;
    if (nextblk)
    {
	    /* go down to next level */
	    ndxptr->_svptr++;
	    rc = _rmvkey(ndxptr, nextblk, recno, key, &updflag, &updbuf);
	    ndxptr->_svptr--;
	    if (rc != 0)
	    {
		if (updbuf) free(updbuf);
		if (comprc == 1) continue;
		return(rc);
	    }

	    if (!updflag && !updbuf) return(0);

	    if (updbuf)
	    {
		/* change this index */
		/* at this point, the "bufptr" is pointing to an index
	   	   that this index is interested in */
		tempcp = updbuf;
		nextblk = (BLKNO) _nbytes(tempcp);
		tempcp += 4;
		recno = (RECNUM) _nbytes(tempcp);
		tempcp += 4;
		_copykey(bufptr, nextblk, recno, tempcp, 
                         (U2BYTES) ndxptr->_kptrlen - 8);
		free(updbuf);

		ndxptr->_svptr->_nxusage |= 0x1e;
		ndxptr->_svptr->_nxidno	= (foundix <= 1) ? 1 : foundix - 1;

		if (foundix < keynum) return(0);
		if (ndxptr->_rootblk == thisblk) return(0);

		lasthiix = 0;
		rc = _picklix(ndxptr, blkptr, thisblk, recno, foundix,
			      keynum + 1, parupd, lasthiix);
		if (rc == 1) return(1);
		return(0); /* any rc is ok now */

	    }
	    /* updflag must be non-zero, indicating to remove this index:
	       this can be done by the following steps */
	    found = 1;
	    break;
        } /* end of if (next)-clause */

	/* nextblk == (BLKNO) 0 */
	if ((comprc == 1) && (_nbytes(bufptr + 4) == recno))
	{
	    found = 1;
	    break; /* found spot */
	}
} /* end of for-loop */

if (!found)
{
	_dbcerr = 1702;
	return(7);
}


while (1) { /******* BEGIN dummy loop ********/
/* if this is the only key/(index) to be removed in this block,
   its parent should be removed */
if (keynum <= 1)
{
	if (ndxptr->_rootblk == thisblk)
	{
		ndxptr->_rootblk = (BLKNO) 1;
		ndxptr->_eofblk	= (BLKNO) 2;
		ndxptr->_svptr->_nxblkno = (BLKNO) 1;
		/* reserve as many existing blocks as possible
		   for future key insert */
		for (foundix=1; foundix <= 16; foundix++)
			*blkptr++ = 0;
		break; /* get out of dummy loop */
	}
	ndxptr->_svptr->_nxusage = 0x01; /* don't need to write */
	*pardel = 1;
	return(0);
}
 
/* at this point, this block should be updated by shifting up a key */
/* do the main business */
if ( foundix < keynum )
{
	/* remove this key at the middle of this block:
	   shift up to remove this key */
	_copyup(bufptr + ndxptr->_kptrlen, bufptr,
		(U2BYTES) ndxptr->_kptrlen * (keynum - foundix) + 4);
	nextblk = (BLKNO) _nbytes(bufptr);
}
ndxptr->_svptr->_nxidno = (foundix <= 1) ? 1 : foundix - 1;

lasthiix = (nextblk && (keynum <= 2)) ? 1 : 0;

if ( (foundix == keynum) || lasthiix )
{
	if ( (ndxptr->_rootblk == thisblk) && lasthiix)
	{
		if (foundix == keynum)
		{ /* or (foundix == 2) */
			bufptr -= ndxptr->_kptrlen;
			nextblk = (BLKNO) _nbytes(bufptr);
		}

		/* adam block shifts 1 level down */
		ndxptr->_rootblk = nextblk;
		ndxptr->_svptr->_nxusage = 0x01;
				/* don't need to write the current adam */
		if ((rc = _rdblk(ndxptr, nextblk)) != 0) return(rc);
		blkptr = ndxptr->_svptr->_nxbfptr;
		break; /* get out of dummy loop */
	}


	rc = _picklix(ndxptr, blkptr, thisblk, recno,
		      foundix, keynum, parupd, lasthiix);
	if (rc == 1) return(1);

	if (lasthiix) return(0);
}

*blkptr = --keynum;
break; /* get out of dummy loop */

} /*********** END dummy loop ***********/

ndxptr->_svptr->_nxusage |= 0x1e;

return(0);
} /* end of _rmvkey() */


/****************************************************************************
* NAME         _picklix
* 
* CALLED BY    _rmvkey
*
* ABSTRACT     pick last index
*
* DESCRIPTION  This function picks the last index/key in a block
*	       and returns to _rmvkey().
*****************************************************************************/
static int _picklix(ndxptr, blkptr, thisblk, recno, foundix, keynum, parupd,
	            lasthiix)
	NDXFILE  *ndxptr;
	BYTE     *blkptr;
	BLKNO    thisblk;
	RECNUM   recno;
	int      foundix;
	BYTE     keynum;
	BYTE     **parupd;
	int      lasthiix; /* 1: index of interest is the last one and it
				 is located in a high level block */
			   /* 0: index can be any kind except the above
                                 condition */
{
BYTE *bufptr;
BLKNO nextblk;
extern char *malloc();
extern NBYTES _nbytes();
extern int _dbcerr;

/* parent index should be updated when returning to calling function */
if (!(*parupd = malloc((U2BYTES) ndxptr->_kptrlen)))
{
	_dbcerr = 1710;
	return(1);
}
bufptr = blkptr + 4 + (U2BYTES) (keynum - 2) * ndxptr->_kptrlen;

if (lasthiix)
{
	nextblk = (BLKNO) _nbytes(bufptr);
	bufptr += 4;
}
else
{
	nextblk = thisblk;
	bufptr += 4;
}

recno = (RECNUM) _nbytes(bufptr);
bufptr += 4;

_copykey(*parupd, nextblk, recno, bufptr,
	 (U2BYTES) ndxptr->_kptrlen - 8);

return(0);
} /* end of _picklix() */
