/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*   DBPUTR.C                                           */
/********************************************************/

int dBputr(dbffd, recno, record)  /* error nb. assignment is 500 */
	char   *dbffd;
	RECNUM recno;
	char   *record;
{
DBFFILE *dbfptr;
RECNUM size;
char *cptr;
int  rc;
extern int _dbcerr;

dbfptr = (DBFFILE *) dbffd;

if (_dbfoff(dbfptr)) {
	return(1);
}
if ((rc = dBsize(dbffd, &size)) != 0) return(rc);
if ((recno > (size + 1)) || !recno) {
	_dbcerr = 501;
	return(3); /* record number too big or zero */
}
if (!dbfptr->_bfptr) {
	/* attach I/O buffer */
	if (_getbuf( dbfptr->_bufsize, dbfptr ) == 1) {
		return(1);
	}

	dbfptr->_first = recno;
	dbfptr->_bfhas = 0;
}
else {  /* I/O buffer already attached */
	if (dbfptr->_dbfmode & 0x01) {
		dbfptr->_first = recno;
		dbfptr->_bfhas = 0;
	} else if (dbfptr->_dbfmode & 0x06) {
		if (dbfptr->_first + dbfptr->_bfhas != recno) {
			/* this requested record is NOT next to the previous
		   	   record already in the buffer :
			      flush the buffer first */
			if (dBflush(dbffd) != 0) {
				_rlsbuf(dbfptr);
				return(4);
			}
			dbfptr->_first = recno;
			dbfptr->_bfhas = 0;
		
		} /* else {
		 	requested record is in the buffer
		   	contiguous to previous records
		} */

	} else if (dbfptr->_dbfmode & 0x18) {
		if (dBflush(dbffd) != 0) {
			_rlsbuf(dbfptr);
			return(4);
		}

		dbfptr->_first = recno;
		dbfptr->_bfhas = 0;
	}


}

cptr = dbfptr->_bfptr + dbfptr->_len * dbfptr->_bfhas;
_copyup(record, cptr + 1, (U2BYTES) dbfptr->_len - 1);
*cptr = ' ';

dbfptr->_dbfmode = ((dbfptr->_alcnum + 1) == dbfptr->_first) ?
		   0x02 : 0x04;

dbfptr->_bfhas += 1;

if (dbfptr->_bfhas >= dbfptr->_maxnum) {
	if (dBflush(dbffd) != 0) {
		_rlsbuf(dbfptr);
		return(4);
	}

}

return(0);

} /* end of dBputr() */
