/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*    DBPKEY.C                                          */
/********************************************************/

int dBpkey(ndxfd, key, recno) /*** error assignment: 1800 ***/
	char	 *ndxfd;
	char	 *key;
	RECNUM   *recno;
{
NDXFILE *ndxptr;
int rc;
extern NBYTES _nbytes();


ndxptr = (NDXFILE *) ndxfd;

if (_ndxoff(ndxptr)) return(1);

ndxptr->_svptr = ndxptr->_endofsv;
switch (rc = _gprevk(ndxptr, key, recno))
{
case 0:
	memcpy(ndxptr->_actkey,key,ndxptr->_keylen);	/* MI-SOFT*/
	ndxptr->_actpointer = *recno;
	break;
case 1:
case 4:
	_errrls(ndxptr);
}
return(rc);
} /* end of dBpkey() */


/****************************************************************************
* NAME         _gprevk
* 
* CALLED BY    dBpkey
*
* ABSTRACT     get previous key
*
* DESCRIPTION  This function loacates the sequential-read pointer to the
*	       previous key in the index file.
*
* CALLING SEQUENCE
*		_gprevk(ndxptr);
*
*****************************************************************************/
static int _gprevk(ndxptr, key, recno)
 	NDXFILE  *ndxptr;
	char     *key;
	RECNUM   *recno;
{
BYTE *blkptr, *bufptr;
BYTE keynum;
BLKNO nextblk;  /* non-0: this block contains keys and associated record #
		       0: this block contains indices to another block      */
int i;
extern int _dbcerr;
extern int _lastkey();
extern NBYTES _nbytes();


again:
if (ndxptr->_svector[0]._nxusage & 0x40) {
	/* place the sequential ptr at the very last key in the index file */
	ndxptr->_svptr = ndxptr->_svector;
	return(_lastkey(ndxptr, ndxptr->_rootblk, key, recno));
}

if (!(ndxptr->_svector[0]._nxusage & 0x80))
	{
	if (_findexact((char*)ndxptr,key,recno) == 9)	   /* at the end of file */
		goto again;
	ndxptr->_svptr = ndxptr->_endofsv;

	while (ndxptr->_svector <= ndxptr->_svptr) {
		blkptr = ndxptr->_svptr->_nxbfptr; /* equivalent to _rdblk() */
		bufptr = blkptr;
		keynum = *bufptr++;
		if (ndxptr->_svptr->_nxidno > 0) ndxptr->_svptr->_nxidno -= 1;
		if (ndxptr->_svptr->_nxidno >= 1) {
		/* _nxidno & keynum both start at 1:
		   don't need to go backward or left since there are one or
		   more indices still remaining in this block */
		bufptr = blkptr + 4
		+ (U2BYTES) (ndxptr->_svptr->_nxidno - 1) * ndxptr->_kptrlen;

		nextblk = (BLKNO) _nbytes(bufptr);
		if (nextblk) {
			ndxptr->_svptr++;
			return(_lastkey(ndxptr, nextblk, key, recno));
		}
		bufptr += 4;
		*recno = (RECNUM) _nbytes(bufptr);
		bufptr += 4;
		for (i=1; i<=ndxptr->_keylen; i++) *key++ = *bufptr++;
		return(0);
	}
	ndxptr->_svptr--; /* place ptr to vector one previous place */

	} /* end of while loop */
	}

/*** reached the top of the index file: no more previous keys ***/
ndxptr->_svptr = ndxptr->_svector;
ndxptr->_svptr->_nxusage =
	(ndxptr->_svptr->_nxusage & 0x3f) | 0x80;
_dbcerr = 1810;
return(11);

} /* end of _gprevk() */


/****************************************************************************
* NAME         _lastkey
* 
* CALLED BY    _gprevk
*
* ABSTRACT     last key
*
* DESCRIPTION  This function locates the sequential-read pointer at the
*	       last index of a particular block.
*
* CALLING SEQUENCE
*	(1)	To set ptr to the last key in the entire index file:
*		ndxptr->_svptr = ndxptr->_svector;
*		_lastkey(ndxptr, root block #, ptr to key, ptr to recno);
*
*	(2)	To set ptr to the first key from the block _svptr is
*		pointing to:
*		_lastkey(ndxptr, current block # of interest, &key, &recno);
*
*****************************************************************************/
static int _lastkey(ndxptr, thisblk, key, recno)
	NDXFILE *ndxptr;
	BLKNO   thisblk;
	char    *key;
	RECNUM  *recno;
{
BYTE *bufptr;
BYTE keynum;
BLKNO nextblk;  /* non-0: this block contains keys and associated record #
		       0: this block contains indices to another block      */
int rc, i;
extern int _dbcerr;
extern int _rdblk();
extern NBYTES _nbytes();

/* read this block */
if ((rc = _rdblk(ndxptr, thisblk)) != 0) 	return(rc);

bufptr = ndxptr->_svptr->_nxbfptr;

keynum = *bufptr;

if ( keynum == 0 ) {
	/* no key entered in the index file */
	_dbcerr = 1820; /* corrupt index file ? */
	return(7);
}

ndxptr->_svptr->_nxidno = keynum; /* the last index in the block */

bufptr += ( 4 + (U2BYTES) ndxptr->_kptrlen * (keynum - 1) );

nextblk = (BLKNO) _nbytes(bufptr);

if (nextblk) {
	/* go down to next level */
	ndxptr->_svptr++;
	if ((rc = _lastkey(ndxptr, nextblk, key, recno)) != 0)
	{
		if (rc == 7) rc = 1;
				/* currupt index file or read failure */
	}
	return(rc);
}

/* reached the lowest level index block */
*recno = (RECNUM) _nbytes(bufptr + 4);
bufptr += 8;
for (i=1; i<=ndxptr->_keylen; i++) *key++ = *bufptr++;

ndxptr->_svector[0]._nxusage &= 0x3f;
if (ndxptr->_endofsv < ndxptr->_svptr) ndxptr->_endofsv = ndxptr->_svptr;

return(0);

} /* end of _lastkey() */


/*******************************************
*                  dBfwd()                 *
********************************************/

int dBfwd(ndxfd)
	char *ndxfd;
{
NDXFILE *ndxptr;
extern int _ndxoff();

ndxptr = (NDXFILE *) ndxfd;

if (_ndxoff(ndxptr)) {
	return(1);
}

/* forward the sequential ptr to the END-OF-FILE position in the index file */
ndxptr->_svptr = ndxptr->_svector;
ndxptr->_svptr->_nxusage = (ndxptr->_svptr->_nxusage & 0x3f) | 0x40;
return(0);
} /* end of dBfwd() */
