/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include <fcntl.h>
#include <types.h>
#include <stat.h>
#include <share.h>
#include <io.h>

#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*    DBOPEN.C                                          */
/********************************************************/

#define	NULL	(void *)0

int dBopen(dbfname, dbffd) /*** error assignment: 200 ***/
       char *dbfname; /* pointer to a character string
                         that represents the .DBF file
		         to be opened */
       char **dbffd;  /* file descriptor */
{
extern char *malloc(),*calloc();
/* extern int rlsmem(); */
extern int _getbuf(), _rlsbuf(), _getbuf2();
extern NBYTES _nbytes();
RECLEN reclen; /* record length */
int readlen, i;
int fn; /* file number */
DBFFILE *dbfptr;
dBFIELD *fldptr;
BYTE *bp, *bufptr;
BYTE c; /* general purpose 8-bit variable */
extern int _dbcerr;
RECLEN tstrlen;
U2BYTES bufsize;

/*
Inkabb allokaljuk a fileleirot !!!!

found = 0;
for (dbfptr=_dbffiles; dbfptr < _dbffiles + 10; dbfptr++)
{
	if (dbfptr->_dbfmode == 0x00)
	{
		dbfptr->_dbfmode = 0x01;  prevent this slot from collision
		found = 1;
		break; 			found free slot
	}
}
*/

if ((dbfptr = (DBFFILE *)calloc(1,sizeof(DBFFILE))) == NULL)
{
	_dbcerr = 201;
	return(1); /* no free slot */
}
dbfptr->_dbfmode = 0x01;  	/* prevent this slot from collision */

if ((fn=sopen(dbfname,O_RDWR|O_BINARY,SH_DENYNO)) < 0)
{
	_dbcerr = 202;
	dbfptr->_dbfmode = 0x00; 
	return(1); /* open failure */
}
/* get memory buffer */
if (_getbuf(4200, dbfptr) != 0)
{
	dbfptr->_dbfmode = 0x00; 
	return(1);
}

/* read the file into the buffer */
readlen = read(fn, dbfptr->_bfptr, 4200);
if (readlen < 0x43)
{ /* less than minimum length */
 	_rlsbuf(dbfptr);
	close(fn);
	_dbcerr = 203;
	dbfptr->_dbfmode = 0x00; 
	return(1); /* read failure */
}

bp = dbfptr->_bfptr;
/* fill the .DBF file structure(DBFFILE) */
if ((BYTE) *bp != (BYTE) 0x03 && (BYTE) *bp != (BYTE) 0x83)
{
	_rlsbuf(dbfptr);
	close(fn);
	_dbcerr = 204;
	dbfptr->_dbfmode = 0x00; 
	return(2);
}

dbfptr->_dbffn = fn;
dbfptr->_dbfmode = 0x01; /* initially open for reading */
dbfptr->_alcnum = (RECNUM) _nbytes(bp + 4);
dbfptr->_dbfupd = 0; /* initially no record updated */
dbfptr->_month = *(bp + 2);
dbfptr->_day   = *(bp + 3);
dbfptr->_year  = *(bp + 1);

bufptr = bp + 0x20;
for (c=0; c<=(128 - 1); c++)
{
	if (*bufptr == 0x0d) break;
	bufptr += 0x20;
}
dbfptr->_nflds = c;
if (_getbuf2(dbfptr) == 1)
{
	_rlsbuf(dbfptr);
	close(fn);
	dbfptr->_dbfmode = 0x00; 
	return(1); /* could not get buffer space */
}

bufptr = bp + 0x20;
fldptr = dbfptr->_flds; 
reclen = (RECLEN) 0;

for (i=1; i<=c; i++)
{
	strcpy(fldptr->fieldnm, bufptr);
	fldptr->type = *(bufptr + 0xb);
	fldptr->width = *(bufptr + 0x10);
	fldptr->dec = *(bufptr + 0x11);
	reclen += fldptr->width;

	fldptr++;
	bufptr += 0x20;
}

tstrlen = (*(bp + 0x0a)) & (BYTE) 0xff;
tstrlen |= ((((RECLEN) *(bp + 0x0b)) << 8) & 0xff00);
if ((tstrlen - 1) != reclen)
{
	_rlsbuf(dbfptr);
	_rlsbuf2(dbfptr);
	close(fn);
	_dbcerr = 205;
	dbfptr->_dbfmode = 0x00; 
	return(2);
}
tstrlen = *(bp + 8) & (BYTE) 0xff;
((dbfptr)->_begdata) = ((*(bp + 9) << 8) & 0xff00) | tstrlen;

/* set up for subsequent read-write */
dbfptr->_len = 1 + reclen; /* 1 char for record ACTIVE/INACTIVE */
if      (reclen <= 64) bufsize = 512;
else if (reclen <= 128) bufsize = 1024;
else if (reclen <= 256) bufsize = 2048;
else if (reclen <= 512)  bufsize = 4096;
else if (reclen <= 1024) bufsize = 8192;
else                        bufsize = 16384;
_rlsbuf(dbfptr);
if (_getbuf(bufsize, dbfptr) != 0)
{
	dbfptr->_dbfmode = 0x00; 
	_rlsbuf2(dbfptr);
	return(1);
}

dbfptr->_maxnum = (bufsize - 1) / dbfptr->_len;
				/* 1 char for EOFDATA */
*dbffd = (char *) dbfptr;
return(0);
} /* end of dBopen() */


/*************************************************
*                  dBclose                       *
**************************************************/

int dBclose(dbffd) /*** error assignment: 300 ***/
	char *dbffd;
{
DBFFILE *dbfptr;
BYTE updbuf[7];
BYTE *fptr;
BYTE mon, day, year;
int rc; /* return code: if error is detected, 1st r.c. is reserved */
extern int _dbcerr;


dbfptr = (DBFFILE *) dbffd; /* cast to DBFFILE first */

if (_dbfoff(dbfptr)) return(1); /* already closed: nothing to do */

rc = 0; /* Let's hope that everything will go fine. */

if ((dbfptr->_dbfmode & 0x1e) && dbfptr->_bfhas)
{
	if (dBflush(dbffd) != 0) rc = 4;
}

if (dbfptr->_dbfupd)
{
	/* update # of records and date in disk file */
	if (lseek(dbfptr->_dbffn, (long) 1, 0) == (long) -1)
	{
		if (rc == 0)
		{
			_dbcerr = 301;
			rc = 1;
			goto byebye; /* should not call write() */
		}
	}

	/* fill 'month', 'day' and 'year' bytes */
	_curdate(&mon, &day, &year);

	fptr = updbuf;
	*fptr++ = year;
	*fptr++ = mon;
	*fptr++ = day;
	_bytesn(dbfptr->_alcnum, fptr);

	if (write(dbfptr->_dbffn, updbuf, 7) != 7)
	{
		if (rc == 0)
		{
			_dbcerr = 302;
			rc = 4;
		}
	}
} /* end of if (dbfptr->_dbfupd) { ...... */

byebye: /* benediction begins */

_rlsbuf(dbfptr);
_rlsbuf2(dbfptr);

if (close(dbfptr->_dbffn))
{
	if (rc == 0)
	{
		_dbcerr = 303;
		rc = 1;
	}
}

dbfptr->_dbfmode = 0x00; 
free(dbfptr);			/* ugy allokaltuk !!!		*/

return(rc);

} /* end of dBclose() */


int _dbfoff(dbfptr)   /*** error assignment: 390 - 399 ***/
	DBFFILE *dbfptr;
{
extern int _dbcerr;

if (dbfptr == NULL || dbfptr->_dbfmode == 0x00)
{
	_dbcerr = 390;
	return(1); /* DBF file not open */
}
return(0); /* DBF file open */
} /* end of _dbfoff() */
