/*--->  dBmisc1.c -- a few utilities to handle concurrent access <---*/
/*--->                      MI-SOFTWARE                          <---*/

/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

#define	YES		1
#define NO		0

int _findexact(ndxfd, key, recno)
/*
 *	Used internally !!!
 *
 *	This function was written by MI-SOFTWARE
 *	This function finds an exact key
 *	and recordpointer combination
 *	Returns 0 if found
 *	        8 if not found
 *	        9 if reached the end-of-file
 */
char	*ndxfd;			/* indexfile descriptor		*/
char	*key;			/* key to find			*/
RECNUM	*recno;			/* the corresponding datapointer*/
{
NDXFILE *ndxptr;
int	 rc;
extern char *memcpy();

ndxptr = (NDXFILE *) ndxfd;

*recno = ndxptr->_actpointer;			/* retrieve the current	*/
memcpy(key,ndxptr->_actkey,ndxptr->_keylen);	/* key and datapointer	*/

ndxptr->_svptr = ndxptr->_svector;
ndxptr->_svptr->_nxusage &= 0x3f;

rc = _lockey(ndxptr, ndxptr->_rootblk, key, recno);

ndxptr->_svptr = ndxptr->_endofsv;		/* because og _gnextk	*/

while (rc == 0)				/* while keys are equival*/
	{
	if (*recno > ndxptr->_actpointer)	/* found greater datapointer*/
		{
		rc = 8;
		break;
		}
	if (*recno == ndxptr->_actpointer)	/* found exact key	*/
		break;

	if ((rc = _gnextk(ndxptr,key,recno)) == 0)
		{
		if (ndxptr->_keytype == 0) 
			rc = _comparek(key, ndxptr->_actkey,ndxptr->_keylen);
		else
			rc = _nkeycomp(key, ndxptr->_actkey,ndxptr->_keylen);

		if (rc == 1)
			rc = 0;
		else if (rc == 2)
			rc = 8;
		}

	}	

return(rc);
} /* end of _findexact() */


static int _readihead(ndxptr)
/*
 *	Reads and updates the header information in the memory
 */
NDXFILE *ndxptr;

{
extern int _dbcerr;
BYTE bufptr[8];			/* rootblk + eofblk = 8		*/
int  ret0 = 0;

if (lseek(ndxptr->_ndxfn, (long) 0L, 0) == -1L)
	ret0++;

if (read(ndxptr->_ndxfn, bufptr, 8) != 8)
	ret0++;

if (ret0)
	{
	_dbcerr = 1404;
	return(1);		/* read failure			*/
	}
	
ndxptr->_orootbk = ndxptr->_rootblk = (BLKNO) _nbytes(bufptr);
ndxptr->_oeofbk = ndxptr->_eofblk = (BLKNO) _nbytes(bufptr+4);

return(0);
} /* end of _readihead() */


int _writeihead(ndxptr)
/*
 *	Writes the header information into the indexfile,
 *	if that changed
 */
NDXFILE *ndxptr;

{
extern int _dbcerr;
BYTE	bufptr[8];			/* rootblk + eofblk = 8		*/
int	ret0 = 0;
int	origrc = 0;

if ((ndxptr->_rootblk != ndxptr->_orootbk)
		|| (ndxptr->_eofblk != ndxptr->_oeofbk))
	{
	/*
	 *	1 or more block were added: update eof and root
	 *	in block 0
	 */
	_bytesn(ndxptr->_rootblk, bufptr);
	_bytesn(ndxptr->_eofblk,  bufptr + 4);	

	if (lseek(ndxptr->_ndxfn, (long) 0L, 0) == -1L)
		ret0++;
	if (write(ndxptr->_ndxfn, bufptr, 8) != 8)
		ret0++;
	}

if (ret0)
	{
	_dbcerr	= 1503;
	origrc = 4;
	}

return(origrc);
} /* end of _writeihead() */


int dBclibuf(ndxptr)
/*
 *	Clears the buffers in the memory to force _rdblk() to
 *	read from the disk
 */
NDXFILE	*ndxptr;
{
extern int _ndxoff();
struct _seqacc *evp;
extern int network;

if (network != YES)		/* is it a concurrent system		*/
	return(0);		/* no --> do nothing			*/

if (_ndxoff(ndxptr)) return(1);

/* clear vector buffer */
evp = ((NDXFILE *)ndxptr)->_endofsv;
while (((NDXFILE *)ndxptr)->_svector <= evp)
	{
	evp->_nxblkno = 0;
	evp--;
	}

if (_readihead(ndxptr))
	return(1);

return(0);
} /* end of dBclibuf() */



int _readdhead(dbfptr)
/*
 *	Read the datafile header information
 */
DBFFILE *dbfptr;

{
extern int _dbcerr;
BYTE	updbuf[7];
BYTE	*fptr;

/*
 *	read the file into the buffer
 */

if (lseek(dbfptr->_dbffn, (long) 1, 0) == (long) -1)
	{
	_dbcerr = 301;
	return(1);
	}

if (read(dbfptr->_dbffn, updbuf, 7) != 7)
	{
	_dbcerr = 302;
	return(4);
	}

fptr = updbuf;
dbfptr->_year  = *fptr++;
dbfptr->_month = *fptr++;
dbfptr->_day   = *fptr++;
dbfptr->_alcnum = (RECNUM) _nbytes(fptr);

return(0);
} /* end of _readdhead() */



int _writedhead(dbfptr)
/*
 *	Writes the datafile header information
 */
DBFFILE *dbfptr;

{
extern int _dbcerr;
BYTE	updbuf[7];
BYTE	*fptr;
BYTE	mon, day, year;


if (dbfptr->_dbfupd)		/* changed the header information	*/
	{
	/*
	 *	update # of records and date in disk file
	 */
	if (lseek(dbfptr->_dbffn, (long) 1, 0) == (long) -1)
		{
		_dbcerr = 301;
		return(1);
		}

	/*
	 *	fill 'month', 'day' and 'year' bytes
	 */
 
	_curdate(&mon, &day, &year);

	fptr = updbuf;
	*fptr++ = year;
	*fptr++ = mon;
	*fptr++ = day;
	_bytesn(dbfptr->_alcnum, fptr);

	if (write(dbfptr->_dbffn, updbuf, 7) != 7)
		{
		_dbcerr = 302;
		return(4);
		}
	}

return(0);
} /* end of _writedhead() */



int dBclrbuf(dbfptr)
/*
 *	Frees the datarecord buffer, to force the DBC functions
 *	to reread datarecords from disk
 */
DBFFILE	*dbfptr;

{
extern int network;

if (network != YES)		/* is it a concurrent system		*/
	return(0);		/* no --> do nothing			*/

/*
_rlsbuf(dbfptr);
*/

_readdhead(dbfptr);
return(0);
} /* end of dBclrbuf() */
