/*--->  dBlock.c -- functions to handle file locks  <---*/
/*--->                  MI-SOFTWARE                 <---*/

/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dbc.lnt"
#endif
/*$+g*/


#define	YES	1
#define	NO	0
/*gl*/  int	network = NO;	/* must inicialize in the user functions*/


int read_lock(lockptr)
/*
 *	Sets a read_lock. In the parameter, the datafile name
 *	must be inicialized with the filename.
 *	The two handles will be filled, this structure must
 *	use to subsequent read_release call !!!
 */
LOCK	*lockptr;

{
if (network != YES)		/* is it a concurrent system		*/
	return(0);		/* no --> do nothing			*/

lockptr->s_name[1] = '+';			/* generate first name	*/

if (s_open(lockptr->s_name,1,&lockptr->s1) != 0)/* try to open it	*/
	return(1);				/* something went wrong	*/

if (s_wait(&lockptr->s1,100) != 0)		/* wait for the semaph.	*/
	{
	s_close(&lockptr->s1);			/* the file is written	*/
	return(2);				/* by an other station	*/
	}

lockptr->s_name[1] = '-';			/* generate second name	*/

if (s_open(lockptr->s_name,127,&lockptr->s2) != 0)/* try to open it	*/
	{
	s_close(&lockptr->s1);			/* something went wrong	*/
	return(3);
	}

s_sign(&lockptr->s1);				/* make free the first	*/
s_close(&lockptr->s1);				/* semaphore		*/

return(0);			/* read_lock succeed			*/
}


int read_release(lockptr)
/*
 *	Opens the read_lock previously set by read_lock
 *	The lock structure was inicialized by the
 *	read_lock function call
 */
LOCK	*lockptr;

{
if (network != YES)		/* is it a concurrent system		*/
	return(0);		/* no --> do nothing			*/

if (s_close(&lockptr->s2) != 0)	/* if the LOCK structure is	*/
	return(1);			/* damaged, return an error	*/
return(0);				/* return success		*/
}


int write_lock(lockptr)
/*
 *	Sets a write_lock (exclusive lock) to the file.
 *	The LOCK structure must be inicialized with the datafilename.
 *	Other fields of the structure will be filled. This values
 *	must preserve to a subsequent write_release call
 */
LOCK	*lockptr;

{
int	value;				/* work variables to function calls*/

if (network != YES)		/* is it a concurrent system		*/
	return(0);		/* no --> do nothing			*/

lockptr->s_name[1] = '+';			/* generates first name	*/
if (s_open(lockptr->s_name,1,&lockptr->s1) != 0)/* try to open it	*/
	return(1);				/* something went wrong	*/

if (s_wait(&lockptr->s1,100) != 0)		/* free for writing ??	*/
	{					/* no, return an error	*/
	s_close(&lockptr->s1);
	return(2);
	}

lockptr->s_name[1] = '-';			/* generate second name	*/
while (1)					/* while there are any	*/
	{					/* active read processes*/
	if (s_open(lockptr->s_name,1,&lockptr->s2) != 0)
		{
		s_sign(&lockptr->s1);
		s_close(&lockptr->s1);
		return(1);
		}

	if (s_exam(&lockptr->s2,&value) != 0)
		{
		s_sign(&lockptr->s1);
		s_close(&lockptr->s1);
		s_close(&lockptr->s2);
		return(1);
		}

	if (value == 1)				/* no process for the file*/
		return(0);			/* return succeed	  */

	s_close(&lockptr->s2);			/* close and try again	  */
	}
}


int write_release(lockptr)
/*
 *	Opens the write_lock. The LOCK structure was
 *	inicialized by a previous write_lock call
 */
LOCK	*lockptr;

{
if (network != YES)		/* is it a concurrent system		*/
	return(0);		/* no --> do nothing			*/

s_close(&lockptr->s2);
s_sign(&lockptr->s1);
return(s_close(&lockptr->s1));
}


int lock_record(fname,dbfptr,recno)
/*
 *	Locks the specified record
 */
char	*fname;			/* name of the datafile	*/
DBFFILE *dbfptr;		/* datafile descriptor	*/
RECNUM	recno;			/* record number to lock*/

{
char	lockname[100];
char	strrecno[10];
char	*gen_lock();
char	*strcat();

if (network != YES)		/* is it a concurrent system		*/
	return(0);		/* no --> do nothing			*/

if (dbfptr->_reclock != 0l)	/* there is already a record lock	*/
	return(1);

ltoa(recno,strrecno,16);
if (log_rec(gen_lock(fname,strrecno,lockname)) != 0)
	return(2);

dbfptr->_reclock = recno;
return(0);
} /* end of lock_record() */


int release_record(fname,dbfptr,recno)
/*
 *	Releases the specified record
 */
char	*fname;			/* name of the datafile	*/
DBFFILE *dbfptr;		/* datafile descriptor	*/
RECNUM	recno;			/* record number to lock*/

{
char	lockname[100];
char	strrecno[10];
char	*gen_lock();

if (network != YES)		/* is it a concurrent system		*/
	return(0);		/* no --> do nothing			*/

ltoa(recno,strrecno,16);
if (clear_rec(gen_lock(fname,strrecno,lockname)) != 0)
	return(1);

dbfptr->_reclock = 0l;
return(0);
} /* end of clear_record() */


int init_lock(lockptr,name)
/*
 *	A LOCK kommunikacios valtozot inicializalja
 */
LOCK	*lockptr;
char	*name;

{
char	*gen_semaph();

gen_semaph(name,lockptr->s_name,'+');
}


static char *gen_semaph(source,dest,fillch)
/*
 *	a function to generate NOVELL names from
 *	"C" strings. The first character of the NOVELL
 *	name will be "fillch"
 */
char *source;			/* "C" string			*/
char *dest;			/* NOVELL name			*/
char fillch;			/* the first character		*/

{
char *save = dest;

dest++;
*dest++ = fillch;

while ( (*dest++ = *source++) )	/* atmasoljuk a stringet	*/
	;
*save = dest-save - 1;			/* az elso byte a string hossza	*/
return(save);
}



static char *gen_lock(source1,source2,dest)
/*
 *	a function to generate NOVELL names from
 *	"C" strings.
 */
char *source1;			/* "C" string			*/
char *source2;			/* "C" string			*/
char *dest;			/* NOVELL name			*/

{
char *save = dest;

dest++;

for ( ; *source1 != '\0'; )
	*dest++ = *source1++;

for ( ; *source2 != '\0'; )
	*dest++ = *source2++;

*save = dest-save - 1;
return(save);
}
