/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include <fcntl.h>
#include <types.h>
#include <stat.h>
#include <share.h>
#include <io.h>

#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*   DBIOPEN                                            */
/********************************************************/

#define	NULL	(void *)0

int dBiopen(ndxname, ndxfd) /*** error assignment: 1400 ***/
       char *ndxname; /* pointer to a file name character string
                         that represents the .NDX file
	 	         to be opened */
       char **ndxfd;  /* index file descriptor */
{
extern NBYTES _nbytes();
int fn;	    /* file number */
NDXFILE *ndxptr;
BYTE *bufptr;
BYTE *header; /* [NDXHDRSZ] */
BYTE ktype;
extern NDXFILE _ndxfiles[];
extern int _dbcerr;
extern char *malloc(),*calloc();


if ((ndxptr = (NDXFILE *)calloc(1,sizeof(NDXFILE))) == NULL)
{
	_dbcerr = 1401;
	return(1); /* no free slot */
}
ndxptr->_ndxmode = 0x01;  		/*prevent this slot from collision*/


if ((fn=sopen(ndxname,O_RDWR|O_BINARY,SH_DENYNO)) < 0)
{
	free(ndxptr);
	_dbcerr = 1402;
	return(1); /* open failure */
}

if (!(header = malloc( (U2BYTES) 0x200) ) )
{
	free(ndxptr);
	close(fn);
	_dbcerr = 1403;
	return(1);
}

/* read the header information */
if (read(fn, header, 0x200) != 0x200)
{
	free(ndxptr); 
	free(header); 
	close(fn);
	_dbcerr = 1404;
	return(1); /* read failure */
}
	
bufptr = header;
ndxptr->_ndxfn = fn;
ndxptr->_ndxmode = 0x01; /* initially open for reading */
ndxptr->_orootbk = ndxptr->_rootblk = (BLKNO) _nbytes(bufptr);
bufptr += 4;
ndxptr->_oeofbk = ndxptr->_eofblk = (BLKNO) _nbytes(bufptr);
ndxptr->_maxknum = *(header + 0x0e);
ktype = *(header + 0x10);
if ((ktype != 0) && (ktype != 1))
{
	free(ndxptr); 
	free(header); 
	close(fn);
	_dbcerr = 1405;
	return(5); /* not .NDX file */
}	
ndxptr->_keytype = (ktype == 0) ? 0 : 1;
ndxptr->_keylen = *(header + 0x0c);
ndxptr->_kptrlen = *(header + 0x12);

free(header); 

ndxptr->_endofsv = ndxptr->_svector;
ndxptr->_endofsv--;
ndxptr->_svptr = ndxptr->_svector;
ndxptr->_svptr->_nxusage = 0x80; /* top index position */

if ((ndxptr->_actkey = malloc( ndxptr->_keylen )) == NULL)
{
	free(ndxptr);
	close(fn);
	_dbcerr = 1403;
	return(1);
}

*ndxfd = (char *) ndxptr;
return(0);

} /* end of dBiopen() */


int dBiclose(ndxfd) /*** error assignment: 1500 ***/
	char *ndxfd;
{
int origrc, ret0;
struct _seqacc *evp;
BYTE upbuf[8];
NDXFILE *ndxptr;
extern int _dbcerr;


ndxptr = (NDXFILE *) ndxfd; /* cast to NDXFILE first */

if (_ndxoff(ndxptr)) return(1);

if ( (origrc = dBiflsh(ndxfd)) == 0)
{
	ret0 = 0;
	if ( (ndxptr->_rootblk != ndxptr->_orootbk )
		|| (ndxptr->_eofblk != ndxptr->_oeofbk) )
	{
		/* 1 or more block were added: update eof and root in
	           block 0 */
		_bytesn(ndxptr->_rootblk, upbuf);
		_bytesn(ndxptr->_eofblk,  upbuf + 4);	

		if (lseek(ndxptr->_ndxfn, (long) 0L, 0) == -1L)  ret0++;
		if (write(ndxptr->_ndxfn, upbuf, 8) != 8) ret0++;
	}

	if (ret0)
	{
		_dbcerr	= 1503;
		origrc = 4;
	}
}

/* release vector buffer */
evp = ndxptr->_endofsv;
while (ndxptr->_svector <= evp)
{
	evp->_nxblkno = (BLKNO) 0;
	evp->_nxidno  = 0;
	if (evp->_nxbfptr) free(evp->_nxbfptr);
	evp->_nxbfptr = (char *) 0;
	evp->_nxusage = 0x00;

	evp--;
} /* end of while-loop */
/* end of releasing vector buffer */


if (close(ndxptr->_ndxfn))
{
	if (origrc == 0)
	{
		_dbcerr = 1504;
		origrc = 1;
	}
}
ndxptr->_ndxmode = 0x00;
free(ndxptr);			/* ugy allokaltuk		*/
	
return(origrc);

} /* end of dBiclose() */


int dBiflsh(ndxfd) /*** error assignment: 2800 ***/
	char *ndxfd;
{
extern int _ndxoff();
extern NBYTES _nbytes();
/* extern int rlsmem() */
int origrc, nonleaf;
NDXFILE *ndxptr;
struct _seqacc *evp;
extern int _dbcerr;


ndxptr = (NDXFILE *) ndxfd; /* cast to NDXFILE first */

if (_ndxoff(ndxptr)) return(1);

origrc = 0;

/* release vector buffer */
evp = ndxptr->_endofsv;
while (ndxptr->_svector <= evp)
{
	nonleaf = 0;
	if (evp->_nxusage & 0x1e)
	{
		/* nextblk check */
		if ( (BLKNO) _nbytes(evp->_nxbfptr + 4) )
		{
			*(evp->_nxbfptr) -= 1;
			nonleaf = 1;
		}

		if (origrc == 0)
		{

			if (lseek(ndxptr->_ndxfn,
				  (long) evp->_nxblkno * 512, 0) == -1L)
			{
				_dbcerr = 2801;
				origrc = 1;
			}
		}

		if (origrc == 0)
		{
			if (write(ndxptr->_ndxfn, evp->_nxbfptr, 512) 
			         != 512)
			{
				_dbcerr = 2802;
				origrc = 4;
			}
		}
		if (nonleaf) *(evp->_nxbfptr) += 1;
	}
	evp->_nxusage &= ~0x3f;
	evp->_nxusage |= 0x01;
	evp--;
} /* end of while-loop */
/* end of flushing vector buffer */

/*
 *	MI-SOFT: update the header information !!!
 */

if (origrc == 0)			/* no error occured		*/
	origrc = _writeihead(ndxptr);	/* write header information	*/

return(origrc);
} /* end of dbiflsh() */


int _ndxoff(ndxptr)   /*** error assignment: 1590 - 1599 ***/
	NDXFILE *ndxptr;
{
extern int _dbcerr;

if (ndxptr == NULL || (ndxptr->_ndxmode == 0x00))
{
	_dbcerr = 1590;
	return(1); /* NDX file not open */
}
return(0); /* NDX file open */
} /* end of _ndxoff() */
