/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/**********************************************
 *                  dbc.h                     *
 **********************************************/

#ifndef MSC
#define MSC /* Microsoft C Option */
#endif

#define dBC3  /* dBC III Option */

/*** dBC III New Types ***/
typedef unsigned char BYTE;     /* unsigned 1 byte data */
typedef unsigned short U2BYTES; /* unsigned 2 bytes data */

typedef long     RECNUM;   /* record number */
typedef BYTE     FLDWIDTH; /* field width in bytes or characters */
typedef BYTE     FLDDEC;   /* decimal places in field */
typedef BYTE     FLDNUM;   /* number of fields per record */
typedef U2BYTES  RECLEN;   /* record length */
typedef BYTE     KEYLEN;   /* key length */

/******************************************/
/* .DBF record field definition structure */
/******************************************/
typedef struct S_dBFIELD {
        char fieldnm[11]; /* field name terminating with NULL(0) */
        char type;        /* type of data */
			     /* 'C' - character
                                'N' - numeric
				   'D' - date
                                'L' - logical
				   'M' - memo    */
        FLDWIDTH width;   /* field width */
        FLDDEC   dec;     /* length of decimal places */
} dBFIELD;


typedef struct S_DBFFILE
{
        int      _dbffn;    /* file number */
        BYTE     _dbfmode;  /* mode of open file */
        RECNUM   _alcnum;   /* number of records allocated */
	 RECNUM	  _reclock;
	int      _dbfupd;   /* data file update indicator */
	RECLEN   _len;	    /* record length */

		/*** I/O buffer information ***/

	U2BYTES  _bufsize;  /* I/O buffer size */
        char     *_bfptr;   /* I/O buffer location pointer */
	U2BYTES  _maxnum;   /* maximum number of records in I/O buffer */
        RECNUM   _first;    /* number of first record in buffer */
	U2BYTES  _bfhas;    /* number of records currently contained
			       in buffer */
	BYTE     _month;    /* file update date: month */
	BYTE     _day;      /* 			 day   */
	BYTE     _year;	    /*			 year  */
	FLDNUM   _nflds;    /* number of fields per record */
	dBFIELD  *_flds;    /* pointer to array of dBC III field
			       structure(dBFIELD) */
	U2BYTES  _begdata;  /* beginning-of-data offset */
} DBFFILE;

typedef long      BLKNO; /* block number type */

/* index file(.NDX) definition structure */

typedef struct S_NDXFILE
{
        int      _ndxfn;    /* file number */
        BYTE     _ndxmode;  /* mode of open file */
	BLKNO    _orootbk;  /* original root block number */
	BLKNO    _oeofbk;   /* original end-of-file block number */
        BLKNO    _rootblk;  /* current root block number */
	BLKNO    _eofblk;   /* current end-of-file block number */
	KEYLEN   _keylen;   /* key length */
	KEYLEN   _kptrlen;  /* length of key and pointer (_keylen + ptr len) */
	BYTE     _maxknum;  /* maximum number of keys in a block */
	char	 _keytype;  /* key type: 'Character', 'Numeric' or 'Date' */

	BYTE	 *_actkey;  /* MI-SOFT	*/
	BLKNO	 _actpointer;		/* MI-SOFT	*/
	
		/*** used for sequential accessing ***/
	struct _seqacc
	{
		 BLKNO  _nxblkno;   /* block number */
		 BYTE   _nxidno;    /* index id number */
		 char   *_nxbfptr;  /* .NDX I/O buffer pointer */
                 BYTE   _nxusage;   /* buffer usage indicator */
	} _svector[32],  /* sequential access vector */
	  *_svptr, *_endofsv; /* pointers to sequential access vector */

} NDXFILE;

/* top-bottom bit definitions */

typedef struct S_DBTFILE
{
        int      _dbtfn;    /* file number */
        BYTE     _dbtmode;  /* mode of open file */
	BLKNO    _odbteof;  /* original end-of-file block number */
	BLKNO    _dbteof;   /* current end-of-file block number */
} DBTFILE;

/* constant definitions */

typedef long      NBYTES;

/***** record status definition *****/

#define ACTIVE    0 /* record is active */
#define INACTIVE  1 /* record is inactive (marked deleted) */

/***** key type definitions *****/

#define CHARKEY   'C' /* CHARACTER key */
#define NDKEY     'N' /* NUMERIC or DATE key */

/***********************************
* return values from dBC functions *
************************************/
#define SUCCESS   0    /** successful function return code **/
#define d_ERROR   1    /** general error code **/
			  /* This error code is returned by a function that
                             failed due to a fundamental reason such as wrong
                             input values or the file to be accessed is not
		             open. */
#define d_NODBF   2    /** accessed file is not organized in the data **/
		       /*  file(.DBF) format */
#define d_BADREC  3    /** specified record number is out of range, **/
		       /*  i.e., larger than the current number of allocated
                           records */
#define d_WTFAIL  4    /** file-write operation failed, e.g., "disk full" **/
#define d_NONDX   5    /** accessed file is not organized in the index **/
		       /*  file(.NDX) format */
#define d_KYLONG  6    /** too long key expression **/
#define d_NOKEY   7    /** index file(.NDX) is empty or requested key is
                           not found **/
#define d_MAYBE   8    /** requested key was not found in the index file, **/
		       /*  but another key that may immediately follow the
			   requested key was located */
#define d_ENDKEY  9    /** no more key exists in the index file **/
		       /*  the sequential-read key pointer is placed
			   at the end of the index file */
#define d_NOSYNC  10   /** key exists in the index file, but its **/
		       /*  corresponding record does not exist in the
			   specified data file */
#define d_TOPKEY  11   /** top of the index file condition **/
		       /*  the sequential-read key pointer reached 
			   the top of the index file */

#define d_NETERR1 1   /* MI-SOFT: Halozati hiba            */
#define d_NETERR2 3   /* MI-SOFT: Halozati hiba            */
#define d_LOCKERR 1   /* MI-SOFT: Hiba a lock-olasban      */
#define d_BUSY    2   /* MI-SOFT: Foglalt rekord vagy adatbazis */
#define d_COMPAT  1   /* MI-SOFT: NOVELL kompatibilis rendszer  */

/**********  synonyms for dBC function names ************/

        /* synonym */	   /* actual name */
/*         ---------          -----------          */
#define    dbcreat            dBcreat
#define    dbopen             dBopen
#define    dbclose            dBclose
#define    dbgetr             dBgetr
#define    dbgetf             dBgetf
#define    dbputr             dBputr
#define    dbupdr             dBupdr
#define    dbdelete           dBdelete
#define    dbrecall           dBrecall
#define    dbsize             dBsize
#define    dbstrcpy           dBstrcpy
#define    dbrmvr             dBrmvr
#define    dbflush            dBflush
#define    dbicreat           dBicreat
#define    dbiopen            dBiopen
#define    dbiclose           dBiclose
#define    dbakey             dBakey
#define    dbrmvkey           dBrmvkey
#define    dbtkey             dBtkey
#define    dbckey             dBckey
#define    dbnkey             dBnkey
#define    dbpkey             dBpkey
#define    dbrewind           dBrewind
#define    dbfwd              dBfwd
#define    dbgetrk            dBgetrk
#define    dbgetnr            dBgetnr
#define    dbgetpr            dBgetpr
#define    dbputrk            dBputrk
#define    dbkexpr            dBkexpr
#define    dbatofld           dBatofld
#define    dbfldtoa           dBfldtoa
#define    dbatokey           dBatokey
#define    dbkeytoa           dBkeytoa
#define    dbiflsh            dBiflsh
#define    dbmcreat           dBmcreat
#define    dbmopen            dBmopen
#define    dbmclose           dBmclose
#define    dbgetm             dBgetm
#define    dbputm             dBputm

#define _DBC_H /* turn _DBC_H switch on */

/* extern functions */

extern int /*open(),*/ read(), write(), close();
extern long lseek();
extern char *malloc();


/*
 *	MI_SOFT: stucture definitions to handle file locks
 *
 *		 file locks are handled on the base of the
 *		 NOVELL semaphore calls
 */


typedef struct	S_HANDLE	/* describes a semaphore handle		*/
	{
	int	base;
	int	offset;
} HANDLE;


typedef struct S_LOCK		/* the structure to handle file locks	*/
	{
	char	s_name[128];	/* datafile name with complete path	*/
	HANDLE	s1;		/* first semaphore handle		*/
	HANDLE	s2;		/* second semaphore handle		*/
	} LOCK;


#ifdef LINT_ARGS
/*global*/  int dBicreat(char *,char *,unsigned char ,char );
/*global*/  int dBatofld(char *,int ,int ,char *);
/*global*/  int dBfldtoa(char *,int ,char *);
/*global*/  int dBatokey(char *,char *);
/*global*/  int dBkeytoa(char *,char *);
/*global*/  int dBflush(char *);
/*global*/  int dBgetf(char *,unsigned short *,unsigned char *,unsigned char *,unsigned char *,unsigned char *,struct S_dBFIELD *);
/*global*/  int dBgetnr(char *,char *,char *,char *);
/*global*/  int dBcreat(char *,unsigned char ,struct S_dBFIELD *);
/*global*/  int dBrmvkey(char *,char *,long );
/*global*/  int dBgetr(char *,long ,char *,char *);
/*global*/  int dBgetrk(char *,char *,char *,char *,char *);
/*global*/  int dBkexpr(char *,char *,char *,int *,unsigned char *);
/*global*/  int dBnkey(char *,char *,long *);
/*global*/  int dBckey(char *,char *,long *);
/*global*/  int dBrewind(char *);
/*global*/  int dBpkey(char *,char *,long *);
/*global*/  int dBfwd(char *);
/*global*/  int dBgetpr(char *,char *,char *,char *);
/*global*/  int dBopen(char *,char * *);
/*global*/  int dBclose(char *);
/*global*/  int dBiopen(char *,char * *);
/*global*/  int dBiclose(char *);
/*global*/  int dBiflsh(char *);
/*global*/  int dBputr(char *,long ,char *);
/*global*/  int dBputrk(char *,char *,char *,char *);
/*global*/  int dBrmvr(char *,long );
/*global*/  int dBtkey(char *,char *,long *);
/*global*/  int dBrecall(char *,long );
/*global*/  int dBdelete(char *,long );
/*global*/  int dBupdr(char *,long ,char *);
/*global*/  int dBmcreat(char *);
/*global*/  int dBmopen(char *,char * *);
/*global*/  int dBmclose(char *);
/*global*/  int dBgetm(char *,char *,char *);
/*global*/  int dBputm(char *,char *,char *);
/*global*/  int dBsize(char *,long *);
/*global*/  void dBstrcpy(char *,char ,int ,char *);
/*global*/  int dBclibuf(struct S_NDXFILE *);
/*global*/  int dBclrbuf(struct S_DBFFILE *);
/*global*/  int read_lock(struct S_LOCK *);
/*global*/  int read_release(struct S_LOCK *);
/*global*/  int write_lock(struct S_LOCK *);
/*global*/  int write_release(struct S_LOCK *);
/*global*/  int lock_record(char *,struct S_DBFFILE *,long );
/*global*/  int release_record(char *,struct S_DBFFILE *,long );
/*global*/  int init_lock(struct S_LOCK *,char *);
/*global*/  int dBakey(char *,char *,long );
#endif
