/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/* DBATOKEY.C                                           */
/********************************************************/

extern U2BYTES  _montbl[]; /* See dbcgdata.c */

static U2BYTES _yeartbl[101] =
{0,
/*                    4                       8                      12     */
  365,  730, 1095, 1461, 1826, 2191, 2556, 2922, 3287, 3652, 4017, 4383,
/*                   16                      20                      24     */
 4748, 5113, 5478, 5844, 6209, 6574, 6939, 7305, 7670, 8035, 8400, 8766,
/*                   28                      32                      36     */
 9131, 9496, 9861,10227,10592,10957,11322,11688,12053,12418,12783,13149,
/*                   40                      44                      48     */
13514,13879,14244,14610,14975,15340,15705,16071,16436,16801,17166,17532,
/*                   52                      56                      60     */
17897,18262,18627,18993,19358,19723,20088,20454,20819,21184,21549,21915,
/*                   64                      68                      72     */
22280,22645,23010,23376,23741,24106,24471,24837,25202,25567,25932,26298,
/*                   76                      80                      84     */
26663,27028,27393,27759,28124,28489,28854,29220,29585,29950,30315,30681,
/*                   88                      92                      96     */
31046,31411,31776,32142,32507,32872,33237,33603,33968,34333,34698,35064,
/*             99  100 */
35429,35794,36159, 36524};

int dBatokey(ascii, numkey)
	char *ascii;
	char *numkey;
{
double a=0.0, b=0.0, fracmul=1.0;
double ans;
int sign=0;
int i;
BYTE digit;
BYTE *digptr;
int mon, day, year;
int leap;
extern int _2dignum();

if ((*numkey == 'D') || (*numkey == 'd'))
{
	/* year */
	if ((year = _2dignum(ascii + 2)) == -1) return(1);
	leap = ((!(year % 4)) && year) ? 1 : 0;
	/* month */
	if ((mon = _2dignum(ascii + 4)) == -1) return(1);
	if (mon < 1 || 12 < mon) return(1);

	/* day */
	if ((day = _2dignum(ascii + 6)) == -1) return(1);
	if (day < 1 || 31 < day) return(1);
	if ((day==31) && (mon==2 || mon==4 || mon==6 || mon==9 || mon==11))
		return(1);
	if (mon==2)
	{
		if (day==30) return(1);
		if ( (day==29) && !leap) return(1);
	}

	if ( (mon == 12) && (day == 31) )
		ans = _yeartbl[year + 1];
	if (!(year + 1) % 4) ans -= 1.0;
	else
	{
		ans = _yeartbl[year] + _montbl[mon - 1] + day;
		if (leap && (mon <= 2)) ans -= 1.0;
	};
	ans += 2415020.0;
}
else
{
	/* skip  white-spaces */
	while(1)
	{
		if (*ascii != ' ' && *ascii != (BYTE) 0x09) break;
							/* TAB==0x09 */
		ascii++;
	} /* end of while(1) */

	/* check sign,if any */
	if (*ascii=='+')
	{
		sign = 0;
		ascii++;
	}
	else if (*ascii=='-')
	{
		sign = 1;
		ascii++;
	}

	/* now, ascii is pointing to a digit */
	ascii--;
	while ((digit = *++ascii) == '0'); /* skip leading zeros */
	while ('0'<=digit && digit<='9')
	{
		a = a*10 + (digit - '0');
		digit = *++ascii;
	}

	/* now, ascii may be pointing to '.' */
	if (*ascii == '.')
	{
		digit = *++ascii;
		while ('0'<=digit && digit<='9')
		{
			fracmul = fracmul*0.1;
			b = b + (digit-'0')*fracmul;
			digit = *++ascii;
		}
	}
	ans = a + b;
	if (sign != 0) ans = -ans;
}
digptr = (BYTE *) &ans;
for (i=1; i<=8; i++) *numkey++ = *digptr++;
return(0);
} /* end of dBatokey() */

static int _2dignum(dig)
	BYTE *dig;
{
	int dn;

	if (*dig < '0' || '9' < *dig) return(-1);
	if (*(dig+1) < '0' || '9' < *(dig+1)) return(-1);

	dn = (*dig++ - '0') * 10;
	dn += (*dig - '0');
	return(dn);
} /* end of _2dignum() */
int dBkeytoa(key, ascii)
	char *key;
	char *ascii; /* *ascii => decimal places & *(ascii+1) => type) */
{
static BYTE digarray[62+5];
BYTE decimal, decctr;
BYTE type;
int i, below0, decpt, fdigs;
int intexist; /* 1: integer portion exists   0: no integer part exists */
int frcexist; /* 1: fraction is non-zero     0: fractional part is 0 */
BYTE *cptr, *p1, *p2, temp, *retptr;
double intpart, fracpart, ipart;
double value = 0.0;
extern double _dBmodf();
extern int _ascdate(); 

cptr = (BYTE *) &value;
for (i=1; i<=8; i++) *cptr++ = *key++;
type = *(ascii + 1);
if ( (type != 'D') && (type != 'd') )
{
	decimal = *ascii + 1;
	if ((decimal < 1) || (60 < decimal)) decimal = 3; /* dec. pt. => 2 */
}
else
{ /* (type == 'D' || type == 'd') */
	decimal = 1;
	if (value < 2415021.0 || 2451544.0 < value)
	{
		*ascii = 0;
		return(1);
	}
	return(_ascdate((U2BYTES) (value - 2415020.0), ascii));
}

if (value == 0.0)
{
	*ascii++ = '0';
	if (decimal > 1)
	{
		*ascii++ = '.';
		while(--decimal) *ascii++ = '0';
	}
	*ascii = (BYTE) 0; /* NULL */
	return(0);
}

decctr = decimal;

if (value < 0.0)
{
	value = -value;
	*ascii++ = '-';
}

below0 = 0;
intexist = (value >= 1.0) ? 1 : 0;

cptr = digarray;

/* put initial zero in case of possible later round off effect */
*cptr++ = '0';

fracpart = _dBmodf(value, &intpart);

frcexist = (fracpart == 0.0) ? 0 : 1;

i = 0;
if (intexist)
{
	/* get integer portion */
	while ((intpart >= 1.0) && (i <= 62))
	{
		_dBmodf(intpart/10.0, &ipart);
		*cptr++ = ((BYTE) (intpart - ipart*10.0)) + '0';
		intpart = ipart;
		i++;
	}

	/* reverse the order of the integer part of character digits */
	for (p1=digarray+1, p2=cptr-1;
	     (p1 < p2) && (i<=62);
	     p1++, p2--)
	{
			temp = *p1;
			*p1 = *p2;
			*p2 = temp;
	}
}
else
{
	while ((fracpart < 0.1) && (below0 < decimal)
		&& (below0 <= 62))
	{
			fracpart *= 10.0;
			below0++;
	}	
}

decpt = cptr - digarray - 1 - below0;

/* get fractional portion */
if (frcexist)
{
	fdigs = 0;
	while ((decctr--) && (i<=62))
	{
		fracpart = fracpart * 10;
		fracpart = _dBmodf(fracpart, &intpart);
		*cptr++ = ((BYTE) intpart) + '0';
		fdigs++;
		i++;
	}

	*cptr = '0'; /* put extra '0' to avoid round off error */

	/* round off digarray */
	cptr = digarray + i - below0;

	if (*cptr >= '5')
	{
		*--cptr += 1;
		while (digarray < cptr)
		{
			if (*cptr <= '9') break;
			*cptr-- = '0';
			*cptr += 1;
		}
	}
}

if (!intexist && !below0 && (cptr == digarray))
	intexist = 1; /* integer part exist after round off */

if (!intexist)
{
	if (cptr==digarray)
	{
		retptr = digarray;
		below0--;
	}
	else
	{
		retptr = digarray + 1;
	}
	*ascii++ = '0';
	if (decimal > 1)
	{
		*ascii++ = '.';
		while(below0--)
		{ /* e.g., 0.0001 */
			*ascii++ = '0';
			fdigs--;
		}
	}
}
else
{
	/* integer portion exists */
	if (cptr==digarray)
	{
 		decpt += 1;
		retptr = digarray;
	}
	else
	{
		retptr = digarray + 1;
	}

	for (i=1; i<=decpt; i++) *ascii++ = *retptr++;
	if (decimal > 1)
	{
		*ascii++ = '.';
		if (!frcexist)
		{
			while(--decctr) *ascii++ = '0';
		}
	}
}

if (frcexist && fdigs)
	while (--fdigs) *ascii++ = *retptr++;

/* put NULL character at the end of string */
*ascii = (char) 0; 

return(0);

} /* end of dBkeytoa() */


/**
*
* name
*	_dBmodf - split into mantissa and exponent
*
* synopsis
*
*	double _dBmodf(value, iptr)
*	double value, *iptr;
*
* description
*	_dBmodf returns the signed fractional part of value and stores the
*	integral part indirectly in the location pointed to by iptr.
*
**/


/**********************************************************************
* dBC III numeric key is stored in 8 bytes in the IEEE format
* where an INTEL 8087 long real number(64 bits) is stored.
* Modf function accesses a "double" number as a 4-integer quantity
* data.  (Reference: INTEL iAPX86/88, 186/188 User's Manual)
***********************************************************************/
static double _dBmodf(value, iptr)
	double value, *iptr;
{
int exponent;
U2BYTES *ptrtoint;

exponent =
(( (U2BYTES) *(( (U2BYTES *) &value) + 3) >> 4) & 0x7ff) - 0x3ff;

if (exponent < 0)
{
	/* this means "fabs(value) < 0.0" */
	*iptr = 0.0;
	return(value);
}

if (exponent >= 52)
{
	*iptr = value;
	return(0.0);
}

exponent = 52 - exponent;
	
*iptr = value;

ptrtoint = (U2BYTES *) iptr;
while(exponent > 0)
{
	if (exponent < 16)
		*ptrtoint &= (U2BYTES) ( (U2BYTES) 0xffff << exponent);
	else
		*ptrtoint = 0;

	ptrtoint++;
	exponent -= 16;
}

/*return fractional part */
return(value - *iptr);
} /* end of _dBmodf() */

static int _ascdate(dateval, ascdate)
	U2BYTES dateval;
	char     *ascdate;
{
U2BYTES index, year, month, day;
char asciidat[9], *cptr;
int i, leap;
extern void _numtoasc();
extern U2BYTES _bsearch();

index = _bsearch(dateval, _yeartbl,
		 (U2BYTES) 0, (U2BYTES) 50, (U2BYTES) 99);
year = index;

dateval -= _yeartbl[index];

if (index && !(index % 4))
{
	leap = 1;
}
else
{
	leap = 0;
}
index = _bsearch(dateval, _montbl, (U2BYTES) 0, (U2BYTES) 5, (U2BYTES) 11);

if (_montbl[index] == dateval)
{
	if (!index) index = 1;
	month = index;
	if (leap && (month<=2)) dateval += 1;
	day = dateval - _montbl[index - 1];
}
else
{
	month = index + 1;
	if (leap && (index<=1)) dateval += 1;
	day = dateval - _montbl[index];
}
strcpy(asciidat, "19yymmdd");
if (!day && (month == 1))
{
	year -= 1;
	month = 12;
        day   = 31;
}
if (day==32 && month==1)
{
	month = 2;
	day = 1;
}
_numtoasc(year,  asciidat + 2);
_numtoasc(month, asciidat + 4);
_numtoasc(day,   asciidat + 6);

cptr = asciidat;
for (i=1; i<=8; i++) *ascdate++ = *cptr++;
*ascdate = 0;
return(0);

} /* end of _ascdate() */

static void _numtoasc(dig2, ascii)
	U2BYTES dig2;
	BYTE     *ascii;
{
	*ascii++ = ((dig2/10) % 10) + '0';
        *ascii   = (dig2 % 10) + '0';
}

static U2BYTES _bsearch(dateval, table, top, middle, bottom)
	U2BYTES dateval;
	U2BYTES *table;
	U2BYTES top, middle, bottom;
{


while (top < middle)
{

	if (*(table + middle) == dateval)
	{
		break;
	}
	if (*(table + middle) > dateval)
	{
		bottom = middle;
		middle = (top + middle) / 2;
	}
	else
	{
		top = middle;
		middle = (middle + bottom) / 2;
	}
}


if (*(table + bottom) <= dateval) return(bottom);

return(middle);

} /* end of _bsearch() */

