/**** DBC simple, Microsoft v4.0, MI Software ***/
/* 1987 Sept. 4. */
 
/*$-g*/
#include "dbc.h"

#ifdef LINT_ARGS
#include "dBc.lnt"
#endif
/*$+g*/

/********************************************************/
/*  DBATOFLD.C                                          */
/********************************************************/

int dBatofld(ascii, width, decimal, field)
	char *ascii;
	int width;
	int decimal;
	char *field;
{
int i;
int blnkpart, intpart, padzero;
int inputlen, decplace;
int maxipart;
BYTE *digptr;

if (width <= 0 || decimal < 0) return(1);
if (decimal && (width < (decimal + 2))) return(1);

if (_scrasc(ascii, &digptr, &inputlen, &decplace) != 0)
	return(1);

if (!inputlen)
{
	/* 'zero' case */
	digptr = (BYTE *) field;
	for (i=1; i<=width; i++) *digptr++ = ' ';
	if (!decimal) *--digptr = '0';
	else {
		for (i=1; i<=decimal; i++) *--digptr = '0';
		*--digptr = '.';
		*--digptr = '0';
	}
	return(0);
}

maxipart = decimal ? (width - decimal - 1) : width;

intpart = decplace ? (inputlen - decplace - 1) : inputlen;

if (intpart > maxipart) return(1);

/************************ BEGIN ******************************
 paper caluculation for the following line:
	"blnkpart = (intpart < maxipart) ? maxipart - intpart : 0;"
	
if (intpart == maxipart) {
	blnkpart = 0;
	intpart = maxipart;
}
else if (intpart < maxipart) {
	blnkpart = maxipart - intpart;
}
************************* END *******************************/

blnkpart = (intpart < maxipart) ? maxipart - intpart : 0;

if (decimal < decplace) decplace = decimal;

padzero = (decimal > decplace) ? decimal - decplace : 0;

for (i=1; i<=blnkpart; i++) *field++ = ' ';
for (i=1; i<=intpart; i++)  *field++ = *digptr++;
if  (decimal) {
	*field++ = '.';
	if (decplace) digptr++;
}
for (i=1; i<=decplace; i++) *field++ = *digptr++;
for (i=1; i<=padzero; i++)  *field++ = '0';

return(0);

} /* end of dBatofld() */


/*************************************************************************
*
* NAME		dBfldtoa
*
* ABSTRACT	convert numeric field to ASCII
*
* DESCRIPTION	dBfldton converts a .DBF numeric field to an ASCII
*		character string that represents a floating-point number.
*		The string is terminated with a NULL(\000) character.
***************************************************************************/

int dBfldtoa(field, width, ascii)
	char *field;
	int  width; /* width defined in .DBF */
	char *ascii;
{
	int i;
	
	if (width <= 0) return(1);

	while (*field == ' ') {
		width--;
		field++;
	}
	if (width <= 0) return(1);

	for (i=1; i<=width; i++) *ascii++ = *field++;
	*ascii = 0;

	return(0);

} /* end of dBfldtoa() */
