/***************************************************************************
These C++ classes are copyright 1990, by William Herrera.
All those who put this code or its derivatives in a commercial product MUST
mention this copyright in their documentation for users of the products in
which this code or its derivative classes are used.  Otherwise, this code
may be freely distributed and freely used for any purpose.

Enhancements: 1991 by David Orme
	*  General cleanup.
			- I/O now takes advantage of C++ overloading.
			- Serial port I/O functionality now only in Serial class.
			- Modem functionality now only in Modem class.
	*  Possible to easily implement file Xfr prots now.
	*  CCITT CRC-16 class added							-- 2-20-1991
	*  BIOS Timer class added								-- 2-22-1991
	*  Optional timeout on all input routines added	-- 2-25-1991

***************************************************************************/

// file modem.hpp class declaration of modem class.

#ifndef MODEM_HPP
#define MODEM_HPP 1
			   
#include "serialpo.hpp"

extern const char inits[];
extern const char tonedials[];
extern const char pulsedials[];
extern const char answers[];
extern const char hangups[];
extern const char resets[];
extern const char returns[];
extern const char escapes[];
extern const char defaultcfgs[];


class modem : public SerialPort
{
protected:
	char * init;
	char * tonedial;
	char * pulsedial;
	char * answer;
	char * hangup;
	char * reset;
	char * retrn;
	char * escape;
public:
	modem(int portnum = 1, int speed = 2400, 
					parity_t p = NOPAR, int sbits = 1, 
					int dbits = 8, boolean trans = false);
	~modem();
	void ConfigureFromFile(const char * pathname = defaultcfgs);
	void Initialize();
	void Dial(char * number, boolean tone = true);
	void HangUp();
	void Answer();
	void Escape();
	void SendCommand(char * command);
};

#endif


// end of file modem.hpp
