//#include "catit.h"

/***********************\
|                       |
| Printer Control Codes |
|                       |
\***********************/

#define PRN_LF	          "\x0a"      // LINEFEED
#define PRN_FF	          "\x0c"      // FORMAFEED
#define PRN_CR            "\x0d"      // CR ( no linefeed needed )
#define PRN_DOUBLE_ON     "\x0e"      // START DOUBLE WIDTH( ends at CR or LF )
#define PRN_DOUBLE_OFF    "\x14"      // ENDS DOUBLE WIDTH
#define PRN_CONDENSED_ON  "\x0f"      // CONDENSE MODE ON
#define PRN_CONDENSED_OFF "\x12"      // CONDENSE MODE OFF
#define PRN_SELECT        "\x11"      // SELECT PRINTER
#define PRN_DESELECT      "\x13"      // DESELECT PRIINTER
#define PRN_CLEAR_BUF     "\x18"      // CLEAR BUFFER

/***********************\
|                       |
|    ESC sequences      |
|                       |
\***********************/

#define PRN_UNDERLINE_ON    "\x1b\x2d\x31"   // UNDERLINE ON
#define PRN_UNDERLINE_OFF   "\x1b\x2d\x30"   // UNDERLINE OFF
#define PRN_EMPHASIZED_ON   "\x1b\x45"       // EMPHASIZED
#define PRN_EMPHASIZED_OFF  "\x1b\x46"
#define PRN_DSTRIKE_ON      "\x1b\x47"       // DOUBLE STRIKE
#define PRN_DSTRIKE_OFF     "\x1b\x48"
#define PRN_SUPERSCRIPT_ON  "\x1b\x53\x30"   // SUPERSCRIPT
#define PRN_SUBSCRIPT_ON    "\x1b\x53\x31"   // SUBSCRIPT
#define PRN_SUB_SUPER_OFF   "\x1b\x54"
#define PRN_HARD_DOUBLE_ON  "\x1bW\x31"   // DOUBLE WIDTH( not canceled by CR or LF )
#define PRN_HARD_DOUBLE_OFF "\x1bW\x30"   // DOUBLE WIDTH OFF

#define PRN_8LPI            "\x1b\x30"       // 8 LINES/INCH
#define PRN_7LPI            "\x1b\x31"       // 7/72 LPI

#define PRN_HOME_HEAD       "\x1b<"       // HOME HEAD

/***********************\
|                       |
|     Functions :       |
|                       |
\***********************/


int reset_printer( int num );
int printit( int num,char *mit );
int print_header( char demo );
void print_footer( void );

void printlist( void );
void filter(char van);
void fileba(char igen);
void printdisk( TitleRType *title, FileRType *ft, int nelem);