#include <dir.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <mem.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#include "mouse.h"
#include "screen.h"
#include "catit.h"
#include "ct_data.h"
#include "wnd.h"
#include "uc2_view.h"

int arjview ( char afnev[], int (*fw)(FileRType* rr) );
int arcview( char *name, int (*fw)(FileRType* rr) );
int zipview( char *name, int (*fw)(FileRType* rr) );
void keres( char pp[], int (*fw)(FileRType* rr) );
void filenezes( long kezd , long veg );  // !!! REVISE !!!
int fwfunc(FileRType* rr);
int fwcount=0;
FileRType fls;
int rddisknum;
void filenez(void);

TitleRType cm,cm2;

void save_comments(long kezd,long veg,char *fname);
void apply_comments(long kezd,long veg,char *fname);

int lemez_beolvasas(void)
{
 int drvch='A';
 char buf[30];
 int dsk=0;
 int nlabel=0;
 struct dfree free;
 int dr,c,ch;

 fwcount=0;
 xnyit(XW_LBEOLV);
  m_hide();
  cprintf("%s : ",xmsg[ M_MEGHAJTO ] );
  textattr(240); c=wherex(); putch(defdisk); textattr(79);
  cprintf("\n\r%s",xmsg[ M_DRIVE_LETTER ]);
  m_show();
  textattr(240);
  drvch=defdisk;
  do
   {
    ch=255;
    while ( !kbhit() && !left_button_pressed() && !right_button_pressed() );
    if ( left_button_pressed() )   ch=13;
    if ( right_button_pressed() )  ch=27;
    if ( kbhit() )
     ch=toupper(getch());
    if ( ch==0 ) getch();
    if ('A'<=ch && ch<='Z')
     { drvch=ch; gotoxy(c,1); putch(drvch); }
   }
  while (! (ch==13 || ch==27) ); // || ('A'<=ch && ch<='Z')));
  textattr(79);

  if (ch==27)
   {
    sound1();
    csuk();
    return(0);
   }
  defdisk=drvch;
 csuk();

 xnyit(XW_LBEOLV2);
  textcolor(WHITE);
  m_hide();
  cprintf("%s\r",xmsg[ M_LEMEZ_ANALIZALAS ]);
  m_show();
  if (diskchange(drvch-65))
   ;;//fdcreset();
  dr=drive_ready(drvch-65);
  //diskchange();
  if (dr==0)
   getdfree( drvch-64 , &free );
  if ( (free.df_sclus == 0xFFFF)||(dr!=0) )
   {
    xnyit(XW_BEOLV_FIGY);
    aprintf(-1,YELLOW+16*RED, xmsg[ M_DRV_NEM_KESZ ], drvch );
    m_hide();
    cprintf( "%s" , xmsg[M_PRESS_ANY_KEY] );
    m_show();
    getch();
    csuk();
    csuk();
    m_setcursor( MC_NORMAL );
    return( -1);
   }
  cm.free = (long) free.df_avail
	  * (long) free.df_bsec
	  * (long) free.df_sclus;

  cm.total = (long) free.df_total
	   * (long) free.df_bsec
	   * (long) free.df_sclus;

  ff.setpos( F_SEEKEND );
  cm.kezd = ff.getpos();
  rddisknum=0;
  sprintf(buf,"%c:\\*.*",drvch);
  clreol();
  m_shide();
  cprintf("%s\n\r",xmsg[ M_LEMEZ_OLVASASA ]);
  m_sshow();
  rddisknum=0;
  keres( buf, fwfunc );
  cm.veg = ff.getpos()-1;

  nlabel = GetLabelNo( drvch-65 );
  if (dsk==0 && rddisknum!=0 )
   nlabel = rddisknum;
  dsk=nlabel;

 csuk();

 /***********************/

 char rct,rvt;
 struct  time tm;
 struct  date dt;
 struct ftime ft;
 char ct1[]="?";
 char ct2[]="?";
 int f2;
 static char sor1[52];

 ct1[0]=toupper( xmsg[M_LIST_KEY][0] )-'A'+1;
 ct2[0]=toupper( xmsg[M_LIST_KEY][0] )-'A'+1;

 int nattr=WHITE+16*BLUE;
 int iattr=BLACK+WHITE*16;

 //nyit(8,10,63,4,xmsg[ M_LEMEZCIMKE_CIM ],WHITE+CYAN*16,WHITE+CYAN*16,BLUE,4);
 xnyit(XW_BEOLV_CIM);
  if (dsk<=0)
   {
    if (lastnum==0)
     lastnum=maxdn;
    dsk=lastnum+1;
   }

  sfnc fnn[3];
  fnn[0].kar=toupper( xmsg[M_LIST_KEY][0] )-'A'+1;
  fnn[0].kar2=0;  fnn[0].fn=filenez;
  fnn[1].kar=0; fnn[1].kar2=0;

SzamBeker:
  textattr(nattr);
  m_hide(); cprintf("%s\n\r",xmsg[ M_LISTA_A_LEMEZROL ]); m_show();

  m_hide(); cprintf("%s : ",xmsg[ M_LEMEZSZAM ]); m_show();
  textattr(iattr);
  rct=0;
  while ( (cm.disknum = xread5d( (DEMOVER) ? DEMODISKNUM : 30000,dsk,&fnn[0]))<=0 )
   {
    if (cm.disknum < 0) // Back  //dsk=0;
     {
      m_setcursor( MC_WAIT );
      if (cm.kezd<=cm.veg)  // <-<-<-<-<-<-<-<-<-<-<-<-<}
       {
	textattr(nattr);
	m_shide();
	cprintf("\n%s...",xmsg[ M_TORLES ]);
	m_sshow();
	f2 = ff.DeleteFiles(cm.kezd,cm.veg);
	cprintf("\n\r");
       }
      m_setcursor( MC_NORMAL );
      csuk();
      return(-1);
     }
   }

  textattr(nattr);

  m_shide();
  cprintf("\r%s : ",xmsg[ M_LEMEZSZAM ]);
  textattr( YELLOW+BLUE*16 );
  cprintf("%5d", cm.disknum );
  m_sshow();

  textattr(nattr);
  lastnum=cm.disknum;
  cprintf("\n\r");

  tf.setpos( F_SEEKEND );

  if ( diskpos[cm.disknum] != NODISK )
     //--------------------}
     //  Ltezik a lemez   }
     //--------------------}
   {
    tf.setpos( diskpos[cm.disknum] );
    tf.read( &cm2 );
    aprintf(-1,YELLOW+16,"%s : ~%3d~\n\r"
	    "%s : ~%s~\n\r" , xmsg[ M_LEMEZSZAM ], cm2.disknum , xmsg[ M_LEIRAS ], cm2.sor1 );

    elnyelo();
    cprintf("%s",xmsg[ M_FELULIR ]);

      cursoron();
      do
       {
	ch = toupper(getch());
       }
      while ( !(ch==xmsg[M_YES_NO_KAR][0] || ch==xmsg[M_YES_NO_KAR][1] ) );
      cprintf(" ");
      YesNo( (ch!=xmsg[M_YES_NO_KAR][1]) );
      cprintf("\n\r");

      cursoroff();

      if (ch==xmsg[M_YES_NO_KAR][1])  // Nem - Nein - No
	// +-----------------+
	// | Ne rja fell ! |
	// +-----------------+
       {
	textattr(nattr); clrscr();
	goto SzamBeker;
       }
      // +            +
      //   rja fell
      // +            +

      if ((cm.disknum!=nlabel)&&(cimir!=0))
       {
	m_shide();
	cprintf("%s\n\r",xmsg[ M_CIMKE_IRASA ]);
	m_sshow();
	SetLabelNo(drvch-65,cm.disknum);
       }
      strncpy(cm.sor1,cm2.sor1,50);
      cm.sor1[50]='\0';
      rvt=0;
IrFBeker:
      textattr( nattr );
      clrscr();
      m_shide();
      cprintf("%s\n\r",xmsg[ M_LISTA_A_LEMEZROL ]);
      cprintf("%s : ",xmsg[ M_LEIRAS ]);
      textattr(iattr);
      m_sshow();

      elnyelo();

      //while ( readstr( (char *)cm.sor1 , 50 )==0 )
      // { textattr( 31 ); cprintf("\r%s : ",xmsg[ M_LEIRAS ]); textattr( 15*16 ); }
      rct=0;
      cursoron();
      if ( xreadstr( &cm.sor1[0] , 50 , rvt , &fnn[0] , Q_TITLE) == -1 )
       {
	/*
	if ( rct!=0 )
	 {
	  filenezes( cm.kezd , cm.veg );
	  textattr(nattr); clrscr();
	  rvt=2;
	  goto IrFBeker;
	 }
	*/
	textattr(nattr); clrscr();
	goto SzamBeker;
       }

      textattr(nattr);
      cprintf("\r%s : ",xmsg[ M_LEIRAS ]);
      textattr( 15+16*8 );
      cprintf("%s",cm.sor1);

      textattr(nattr);
      cprintf("\n\r");

      if (cm2.kezd <= cm2.veg)
       {
        char *tn;
        tn=tempnam(NULL,"CATLT");

        cprintf(xmsg[M_SAVE_COMMENTS]);
        save_comments(cm2.kezd,cm2.veg,tn);
        cprintf(xmsg[M_APPLY_COMMENTS]);
        apply_comments(cm.kezd,cm.veg,tn);
        unlink(tn);

	cprintf("\n%s\n",xmsg[ M_REGI_TORLES ]);
	f2 = ff.DeleteFiles(cm2.kezd,cm2.veg);
	cprintf("\n\r");
	if (f2 != 0)
	 tf.TitleMod(cm2.veg,f2);
	cm.kezd=cm.kezd-f2;
	cm.veg=cm.veg-f2;
       }
      gettime(&tm);
      getdate(&dt);
      ft.ft_tsec = tm.ti_sec/2;   /* Two seconds */
      ft.ft_min  = tm.ti_min;    /* Minutes     */
      ft.ft_hour = tm.ti_hour;  /* Hours       */
      ft.ft_day  = dt.da_day;          /* Days        */
      ft.ft_month= dt.da_mon;       /* Months      */
      ft.ft_year = dt.da_year-1980;  /* Year - 1980 */
      cm.updated = ft;
      if (cm2.dataver >= 1 )
       cm.created=cm2.created;
      else
       cm.created=cm.updated;
      tf.setpos( diskpos[cm.disknum] );
     }
   else
    // +                    +
    //   Nemltezik a lemez
    // +                    +
    {
     strncpy(cm.sor1,sor1,50);
     cm.sor1[50]='\0';
     if ((cm.disknum!=nlabel)&&(cimir!=0))
      {
       m_shide();
       cprintf("%s\n\r",xmsg[ M_CIMKE_IRASA ]);
       m_sshow();
       SetLabelNo(drvch-65,cm.disknum);
      }
     elnyelo();
     rvt=0;
IrBeker:
     m_shide();
     clrscr();
     textattr(nattr);
     cprintf("%s\n\r",xmsg[ M_LISTA_A_LEMEZROL ]);
     cprintf("%s : ",xmsg[ M_LEIRAS ]);
     m_sshow();
     textattr(15*16);
     rct=0;
     cursoron();
     if ( xreadstr( &cm.sor1[0] , 50 , rvt , &fnn[0] ,Q_TITLE) == -1 )
       {
	/*
	if ( rct!=0 )
	 {
	  filenezes( cm.kezd , cm.veg );
	  textattr(nattr); clrscr();
	  rvt=2;
	  goto IrBeker;
	 }
	*/
	textattr(nattr); clrscr();
	goto SzamBeker;
       }

     cursoroff();
     textattr(nattr);
     m_shide();
     cprintf("\n\r");
     m_sshow();
     gettime(&tm);
     getdate(&dt);
     ft.ft_tsec = tm.ti_sec/2;   /* Two seconds */
     ft.ft_min  = tm.ti_min;    /* Minutes     */
     ft.ft_hour = tm.ti_hour;  /* Hours       */
     ft.ft_day  = dt.da_day;          /* Days        */
     ft.ft_month= dt.da_mon;         /* Months      */
     ft.ft_year = dt.da_year-1980;  /* Year - 1980 */
     cm.created = ft;
     cm.updated = ft;
    }

   int d;

   strcpy(sor1,cm.sor1);
   d = tf.getpos();
   cm.dataver = DVER;
   tf.write( &cm );
   diskpos[cm.disknum] = d;

   mindn = cm.disknum < mindn ? cm.disknum : mindn;
   maxdn = cm.disknum > maxdn ? cm.disknum : maxdn;
 csuk();
 return 0;
}

int fwfunc( FileRType* rr )
{
 fwcount++;
 ff.write(rr);
 return 0;
}

void filenez(void)
{
 filenezes(cm.kezd,cm.veg);
}

/************************************************************/

char *expand( char *nev )
{
 char s[80];
 char drive[MAXDRIVE];
 char dir[MAXDIR];
 char file[MAXFILE];
 char ext[MAXEXT];
 //int flags;

 //flags=
 fnsplit(nev,drive,dir,file,ext);

 //s = (char *) malloc(15);
 //if(flags & FILENAME)
 //  cprintf("\tfile: %s\n",file);
 sprintf(s,"%-8s%-4s",file,ext);
 //if(flags & EXTENSION)
 //  cprintf("\textension: %s\n",ext);

 return ( s );
}
/****************************
	  /\  |-\   |
	 |  | |_/   |
	 +--+ |\    |
	 |  | | \ \_/
*****************************/
struct arj_main_head
 {
  unsigned headerid; // header id (main and local file) = 0xEA60 or 60000U
  unsigned headsize; // basic header size (from 'first_hdr_size' thru 'comment' below)
		     // = first_hdr_size + strlen(filename) + 1 + strlen(comment) + 1
		     // = 0 if end of archive

  char first_hdr_size; // (size up to and including 'extra data')
  char version;        // archiver version number
  char minver;         // minimum archiver version to extract
  char host_OS;        // host OS   (0 = MSDOS, 1 = PRIMOS, 2 = UNIX, 3 = AMIGA, 4 = MAC-OS)
		       // (5 = OS/2, 6 = APPLE GS, 7 = ATARI ST, 8 = NEXT)
		       // (9 = VAX VMS)
  char arj_flags;   /* arj flags
		     (0x01 = NOT USED)
		     (0x02 = RESERVED)
		     (0x04 = VOLUME_FLAG)  indicates presence of succeeding
					   volume
		     (0x08 = NOT USED)
		     (0x10 = PATHSYM_FLAG) indicates archive name translated
					   ("\" changed to "/")
		     (0x20 = BACKUP_FLAG) indicates backup type archive
		    */
  char res1;           // reserved
  char file_type;      // file type (2 = comment header)
  char res2;           // reserved
  ftime created;       // date time when original archive was created
  char res3[4];        // (future use may be archive size starting at main header)
  char res4[4];        // reserved
  char res5[4];        // reserved
  char fspos[2];       // filespec position in filename
  char unused1[2];     // (currently not used)
  char unused2[2];     // (currently not used)
 };
      /***
       ?   (currently none)

       ?   filename of archive when created (null-terminated string)
       ?   archive comment  (null-terminated string)

       4   basic header CRC

       2   1st extended header size (0 if none)
       ?   1st extended header (currently not used)
       4   1st extended header's CRC (not present when 0 extended header size)
     ***/

struct arj_local_head
 {
  unsigned headerid; // header id (main and local file) = 0xEA60 or 60000U
  unsigned headsize;
                 /*
                 basic header size (from 'first_hdr_size' thru 'comment' below)
		 = first_hdr_size + strlen(filename) + 1 + strlen(comment) + 1
		 = 0 if end of archive
                 */
  char first_hdr_size; // (size up to and including 'extra data')
  char version;       // archiver version number
  char minver;        // minimum archiver version to extract
  char host_OS; /* host OS   (0 = MSDOS, 1 = PRIMOS, 2 = UNIX, 3 = AMIGA, 4 = MAC-OS)
		  (5 = OS/2, 6 = APPLE GS, 7 = ATARI ST, 8 = NEXT)
		  (9 = VAX VMS)
		*/
  char arj_flags; /*  (0x01 = GARBLED_FLAG) indicates passworded file
		     (0x02 = RESERVED)
		     (0x04 = VOLUME_FLAG)  indicates continued file to next
					   volume (file is split)
		     (0x08 = EXTFILE_FLAG) indicates file starting position
					   field (for split files)
		     (0x10 = PATHSYM_FLAG) indicates filename translated
					   ("\" changed to "/")
		     (0x20 = BACKUP_FLAG)  indicates file marked as backup
                  */
  char method; // (0 = stored, 1 = compressed most ... 4 compressed fastest)
  char file_type; // (0 = binary, 1 = 7-bit text)
		  // (3 = directory, 4 = volume label)
  char res1;      //   reserved
  ftime modified; //   date time modified
  unsigned long comp_size; // compressed size
  unsigned long orig_size; // original size (this will be different for text mode compression)
  unsigned origCRC;   // original file's CRC
  unsigned fspos;     //  filespec position in filename
  unsigned access_mode; // file access mode
  unsigned host_data;   // (currently not used)
 };
   /**
       ?   extra data
	   4 bytes for extended file starting position when used
	   (this is present when EXTFILE_FLAG is set)

       ?   filename (null-terminated string)
       ?   comment  (null-terminated string)

       4   basic header CRC

       2   1st extended header size (0 if none)
       ?   1st extended header (currently not used)
       4   1st extended header's CRC (not present when 0 extended header size)

       ...

       ?   compressed file
    **/
/*****************************************************/

int arjview ( char afnev[], int (*fw)(FileRType* rr) )
{
 //int i,c,e;

 int af,b,px,py;
 long fpos,mpos,afp;
 struct arj_main_head arjmainhd;
 struct arj_local_head arjhd;
 char buf[255];

 mpos=fls.size;
 if ((af=open(afnev,O_BINARY|O_RDONLY))==-1)
  return( -1 );

 read( af,&arjmainhd,sizeof(arjmainhd) );
 if (arjmainhd.headerid != 60000l)
  return( -1 );
 lseek( af,2+arjmainhd.headsize+2+6,SEEK_SET );
 fpos=tell(af);
 m_shide();
 cprintf("%s ARJ : %s - ",xmsg[ M_TOMOR_FILE ],afnev);
 m_sshow();
 px=wherex(); py=wherey();
 do
  {
   //buf[12]='\0';
   memset( buf,0,254 );
   read( af,&arjhd,sizeof(arjhd) );
   if (arjhd.headerid != 60000l)
    continue;
   if ( arjhd.headsize==0 )
    break;
   if (arjhd.arj_flags & 0x08)
    lseek( af , 4 , SEEK_CUR );
   lseek( af , 2 , SEEK_CUR );
   b=arjhd.headsize-sizeof(arjhd); //-(arjhd.arj_flags & 0x08)?4:0;
   //b-=2;
   if (arjhd.arj_flags & 0x08)
    b-=4;

   read( af,buf,b );

   strcpy( fls.name , expand(buf));
   fls.time = arjhd.modified;
   fls.size = -2;
   fls.nidx = 0; //!
   fw(&fls);

   //printf("%12s - Orig: %9ld  Comp: %9ld \n",buf,arjhd.orig_size,arjhd.comp_size);

   m_shide();
   gotoxy(px,py); cprintf("%.0f%%",((float)fpos/(float)mpos)*100 );
   m_sshow();
   afp=tell(af);

   lseek( af,(fpos + 2+arjhd.headsize+2+6+arjhd.comp_size)-afp,SEEK_CUR );
   fpos=tell(af);
  }
 while ( !eof(af) );

 m_shide();
 gotoxy(px,py); cprintf("100%%  \n\r");
 m_sshow();
 close( af );

 return( 0 );
}

/******************************/
struct arc_head
	{
	char signature;
	char c_method;
	char name[MAXFILE+MAXEXT-1];
	unsigned long c_size;
	unsigned short date;
	unsigned short time;
	unsigned short crc16;
	unsigned long uc_size;
	};

struct zip_head
	{
	long signature;
	int vextract;
	int gpflag;
	int c_method;
	unsigned short time;
	unsigned short date;
	unsigned long crc32;
	unsigned long c_size;
	unsigned long uc_size;
	int l_filename;
	int l_extra;
	};


int arcview( char *name, int (*fw)(FileRType* rr) )
{
 FILE *fptr;
 arc_head archd;
 int px,py;
 long mpos,lng;

 mpos=fls.size;
 if((fptr=fopen(name,"rb"))==NULL)
  {
   return( -1 );
  }
 m_shide();
 cprintf("%s ARC : %s - ",xmsg[ M_TOMOR_FILE ],name);
 m_sshow();
 px=wherex(); py=wherey();
 for(;;)
  {
   if(fread(&archd,sizeof(archd),1,fptr)!=1)
    {
     break;
    }
   if((archd.signature!='\x1a')||((signed int)archd.c_method<'\0')||(archd.c_method>'\x09')||(memchr(archd.name,'\0',13)==NULL))
    {
     break;
    }

   //found=1;
   //found_n++;
   //printf("\n %s ",archd.name);
   //printf("%*c",14-strlen(archd.name),'\x20');
   //printf("(%s)",name);
   //printf("%*c",14-strlen(name),'\x20');
   //printf_info(archd.uc_size,archd.date,archd.time);

   strcpy( fls.name , expand(archd.name));
   lng  = archd.time | ((long)archd.date << 16);
   memcpy( &fls.time , &lng ,4 );
   fls.size = -2;
   fls.nidx = 0; //!
   fw( &fls );
   //incdisplayfilenum();

   //cprintf(".");
   m_shide();
   gotoxy(px,py); cprintf("%.0f%%",((float)ftell(fptr)/(float)mpos)*100 );
   m_sshow();

   fseek(fptr,archd.c_size,SEEK_CUR);
  }
 fclose(fptr);
 m_shide();
 gotoxy(px,py); cprintf("100%%  \n\r");
 m_sshow();
 return( 0 );
}

int zipview( char *name, int (*fw)(FileRType* rr) )
{
 FILE *fptr;
 zip_head ziphd;
 static char zipname[MAXFILE+MAXEXT-1];
 static int zindex;
 static char nindex;
 int px,py;
 long mpos,lng;

 mpos=fls.size;
 if((fptr=fopen(name,"rb"))==NULL)
  {
   return( -1 );
  }
 m_shide();
 cprintf("%s ZIP : %s - ",xmsg[ M_TOMOR_FILE ],name);
 m_sshow();
 px=wherex(); py=wherey();
 for(;;)
  {
   if(fread(&ziphd,sizeof(ziphd),1,fptr)!=1)
    {
     break;
    }
   if(ziphd.signature!=0x04034b50L)
    {
     break;
    }
   nindex=0;
   for(zindex=0;zindex<ziphd.l_filename;zindex++)
    {
     if(nindex==sizeof(zipname))
      {
       break;
      }
     if((zipname[nindex++]=fgetc(fptr))=='/')
      {
       nindex=0;
      }
    }
   zipname[nindex]='\0';
   for(zindex=0;zindex<ziphd.l_extra;zindex++)
    {
     fgetc(fptr);	// throw away extra field *
    }

   //found=1;
   //found_n++;
   //printf("\n  %s",zipname);
   //printf("%*c",14-strlen(zipname),'\x20');
   //printf("(%s)",name);
   //printf("%*c",14-strlen(name),'\x20');
   //printf_info(ziphd.uc_size,ziphd.date,ziphd.time);

   if (zipname[0]!='\0')
    {
     strcpy( fls.name , expand(zipname));
     lng  = ziphd.time | ((long)ziphd.date << 16);
     memcpy( &fls.time , &lng ,4 );
     fls.size = -2;
     fls.nidx = 0; //!

     //ff.newcomm(&fls,"Ez a ZIP-ben van..."); //----------------
     fw( &fls );
    }

   //cprintf(".");
   m_shide();
   gotoxy(px,py); cprintf("%.0f%%",((float)ftell(fptr)/(float)mpos)*100 );
   m_sshow();

   fseek(fptr,ziphd.c_size,SEEK_CUR);
  }
 fclose(fptr);
 m_shide();
 gotoxy(px,py); cprintf("100%%  \n\r");
 m_sshow();
 return( 0 );
}


void keres( char pp[], int (*fw)(FileRType* rr) )
{
 char tt[256];
 char did[12];
 struct ffblk *di;
 int h;
 int done,done2;
 //char ts[80];

 di = new ffblk;

 done2 = 0;
 // lseek(filesfile , filelength(filesfile) , SEEK_SET);
 done = findfirst( pp , /* & */di , 0x3F );

 while ( !done && !done2)
  {
   while ( ((di->ff_name[0]=='.') || (di->ff_attrib != 0x10)) && (!done) )
      {
       if ( di->ff_name[0]!='.' )
	if (!(di->ff_attrib & 8))
	 {
	  //**********************
	  //*** File beolvasas ***
	  //**********************

	  strcpy( fls.name , expand(di->ff_name));
	  fls.size = di->ff_fsize;
	  memcpy( &(fls.time) , &(di->ff_ftime) , 4 );
	  fls.nidx = 0; //!

	  if ( (comment_musics)&&(strncmp(&fls.name[9],"MOD",3)==0) ) // texts *****
	   {
	    char mtitle[20];
	    int fo;
	    strcpy (tt , pp);
	    tt[strlen(tt)-3] = '\0';
	    strcat(tt,fls.name);
	    if ((fo=open(tt,O_RDONLY|O_BINARY))>0)
	     {
	      read(fo,mtitle,20);
	      m_shide();
	      cprintf("%s : %s - '%s'\r\n",xmsg[ M_MOD_FILE ],fls.name,mtitle);
	      m_sshow();
	      close(fo);
	      mtitle[20]='\0';
	      ff.newcomm(&fls,mtitle);
	     }
	   }

	  if ((comment_musics)&&(strncmp(&fls.name[9],"S3M",3)==0) ) // texts ****
	   {
	    char mtitle[20];
	    int fo;
	    strcpy (tt , pp);
	    tt[strlen(tt)-3] = '\0';
	    strcat(tt,fls.name);
	    if ((fo=open(tt,O_RDONLY|O_BINARY))>0)
	     {
	      read(fo,mtitle,20);
	      m_shide();
	      cprintf("%s : %s - '%s'\r\n",xmsg[ M_S3M_FILE ],fls.name,mtitle);
	      m_sshow();
	      close(fo);
	      mtitle[20]='\0';
	      ff.newcomm(&fls,mtitle);
	     }
	   }


	  fw( &fls );
	  //incdisplayfilenum();

	  /*
	  if ( strncmp(&fls.name[9],"ARC",3)==0 )
	   {
	    strcpy (tt , pp);
	    tt[strlen(tt)-3] = '\0';
	    strcat(tt,fls.name);
	    arcview(tt, fwfunc);
	   }
	  else*/
           if ( (archive_view)&&(uc2_usage)&&(strncmp(&fls.name[9],"UC2",3)==0) )
	    {
	     strcpy (tt , pp);
	     tt[strlen(tt)-3] = '\0';
	     strcat(tt,fls.name);
	     uc2_view(tt, fwfunc,"templist.tmp"); //***
	    }
	   else
	    if ( (archive_view)&&(strncmp(&fls.name[9],"ARC",3)==0) )
	     {
	      strcpy (tt , pp);
	      tt[strlen(tt)-3] = '\0';
	      strcat(tt,fls.name);
	      arcview(tt, fwfunc);
	     }
	    else
	     if ((archive_view)&&(strncmp(&fls.name[9],"ZIP",3)==0))
	      {
	       strcpy (tt , pp);
	       tt[strlen(tt)-3] = '\0';
	       strcat(tt,fls.name);
	       zipview(tt, fwfunc);
	      }
	     else
	      if ((archive_view)&&(strncmp(&fls.name[9],"ARJ",3)==0))
	       {
	        strcpy (tt , pp);
	        tt[strlen(tt)-3] = '\0';
	        strcat(tt,fls.name);
	        arjview(tt, fwfunc);
	       }
	      else
	       if ((archive_view)&&( fls.name[9]=='A' &&
		    ('0'<=fls.name[10] && fls.name[10]<='9') &&
		    ('0'<=fls.name[11] && fls.name[11]<='9') ))
	        {
		 strcpy (tt , pp);
		 tt[strlen(tt)-3] = '\0';
		 strcat(tt,fls.name);
		 arjview(tt, fwfunc);
	        }

	  //write(FilesFile,Files);
	  /*
	  if (pos('NUMMER.',di->name)<>0) OR (pos('NUMBER.',di->name)<>0) then
	   begin
	    val(copy(di->name,8,3),lemezszam2,h);
	    if h<>0 then
	     lemezszam2:=0;
	   end;
	  */
	 }
	else
	 {
	  if (di->ff_name[8]=='.') di->ff_name[8]=' ';
	  m_shide();
	  cprintf("%s: %s\n\r",xmsg[ M_LEMEZCIMKE ],di->ff_name);
	  m_sshow();
	  // volume:=di->name;
	 }
       done = findnext(/* & */di);
      } // while

     if ((di->ff_attrib==0x10) && (!done))
      {
       strcpy (did , di->ff_name );
       strcpy (tt , pp);
       tt[strlen(tt)-3] = '\0';
       strcat ( tt , did );
       m_shide();
       cprintf("%s: %s\n\r",xmsg[ M_KONYVTAR ],tt);
       m_sshow();
       strcat ( tt , "\\*.*");
       keres(tt, fwfunc);
      }

     if ( (strstr(tt,did)!=NULL) && (strstr(pp,did)==NULL) )
	{
	 done2 = findfirst(pp, di ,0x10 );
	 while ( strcmp(di->ff_name,did) && (!done2) )
	  {
	   done2=findnext(di);
	  }
	 did[0]='\0';
	}
     done2=findnext(di);
  }
 delete di;
}


void filenezes( long kezd , long veg )  // !!! REVISE !!!
{
 int i,cn,key,key2;
 TitleRType title;
 FileRType files;
 long c,d,e,f,lst=-10;
 char bf[20];
 FileRType *ft;
 char *comp[100];
 int lf=0;
 long ccnt=-1;

 title.kezd=kezd;
 title.veg=veg;
 //textattr(15);

 if ( kezd > veg)
  {
   //nyit(18,8-3,46,16,xmsg[ M_LEM_FILEOK ] ,ablakszin[3],ablakszin[4],ablakszin[5],milyenkeret );
   xnyit(XW_FILENEZES);
   m_shide();
   cprintf("%s\n\r",xmsg[ M_URES_LEMEZ ]);
   m_sshow();
   elnyelo();
   m_shide();
   cprintf("%s",xmsg[M_PRESS_ANY_KEY]);
   m_sshow;
   getch();
   sound1();
   csuk();
   return;
  }

 ff.setpos( kezd );
 c = kezd-1;

 int dbg;

 if (ff.eof())
  {
   cprintf("EOF ERROR !!!\n\r");
   cprintf("(Might be error with 'files' file)\n\r");
   getch();
   csuk();
   //csuk();
   return;
  }

 if (( veg - kezd)+10 > (coreleft()/sizeof(FileRType)) )
  {
   //= Megjelents , ha nincs elg mem ! =//
   //if (DEMOVER)
   // nyit(18,8-3,46,16,xmsg[ M_LEM_FILEOK ] ,ablakszin[3],ablakszin[4],ablakszin[5], milyenkeret );
   xnyit(XW_FILENEZES);
   //else
   // nyit(18,8-3,46,16,xmsg[ M_LEM_FILEOK ] ,ablakszin[3],ablakszin[4],ablakszin[5], milyenkeret );
   c=0;
   do
    {
     c++;
     ff.read(&files);
     m_shide();
     if (files.size==-2)
      cprintf("%s     [Comp] %04d/%02d/%02d\n\r",files.name,
	 files.time.ft_year+1980,files.time.ft_month,files.time.ft_day );
     else
      cprintf("%s  %9ld %04d/%02d/%02d\n\r",files.name,files.size,
	 files.time.ft_year+1980,files.time.ft_month,files.time.ft_day );
     m_sshow();

     if ( c % 14==0 && (c!=0) )
      {
       m_shide();
       cprintf("%s",xmsg[M_PRESS_ANY_KEY]);
       m_sshow();
       while ( !left_button_pressed() && !kbhit() && !right_button_pressed() ) ;
       if ( right_button_pressed() )
	break;
       if ( kbhit() )
	{
	 if ( getch()==27 )
	  break;
	}
       m_shide();
       clrscr();
       m_sshow();
      }
    }
   while (! ( ((dbg)=ff.eof()) || ( c>=title.veg ) ));
   if ( c % 14 != 0 )
    {
     m_shide();
     cprintf("%s",xmsg[M_PRESS_ANY_KEY]);
     while ( !left_button_pressed() && !kbhit() ) ;
     if ( kbhit() )
      getch();
     m_sshow();
    }
  }
 else
  {
   ft=(FileRType *)calloc( veg - kezd+3,sizeof(FileRType));
   d=-1;
   //ff.setpos(kezd);
   do
    {
     c++;
     ff.read(&(ft[++d]));
     if (ft[d].size==-2)
      {
       // !!! Ha n>100 , ell. !!!

       if ( lf==0 )
	{
	 lf=1;
	 ccnt++;
	 comp[ccnt]=(char *)malloc(13);
	 strcpy( comp[ccnt],(ft[d-1].name) );
	 ft[d].extra=ccnt;
	}
       else
	{
	 ft[d].extra=ccnt;
	}
      }
     else
      {
       lf=0;
      }
    }
   while (! ( (dbg=ff.eof()) || ( c>=title.veg ) ));
   //           ^- a dbg nemtom, hogy miert kell, de ha nincs, akkor rossz!

   qsort((void *)ft, d+1, sizeof(ft[0]), fsort);

   //textattr(15);
   //if (DEMOVER)
   // nyit(18,8-3,46,16,xmsg[ M_LEM_FILEOK ] ,ablakszin[3],ablakszin[4],ablakszin[5], milyenkeret );
   //else
   // nyit(18,8-3,46,16,xmsg[ M_LEM_FILEOK ] ,ablakszin[3],ablakszin[4],ablakszin[5], milyenkeret );
   xnyit(XW_FILENEZES);
   e=-1;
   do
    {
     cn=0;
     f=e;
     if (lst != f)
      {
       m_shide();
       clrscr();
       m_sshow();
       do
	{
	 f++;  cn++;
	 files=ft[f];
	 if (cn!=1) cprintf("\n\r");
	 m_shide();
	 if (files.size==-2)
	  cprintf("%s  [%12s] %04d/%02d/%02d",files.name,comp[files.extra],
	      files.time.ft_year+1980,files.time.ft_month,files.time.ft_day );
	 else
	  cprintf("%s    %12ld %04d/%02d/%02d",files.name,files.size,
	      files.time.ft_year+1980,files.time.ft_month,files.time.ft_day );
	 m_sshow();
	}
       while ( f<d && cn<=14 );
      }
     lst=e;

     key = 255;
     while ( !left_button_pressed() && !kbhit() && !right_button_pressed() ) ;
     if ( right_button_pressed() )
      break;
     if ( kbhit() )
      key=getch();
     if (key==0)
      {
       key2=getch();
       switch (key2)
	{
	 case 72:
	 case 73:if (e<13) break;
		 e-=15;
		 break;
	 case 80:
	 case 81:if (e>d-16) break;
		 e+=15;
		 break;
	}
      }
    }
   while ( !(key==27 || key==13) );

   free(ft);
   for (c=0 ; c<=ccnt ; c++ )
    free(comp[c]);
  }
 sound1();
 csuk();
}

/*---------------------------------------------------------------*/

void save_comments(long kezd,long veg,char *fname)
{
 FILE *fe;
 char bf5[60],bfx[200];
 FileRType rp;
 bf5[0]=0;
 long c;

 ff.setpos(kezd);

 if (!(fe=fopen(fname,"wt")))
  return;     // **** error should be told to user ! ***

 for (c=0;c<(veg-kezd);c++)
  {
   ff.read(&rp);
   strcpy(bfx,rp.name);
   if (rp.nidx!=0)
    {
     strcat(bfx," ");
     ff.commread(rp.nidx,bf5);
     strcat(bfx,bf5);
    }
   strcat(bfx,"\n");
   fputs(bfx,fe);
  }

 fclose(fe);
}

void apply_comments(long kezd,long veg,char *fname)
{
 FILE *fe;
 char bf3[50],bf4[50],bf5[60],bfx[200];
 int cc;
 FileRType *rp;
 FileRType tr;
 bf5[0]=0;
 int nx=0;
 long c,hely;

 if (!(fe=fopen(fname,"rt")))
  return;     // **** error should be told to user ! ***

 while (!feof(fe))
  {
   bfx[0]='\0';
   fgets(bfx,200,fe);
   if (bfx[strlen(bfx)-1]=='\n')
    bfx[strlen(bfx)-1]='\0';

   if (bfx[0]=='\0')
    continue;

   nx++;
   if (nx%10==9)
    cprintf(".");

   strncpy(bf5,bfx,12); bf5[12]=0;
   strcpy(bf4,expand(bf5));

   //cprintf("\n\r%s",bf4);

   strupr(bf4);
   /*
   cc=0;
   for (c=0;c<nelem;c++)
    if (stricmp(bf4,ft[c].name)==0)
     { cc=1; break; }

   if (cc==0)
    continue;

   bf3[0]='\0';
   if (ft[c].nidx!=0)
    ff.commread(ft[c].nidx,bf3);
   */

   tr.nidx=0;
   cc=0;
   ff.setpos(kezd);
   for (c=0;c<(veg-kezd);c++)
    {
     ff.read(&tr);
     if (stricmp(bf4,tr.name)==0)
      { cc=1; hely=kezd+c; break; }
    }

   if (cc==0)
    continue;

   if (tr.nidx==0)
    {
     ff.setpos(hely);
     ff.newcomm(&tr,&bfx[13]);
     ff.write(&tr);
    }
   else
    {
     ff.commwrite(tr.nidx,&bfx[13]);
    }
   //lst++;
  }
 fclose(fe);
 cprintf("\r\n");
}
