/*********************************************************************/
/*                                                                   */
/*  Command line:                                                    */
/*   BIN2ASM <source file> <dest file>                               */
/*                                                                   */
/*********************************************************************/

#include <fcntl.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <stdio.h>
#include <stddef.h>
#include <malloc.h>

#define maxline  76

unsigned char *buffer;
int s_handle,d_handle;
char errmsg1[] = "File read error.";
char errmsg2[] = "File write error.";
char linebuffer[maxline+6] = " DB ";
char divider[] = "\r\n;--------------------------------------------------\r\n\r\n";

main(argc,argv)
int argc;
char **argv;

{
unsigned short i,fblock,byte_counter;
long s_len;
short linelength;
char sbuf[8];

if (argc != 3)
	{
	puts("\nCommand line:");
	puts(" BIN2ASM <source file> <dest file>\n");
	exit(1);
	}

argv++;
s_handle = open(*argv,O_BINARY|O_RDONLY);
if (s_handle == -1)
	{
	puts(errmsg1);
	exit(1);
	}
argv++;
d_handle = open(*argv,O_BINARY|O_RDWR|O_CREAT|O_TRUNC,S_IREAD|S_IWRITE);
if (d_handle == -1)
	{
	close(s_handle);
	puts(errmsg2);
	exit(1);
	}

buffer = (unsigned char *)malloc(32768);
if (buffer == NULL)
	{
	puts("Unable to allocate memory.");
	close(s_handle);
	close(d_handle);
	exit(1);
	}

s_len = filelength(s_handle);
byte_counter = 0;

while (s_len > 0L)
	{
	if (s_len >= 32768L)
		fblock = 32768;
	else
		fblock = (unsigned short)s_len;
	
	if (read(s_handle,buffer,fblock) != fblock)
		{
		close(s_handle);
		close(d_handle);
		free(buffer);
		puts(errmsg1);
		exit(1);
		}

	s_len -= (long)fblock;
	byte_counter += fblock;

        for (i=0 ; i<fblock ; i++)
		{
		itoa((int)buffer[i],sbuf,10);
		if (strlen(linebuffer) > 4)
			strcat(linebuffer,",");
		strcat(linebuffer,sbuf);
		if (strlen(linebuffer) >= maxline)
			{
			strcat(linebuffer,"\r\n");
			linelength = strlen(linebuffer);
			if (write(d_handle,linebuffer,linelength) != linelength)
				{
				close(s_handle);
				close(d_handle);
				free(buffer);
				puts(errmsg2);
				exit(1);
				}
			linebuffer[4] = 0;
			}
		}

	if (byte_counter == 0)
		{
		if (strlen(linebuffer) > 4)
			{
			strcat(linebuffer,"\r\n");
			linelength = strlen(linebuffer);
			if (write(d_handle,linebuffer,linelength) != linelength)
				{
				close(s_handle);
				close(d_handle);
				free(buffer);
				puts(errmsg2);
				exit(1);
				}
			linebuffer[4] = 0;
			}

		if (write(d_handle,divider,strlen(divider)) != strlen(divider))
			{
			close(s_handle);
			close(d_handle);
			free(buffer);
			puts(errmsg2);
			exit(1);
			}
		}
	}

if (strlen(linebuffer) > 4)
	{
	strcat(linebuffer,"\r\n");
	linelength = strlen(linebuffer);
	if (write(d_handle,linebuffer,linelength) != linelength)
		{
		close(s_handle);
		close(d_handle);
		free(buffer);
		puts(errmsg2);
		exit(1);
		}
	}

puts("File conversion successful.");
close(s_handle);
close(d_handle);
free(buffer);
exit(0);
}
