#include <graphics.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <mem.h>
#include <dos.h>
#include <string.h>

#define TRUE	1			/* Define some handy constants	*/
#define FALSE	0			/* Define some handy constants	*/
#define PI	3.14159 		/* Define a value for PI	*/

#define LEFT    75
#define RIGHT   77
#define UP      72
#define DOWN    80

#define ESC     27
#define ENTER   13
#define SPACE   32

struct PTS {
  int x, y;
};	/* Structure to hold vertex points	*/

double AspectRatio;
int    MaxX,MaxY;
int    GraphDriver;		/* The Graphics device driver		*/
int    GraphMode;		/* The Graphics mode value		*/
int    MaxColors;		/* The maximum # of colors available	*/
int    ErrorCode;		/* Reports any graphics errors		*/
int    GrMode;

int     xcenter, ycenter;
int     radius;
double  angle,step;
int     maxpoint;
struct {
       int from, to;
       }
       atlok[100];
int atlonum = 0;



void    Initialize(void);
struct PTS SPoint ( int number );
void    SokSzogInit ( int pointno );
void    SokSzogRajz ( void );
void    Jatek ( void );

void main ( void )
{
 char string[80];
 int pnt,key;

 Initialize();
 while (1)
  {
  restorecrtmode();
  printf("Cscsok szma : ");
  gets(string);
  pnt = atoi(string);
  setgraphmode(GrMode);
  SokSzogInit( pnt );
  SokSzogRajz();
  Jatek();
  key = getch();
  }
}

/********************************************************************/
void GrInit( void )
{
 initgraph( &GraphDriver, &GraphMode, "" );
 ErrorCode = graphresult();		/* Read result of initialization*/
 if( ErrorCode != grOk )
  {	                        	/* Error occured during init	*/
   printf(" Graphics System Error: %s\n", grapherrormsg( ErrorCode ) );
   exit( 1 );
  }
 GrMode = getgraphmode();
}

void Initialize(void)
{
  int xasp, yasp;			/* Used to read the aspect ratio*/

  GraphDriver = DETECT; 		/* Request auto-detection	*/
  GrInit();

  MaxColors = getmaxcolor() + 1;	/* Read maximum number of colors*/

  MaxX = getmaxx();
  MaxY = getmaxy();			/* Read size of screen		*/

  getaspectratio( &xasp, &yasp );	/* read the hardware aspect	*/
  AspectRatio = (double)xasp / (double)yasp; /* Get correction factor	*/
}

void SokSzogInit ( int pointno )
{
  struct viewporttype vp;
  struct pointtype point;
  int i, j, h, w;


  getviewsettings( &vp );
  h = vp.bottom - vp.top;
  w = vp.right	- vp.left;

  xcenter = w / 2;			/* Determine the center of circle */
  ycenter = h / 2;
  radius  = (h - 30) / (AspectRatio * 2);
  step	  = 360 / (double)pointno ;  	/* Determine # of increments	*/
  maxpoint = pointno;
}

struct PTS SPoint ( int number )
/*********************************************************
 Sokszog pontjat adja vissza : 0 < number <= maxpoint
**********************************************************/
{
 struct PTS p2;
 double aa,rads;

 aa = (double)(step * (number - 1)) ;
 rads = (double)(aa * PI / 180.0) ;
 p2.x = xcenter + (int)( cos(rads) * radius );
 p2.y = ycenter - (int)( sin(rads) * radius * AspectRatio );

 return ( p2 );
}

void SokSzogRajz ( void )
{
  struct PTS point,point2;
  int i;

  setcolor( 1 );

  for( i=1 ; i<=maxpoint ; i++ )
   {
    if ( i == 1 )
     point2 = SPoint(maxpoint);
    else
     point2 = point;

    point = SPoint ( i );

    setcolor(1);
    line( point.x,point.y , point2.x,point2.y );
    circle( point2.x,point2.y,4 );

    setcolor(0);
    putpixel(point2.x,point2.y,0);
    circle(point2.x,point2.y,1);
    circle(point2.x,point2.y,2);
    circle(point2.x,point2.y,3);
  }
  setcolor(0);
  putpixel(point.x,point.y,0);
  circle(point.x,point.y,1);
  circle(point.x,point.y,2);
  circle(point.x,point.y,3);

  /*
  circle( xcenter, ycenter, radius );

  for( i=0 ; i<MAXPTS ; ++i ){
    for( j=i ; j<MAXPTS ; ++j ){
      moveto(points[i].x, points[i].y);
      lineto(points[j].x, points[j].y);
   }
  }
 */

}

void SPut ( int no, int col )
{
 struct PTS point;

 point = SPoint( no );
 setcolor( col );
 putpixel(point.x,point.y,0);
 circle(point.x,point.y,1);
 circle(point.x,point.y,2);
 circle(point.x,point.y,3);
}

int kozott( int sz1,int sz2,int x )
{
 if ( (x == sz1) || (x == sz2) )
   return( 0 );

 if (sz1 == 1)
  return( (x<sz2) ? 1 : (-1) );
 if (sz1 == maxpoint)
  return( (x>sz2) ? (-1) : 1 );

 if (sz2 == 1)
  return( (x<sz1) ? (-1) : 1 );
 if (sz2 == maxpoint)
  return( (x>sz1) ? 1 : (-1) );

 if (sz1<sz2)
  return( ((sz1<x) && (x<sz2)) ? 1 : (-1) );
 if (sz1>sz2)
  return( ((sz2<x) && (x<sz1)) ? (-1) : 1 );

 return( 0 );
}

int metszes ( int nod1a,int nod1b, int nod2a,int nod2b )
{
 if ( !(kozott( nod1a,nod1b, nod2a) == (-1)*kozott( nod1a,nod1b, nod2b)) )
  return( FALSE );

 return(TRUE);
}

int atlometszes( int f, int t)
{
 int c;

 if (atlonum==0)
  return( FALSE );

 for (c=1 ; c <= atlonum; c++)
  if (metszes(atlok[c].from,atlok[c].to,f,t) )
   return( TRUE );
 return( FALSE );
}
/****-----**************************************************************/
void Jatek ( void )
/****-----**************************************************************
  A tenyleges jatek
***********************************************************************/
{
 int esc = FALSE;
 int pos = 1;
 int key,key2;
 int stayin = TRUE;
 int vatlo=FALSE;
 int d,e;

 int from = 0;
 int xcsucs[3] = { 0,0,0 };
 int atlom[200];
 struct PTS po1,po2;
 char ltxt[100];

 memset( atlom, 0,sizeof(atlom) );

 setcolor( GREEN );
 strcpy( ltxt,"Select first point" );
 outtextxy( 20,20, ltxt);

 SPut( pos, 1);
 while (1)
  {
   key = getch();
   SPut( pos, 0);

   switch ( key )
     {
     case 0: /* Control key */
            {
            key2 = getch();
            switch( key2 )
             {
             case RIGHT :
                    pos = (pos>1) ? (pos-1) : maxpoint;
                    break;
             case  LEFT :
                    pos = (pos<maxpoint) ? (pos+1) : 1;
                    break;
             }
            }
            break;
     case SPACE :
     case ENTER : /* SPACE or ENTER */
              sound(440);
              delay(50);
              nosound();
              e = 0;
              for ( d=1 ; d<=maxpoint ; d++)
               {
               if ( !atlometszes(pos,d) && (d != pos) )
                e++;
               }
              sound(440);
              delay(50);
              nosound();

              setcolor( 0 );
              outtextxy( 20,20 , ltxt );

              if ( e<=2 )
               {
               setcolor( RED );
               strcpy( ltxt, "Select again !" );
               outtextxy( 20,20 , ltxt );
               break;
               }

              setcolor( GREEN );
              strcpy( ltxt , "Select second point");
              outtextxy( 20,20 , ltxt );

              from = pos;
              xcsucs[0] = from;
              xcsucs[1] = (from>1) ? (from-1) : maxpoint;
              xcsucs[2] = (from<maxpoint) ? (from+1) : 1;

              po1 = SPoint( from );

              setwritemode( 1 );

              SPut(pos , 1);
              stayin = TRUE;

              esc = FALSE;
              vatlo = FALSE;
              while (stayin)
               {
                key = getch();

                SPut(pos , 0);
                if (vatlo)
                 {
                 setcolor( 1 );
                 line(po1.x,po1.y , po2.x,po2.y);
                 vatlo = FALSE;
                 }

                switch ( key )
                 {
                  case 0: /* Control key */
                         {
                         key2 = getch();
                         switch( key2 )
                          {
                          case RIGHT :
                                 pos = (pos>1) ? (pos-1) : maxpoint;
                                 while (pos==xcsucs[0])
                                        /****
                                        ||
                                        pos==xcsucs[1] ||
                                        pos==xcsucs[2])
                                        ****/
                                  pos = (pos>1) ? (pos-1) : maxpoint;
                                 break;
                          case  LEFT :
                                 pos = (pos<maxpoint) ? (pos+1) : 1;
                                 while (pos==xcsucs[0] )
                                       /***
                                        ||
                                        pos==xcsucs[1] ||
                                        pos==xcsucs[2])
                                       ***/
                                  pos = (pos<maxpoint) ? (pos+1) : 1;
                                 break;
                          }
                         }
                         break;
                  case SPACE :
                  case ENTER :
                         if (atlometszes(from,pos) || pos==xcsucs[0] ||
                                                      pos==xcsucs[1] ||
                                                      pos==xcsucs[2] )
                           break;
                         stayin = FALSE;

                         setcolor( 0 );
                         outtextxy( 20,20 , ltxt );

                         break;
                  case  ESC  :
                         stayin = FALSE;
                         esc = TRUE;
                         break;
                  }

                 po2 = SPoint(pos);
                 if (!atlometszes(from,pos) )
                  {
                  setcolor( 1 );
                  line(po1.x,po1.y , po2.x,po2.y);
                  vatlo = TRUE;
                  }
                 SPut(pos , 1);
                }
              if (esc)
               {
               setcolor( GREEN );
               strcpy(ltxt , "Select first point");
               outtextxy( 20,20 , ltxt );
               break;
               }

              setwritemode( 0 );
              SPut(pos , 0);
              po2 = SPoint(pos);
              setcolor( RED );
              line(po1.x,po1.y , po2.x,po2.y);

              atlonum++;
              atlok[atlonum].from = from;
              atlok[atlonum].to = pos;

              from = 0;
              setcolor( GREEN );
              strcpy( ltxt , "Select first point");
              outtextxy( 20,20 , ltxt );
              break; /* From case ENTER */
     } /* switch ( key ) */
   SPut( pos, 1);
  }
}
/* * *   E N D   * * */