.286

code		segment	byte public
		assume	cs:code, ds:code

		org	100h

start:
		push	cs
		pop	ds
		cld				; Clear direction
		mov	ax,0013h
		int	10h

		int	1Ah			; Init random seed
		mov	word ptr ds:[400h],dx
;------------------------------------------------------------------------------
		push	cs
		pop	es
		mov	di,500h
		mov	cx,3			; R,G,B
palgen_loop:
		push	cx
		mov	bx,0FE01h
		call	random
		mov	bp,ax
		sub	bx,bx
		sub	si,si
jmp_2:
		mov	cl,2Bh			; '+'
		mov	ax,bx
		cwd				; Word to double word
		idiv	cx			; ax,dx rem=dx:ax/reg
		sub	ax,0B4h
		sub	si,ax
		mov	ax,si
		cwd				; Word to double word
		idiv	cx			; ax,dx rem=dx:ax/reg
		add	bx,ax
		dec	bp
		jns	jmp_1			; Jump if not sign
		mov	al,bh
		stosb				; Store al to es:[di]
		inc	di
		inc	di
jmp_1:
		cmp	bp,0FF00h
		jg	jmp_2			; Jump if >
		sub	di,2FFh
		pop	cx
		loop	palgen_loop		; Loop if cx > 0

;-----------------------------------------------------------------------------

		mov	dx,3C8h			; Set palette
		mov	al,0
		out	dx,al			; port 3C8h, VGA pel address
		inc	dx
		mov	cx,300h
		mov	si,500h
		mov	di,800h
setpallop:
		lodsb				; String [si] to al
		stosb				; Store al to es:[di]
		out	dx,al			; port 3C9h, VGA pel data reg
		loop	setpallop		; Loop if cx > 0

;------------------------------------------------------------------------------

		push	0a000h
		pop	es
		mov	bx,0ff01h
		sub	si,si
		mov	di,offset putpixel
		mov	bp,offset random
		call	bp
		mov	cx,si
		mov	dx,si
		call	di
		call	bp
		mov	cx,319
		call	di
		call	bp
		mov	dx,199
		call	di
		push	dx			;199,319
		push	cx
		call	bp
		mov	cx,si
		call	di
		push	si			;0,0
		push	si
		call	plasma

;------------------------------------------------------------------------------
;		xor	bx,bx
scroll_lop:
		mov	dx,03dah
w1:
		in	al,dx
		test	al,8
		jz	w1
		sub	bx,3
		jns	over			; Jump if not sign
		mov	bx,768-3
over:
		mov	dl,0C8h
		mov	al,1
		out	dx,al			; port 3C8h, VGA pel address
		inc	dx
		lea	si,[bx+500h]		; Load effective addr
		mov	cx,768-3
		rep	outsb

		mov	ah,01h			;Check for keypress
		int	16h
		je	scroll_lop

		sub	ah,ah			;End! - getch
		int	16h
		mov	ax,0003h		;80x25
		int	10h
		int	20h			;Bye!

;
;                              SUBROUTINE
;

plasma:
		enter	000ch,00h
		pusha
		mov	si,[bp+04h]		;si=(x1+x2)/2
		add	si,[bp+08h]
		shr	si,1
		mov	di,[bp+06h]		;di=(y1+y2)/2
		add	di,[bp+0ah]
		shr	di,1

		cmp	[bp+04h],si		;Already x1=si
		jl	notendr
		cmp	[bp+06h],di		;And y1=di
		jl	notendr
		jmp	endrecurse
	
notendr:
		mov	bx,offset getpixel
		mov	cx,[bp+4]		;(x1,y1)->[bp-6]
		mov	dx,[bp+6]
		call	bx
		mov	[bp-6],al
		mov	cx,[bp+8]		;(x2,y1)->[bp-8]
		call	bx
		mov	[bp-8],al
		mov	dx,[bp+0Ah]		;(x2,y2)->[bp-0c]
		call	bx
		mov	[bp-0Ch],al
		mov	cx,[bp+4]		;(x1,y2)->[bp-0ah]
		call	bx
		mov	[bp-0Ah],al

		mov	bl,[bp-6]		;8
		mov	bh,[bp-8]
		call	random
		mov	cx,si
		mov	dx,[bp+6]
		call	putpixel
		mov	bl,[bp-0Ah]		;2
		mov	bh,[bp-0Ch]
		call	random
		mov	dx,[bp+0Ah]
		call	putpixel
		mov	bl,[bp-6]		;5
		mov	bh,[bp-0Ch]
		call	random
		mov	dx,di
		call	putpixel
		mov	bl,[bp-6]		;4
		mov	bh,[bp-0Ah]
		call	random
		mov	cx,[bp+4]
		call	putpixel
		mov	bl,[bp-8]		;6
		mov	bh,[bp-0Ch]
		call	random
		mov	cx,[bp+8]
		call	putpixel

		push	word ptr [bp+0Ah]
		push	cx
		push	di
		push	si
		push	word ptr [bp+0Ah]
		push	si
		push	di
		push	word ptr [bp+4]
		push	di
		push	cx
		push	word ptr [bp+6]
		push	si
		push	di
		push	si
		push	word ptr [bp+6]
		push	word ptr [bp+4]

		mov	cx,4			; 4 quarters
recursivelop:
		call	plasma
		loop	recursivelop		; Loop if cx > 0
endrecurse:
		popa
		leave
		ret	0008h

;

putpixel:
		pusha
		imul	di,dx,320
		add	di,cx
		mov	ah,es:[di]
		or	ah,ah
		jne	marvan
		stosb
marvan:
		popa
		ret

;

getpixel:
		push	di
		imul	di,dx,320
		add	di,cx
		mov	al,es:[di]
		pop	di
		ret

;

random:
		push	bx
		push	cx
		sub	bh,bl
		jnc	nemnagyobb		; Jump if carry=0
		add	bl,bh
		neg	bh
nemnagyobb:
		inc	bh
		mov	cx,11h
		mov	ax,word ptr ds:[400h]
rndlop:
		shl	ax,1			; Shift w/zeros fill
		jnc	xorover			; Jump if carry=0
		xor	ax,2Dh
xorover:
		loop	rndlop			; Loop if cx > 0

		mov	word ptr ds:[400h],ax
		shr	ax,8
		div	bh
		shr	ax,8
		add	al,bl
		pop	cx
		pop	bx
		ret

code		ends
		end	start
