(******************************************************************************
*									      *
*	Prntyi Muzak ADEXE Driver v0.99a				      *
*	Algorythm developed by MacGyver					      *
*									      *
*	Copyright (c) 1996/97 (1 day) by Lightning Productions		      *
*									      *
*	Coded on a "Schneider 640K Personal Computer by Amstrad - PC 1640"    *
*									      *
*	Windows95 .DLL available soon... NOT!				      *
*									      *
******************************************************************************)

{$I-}

unit	adexe;

interface

uses	crt,dos;

const	version:string[5]='0.99a';		{ Driver version number }

function openexe(filename:string):boolean;	{ Open music file; F on error }
function playexe:boolean;			{ Play one note; F on error }
function gotoexe(recno:longint):boolean;
function getpos:longint;
function getnoteexe(recno:longint;var rp:shortint;var l:byte):boolean;
procedure closeexe;				{ Close current music file }

implementation

var	f:file;
	pitch:word;

function openexe(filename:string):boolean;
var	h1,h2:char;
begin
writeln('[MZ_Init] .exe file init');
openexe:=true;
assign(f,filename);
reset(f,1);
if ioresult<>0 then begin
	openexe:=false;
	exit;
	end;
blockread(f,h1,1);
blockread(f,h2,1);
if not (((h1='M')and(h2='Z')) or ((h1='Z')and(h2='M'))) then begin
	openexe:=false;
	exit;
	end;
writeln('[AD_Init] ADEXE driver init');
pitch:=880;
end;

function playexe:boolean;
var	pitch_change:shortint;
	duration:byte;
begin
playexe:=true;
blockread(f,pitch_change,1);
blockread(f,duration,1);
if ioresult<>0 then begin
	playexe:=false;
	exit;
	end;
pitch:=pitch+pitch_change*3;
sound(pitch);
delay(duration*10);
end;

function gotoexe(recno:longint):boolean;
begin
seek(f,2+recno*2);
if ioresult<>0 then gotoexe:=false else gotoexe:=true;
end;

function getpos:longint;
begin
getpos:=(filepos(f)-2)div 2;
end;

function getnoteexe(recno:longint;var rp:shortint;var l:byte):boolean;
var	tempomat:longint;
begin
tempomat:=filepos(f);
seek(f,2+recno*2);
blockread(f,rp,1);
blockread(f,l,1);
seek(f,tempomat);
end;

procedure closeexe;
begin
writeln('[AD_Deity] safely unloading ADEXE');
close(f);
end;

end.
