unit usm;

interface

uses use32;

const TimerSpeed = 1193180;
const MAX_PLCHANNELS = 32;

type
  PUSM = ^TUSM;
  TUSM = packed record
    Id: array[1..4] of Char;
    Version: SmallWord;
    Name: array[1..32] of Char;
    Flags,Tracker,Channels,Patterns,Samples,Instruments: SmallWord;
    SongLength,Restart: SmallWord;
    Tempo: Byte;
    BMP: Byte;
  end;

var
  counter:dword;

{****************************************************************************}
function USS_MOD_Load(loadingmode : integer; panning: dword; filename: pchar): PUSM;
function USS_STM_Load(loadingmode : integer;panning: dword; filename: pchar): PUSM;
function USS_S3M_Load(loadingmode : integer;panning: dword; filename: pchar): PUSM;
function USS_XM_Load(loadingmode : integer;panning: dword; filename: pchar): PUSM;
function USS_IT_Load(loadingmode : integer;panning: dword; filename: pchar): PUSM;
function USS_USM_Load(loadingmode : integer;panning: dword; filename: pchar): PUSM;


Function USS_SetTimer(TimerAddress : Pointer; TicksNum : DWord) : Boolean;
Function USS_StopTimer(TimerAddress : Pointer) : Boolean;

{****************************************************************************}
procedure USS_ManualSetup;
procedure USS_AutomaticSetup;
procedure USS_SetAmplification(Ampli: Integer);

{****************************************************************************}
procedure USMP_LoadInternalModules(Music: PUSM);
procedure USMP_FreeModules(Music: PUSM);
procedure USMP_StartPlays(Music: PUSM);
procedure USMP_StopPlays;
procedure USMP_PrevOrders;
procedure USMP_NextOrders;
procedure USMP_SetOrders(order: dword);
procedure USMP_SetPositions(order: dword; row: dword);

{****************************************************************************}
procedure USS_HardwareInit(psp: dword);
-- procedure USS_HardwareEnd;

procedure USS_DisplayError(ErrorNumber: Integer);

procedure _Error_Number;external;
procedure _DEV_Offset;external;
procedure _DEV_Type;external;
procedure _DEV_Name;external;
procedure _DEV_BasePort;external;
procedure _DEV_IRQ;external;
procedure _DEV_DMA;external;
procedure _DEV_Freq;external;
procedure _DEV_Mode;external;
procedure _DEV_MAXCHANNELS;external;
procedure _Pattern;external;
procedure _Row;external;
procedure _Order;external;

implementation

{****************************************************************************}
procedure IW_DEVICE;external;
procedure GUS_DEVICE;external;
procedure SB_DEVICE;external;
procedure HP_DEVICE;external;
procedure NOSND_DEVICE;external;
{procedure _Error_Number;external;}
-- procedure _DEV_Number;external;
{procedure _DEV_Offset;external;
procedure _DEV_Type;external;
procedure _DEV_Name;external;
procedure _DEV_BasePort;external;
procedure _DEV_IRQ;external;
procedure _DEV_DMA;external;
procedure _DEV_Freq;external;
procedure _DEV_Mode;external;
procedure _DEV_MAXCHANNELS;external;}
-- procedure SSSampleOffsetT;external;
-- procedure SSInstrOffsetT;external;
procedure SSPeriodMin;external;
procedure SSPeriodMax;external;
-- procedure SSInstrumentMode;external;
procedure SSGlobalVol;external;
procedure SSActiveChannels;external;
procedure VChControl;external;
procedure VChInsAdress;external;
procedure VChPeriod;external;
procedure VChFreq;external;
procedure VChannelVol;external;
procedure VChVolume;external;
procedure VChFVolume;external;
procedure VChPanning;external;
procedure VChFPanning;external;
procedure VChSmpAdress;external;
procedure VChSmpOffset;external;
procedure VChFadeoutVol;external;
procedure VChVolEnvPos;external;
procedure VChVolEnvSegPos;external;
procedure VChEnvVol;external;
procedure VChPanEnvPos;external;
procedure VChPanEnvSegPos;external;
procedure VChEnvPan;external;
procedure VChAVibPos;external;
procedure VChAVibSwpPos;external;
procedure VChAVibPitch;external;
procedure USSVarStart;external;
procedure USSVarEnd;external;
procedure Period_Table;external;
procedure ZeroOffset;external;
procedure _Malloc;external;
procedure _Free;external;
procedure _MEMORY_Error;external;
procedure Memory_Return;external;
procedure TIMER_START_;external;
procedure TIMER_STOP_;external;

{ **** baszas *** }
procedure vchrealnb;external;
procedure vchnote;external;
procedure rchvirtualnb;external;
procedure rchnna;external;
procedure rchvolume;external;
procedure rchannelvol;external;
procedure rchpanning;external;
procedure rchperiod;external;

procedure USS_ChangeInstrument;external;
procedure USS_Setnna;external;
procedure USS_Pastnotecontrol;external;

procedure loadmode;external;
procedure mus_memoffset;external;
procedure memoryfread;external;

{ **** baszas *** }

procedure USS_Init              ;external;
procedure USS_SetActiveChannels ;external;
procedure USS_StartOutput       ;external;
procedure USS_StopOutput        ;external;
procedure USS_UpdateOutput      ;external;

procedure USS_LoadSample       ;external;
procedure USS_FreeSample       ;external;

procedure USS_GetGlobalVolume  ;external;
procedure USS_SetGlobalVolume  ;external;
procedure USS_GetChannelVolume ;external;
procedure USS_SetChannelVolume ;external;

procedure USS_StartInstrument  ;external;
procedure USS_InitInstrEnv     ;external;
procedure USS_SetEnvPos        ;external;
procedure USS_GetSampleVolume  ;external;
procedure USS_GetSamplePanning ;external;
procedure USS_SetSampleOffset  ;external;

procedure USS_SetNote          ;external;
procedure USS_GetPeriod        ;external;
procedure USS_SetPeriod        ;external;
procedure USS_GetNotePeriod    ;external;
procedure USS_GetVolume        ;external;
procedure USS_SetVolume        ;external;
procedure USS_GetPanning       ;external;
procedure USS_SetPanning       ;external;
procedure USS_NoteCut          ;external;
procedure USS_NoteFade         ;external;
procedure USS_KeyOff           ;external;
procedure USS_UpdateInstr      ;external;

procedure GetVibData          ;external;

--procedure _Malloc       ;external;
procedure _Calloc       ;external;
--procedure _Free         ;external;
procedure _Maxavail     ;external;
--procedure _MEMORY_Error ;external;
--procedure _Debug_MEMORY ;external;
--procedure Memory_Return ;external;

procedure  fopen     ;external;
procedure  fcreate   ;external;
procedure  fclose    ;external;
procedure  fsetpos   ;external;
procedure  fread     ;external;
procedure  fwrite    ;external;

procedure File_Open    ;external;
procedure MUS_File     ;external;
procedure MUS_Offset   ;external;
procedure MUS_Channels ;external;

procedure LU_LoadSample       ;external;
procedure LU_Check_Instrument ;external;
procedure LU_PackPattern      ;external;

procedure IRQ_Enable    ;external;
procedure IRQ_Disable   ;external;
procedure GetEnvOffset  ;external;
procedure DMA_Setup     ;external;
--procedure ZeroOffset ;external;
procedure PSPOffset  ;external;
procedure EnvOffset  ;external;
procedure DMABuffer      ;external;
procedure DMARealAddress ;external;

--procedure MIX_Rate     ;external;
procedure MIX_BSize    ;external;
procedure MIX_BOffset  ;external;
procedure MIX_FBOffset ;external;
procedure MIX_ActiveB  ;external;
procedure MIX_GetAmpli    ;external;
procedure MIX_SetAmpli    ;external;
procedure MIX_LoadSample  ;external;
procedure MIX_FreeSample  ;external;
procedure MIX_UpdateSound ;external;
procedure MIX_Start       ;external;
procedure MIX_Stop        ;external;


{$L UTILS.OBJ}
{$L TIMER.OBJ}
{$L FILES.OBJ}
{$L MEMORY.OBJ}
{$L HARDWARE.OBJ}
{$L ERROR.OBJ}
{$L MIX.OBJ}
{$L NOSNDDRV.OBJ}
{$L HPDRV.OBJ}
{$L SBDRV.OBJ}
{$L GUSDRV.OBJ}
{$L IWDRV.OBJ}
{$L LOADUTIL.OBJ}
{$L USMLOAD.OBJ}
{$L ITLOAD.OBJ}
{$L XMLOAD.OBJ}
{$L S3MLOAD.OBJ}
{$L STMLOAD.OBJ}
{$L MODLOAD.OBJ}
{$L USMPLAY.OBJ}
{$L USSVAR.OBJ}
{$L USS.OBJ}

{****************************************************************************}
procedure MOD_Load;external;
procedure STM_Load;external;
procedure S3M_Load;external;
procedure XM_Load;external;
procedure IT_Load;external;
procedure USM_Load;external;
procedure USS_Setup;external;
procedure USS_AutoSetup;external;
procedure USS_SetAmpli;external;

procedure USMP_LoadInternalModule;external;
procedure USMP_FreeModule;external;
procedure USMP_StartPlay;external;
procedure USMP_StopPlay;external;
procedure USMP_PrevOrder;external;
procedure USMP_NextOrder;external;
procedure USMP_SetOrder;external;
procedure USMP_SetPosition;external;
procedure HardwareInit_;external;
-- procedure HardwareEnd_;external;

procedure Display_Error_;external;

{****************************************************************************}
function USS_MOD_Load(loadingmode : integer;panning: dword; filename: pchar): PUSM;assembler;
asm
  pushad
  mov ebx,[loadingmode]
  mov eax,[panning]
  mov esi,[filename]
  call MOD_Load
  mov [esp+28],esi
  popad
end;

function USS_STM_Load(loadingmode : integer;panning: dword; filename: pchar): PUSM;assembler;
asm
  pushad
  mov ebx,[loadingmode]
  mov eax,[panning]
  mov esi,[filename]
  call STM_Load
  mov [esp+28],esi
  popad
end;

function USS_S3M_Load(loadingmode : integer;panning: dword; filename: pchar): PUSM;assembler;
asm
  pushad
  mov ebx,[loadingmode]
  mov eax,[panning]
  mov esi,[filename]
  call S3M_Load
  mov [esp+28],esi
  popad
end;

function USS_XM_Load(loadingmode : integer;panning: dword; filename: pchar): PUSM;assembler;
asm
  pushad
  mov ebx,[loadingmode]
  mov eax,[panning]
  mov esi,[filename]
  call XM_Load
  mov [esp+28],esi
  popad
end;

function USS_IT_Load(loadingmode : integer;panning: dword; filename: pchar): PUSM;assembler;
asm
  pushad
  mov ebx,[loadingmode]
  mov eax,[panning]
  mov esi,[filename]
  call IT_Load
  mov [esp+28],esi
  popad
end;

function USS_USM_Load(loadingmode : integer;panning: dword; filename: pchar): PUSM;assembler;
asm
  pushad
  mov ebx,[loadingmode]
  mov eax,[panning]
  mov esi,[filename]
  call USM_Load
  mov [esp+28],esi
  popad
end;

procedure USS_ManualSetup;assembler;
asm
  pushad
  call USS_Setup
  popad
end;

procedure USS_AutomaticSetup;assembler;
asm
  pushad
  call USS_AutoSetup
  popad
end;

procedure USS_SetAmplification(Ampli: Integer);assembler;
asm
  pushad
  call USS_SetAmpli
  mov [esp+28],esi
  popad
end;

{****************************************************************************}
procedure USMP_LoadInternalModules(Music: PUSM);assembler;
asm
  pushad
  mov esi,[Music]
  call USMP_LoadInternalModule
  popad
end;

procedure USMP_FreeModules(Music: PUSM);assembler;
asm
  pushad
  mov esi,[Music]
  call USMP_FreeModule
  popad
end;

procedure USMP_StartPlays(Music: PUSM);assembler;
asm
  pushad
  mov esi,[Music]
  call USMP_StartPlay
  popad
end;

procedure USMP_StopPlays;assembler;
asm
  pushad
  call USMP_StopPlay
  popad
end;

procedure USMP_PrevOrders;assembler;
asm
  push eax
  call USMP_PrevOrder
  pop eax
end;

procedure USMP_NextOrders;assembler;
asm
  push eax
  push esi
  call USMP_NextOrder
  pop esi
  pop eax
end;

procedure USMP_SetOrders(order: dword);assembler;
asm
  pushad
  mov eax,[order]
  call USMP_SetOrder
  popad
end;

procedure USMP_SetPositions(order: dword; row: dword);assembler;
asm
  pushad
  mov eax,[order]
  mov ebx,[row]
  call USMP_SetPosition
  popad
end;

{****************************************************************************}
procedure USS_HardwareInit(psp: dword);assembler;
asm
  pushad
  mov eax,[psp]
  call HardwareInit_
  popad
end;

{procedure USS_HardwareEnd;assembler;
asm
  pushad
  call HardwareEnd_
  popad
end;}

{****************************************************************************}
procedure USS_DisplayError(ErrorNumber: Integer);assembler;
asm
  pushad
  mov eax,[ErrorNumber]
  call Display_Error_
  popad
end;

{****************************************************************************}
procedure Malloc_;code;
asm
  push    ebx
  push    ecx
  push    esi
  push    edi
  add     eax,4
  shld    ebx,eax,16
  mov     ecx,eax
  mov     ah,05h
  mov     al,01h
  int     31h
  jc      @@Error
  shrd    eax,ebx,16
  mov     ax,cx
  mov     [eax],di
  inc     eax
  inc     eax
  mov     [eax],si
  inc     eax
  inc     eax
  pop     edi
  pop     esi
  pop     ecx
  pop     ebx
  ret
@@Error:
  pop     edi
  pop     esi
  pop     ecx
  pop     ebx
  xor eax,eax
  ret
end;

procedure Calloc_;code;
asm
  push    ebx
  push    ecx
  push    esi
  push    edi
  add     eax,4
  shld    ebx,eax,16
  mov     ecx,eax
  mov     ah,05h
  mov     al,01h
  int     31h
  jc      @@Error
  shrd    eax,ebx,16
  mov     ax,cx
  mov     [eax],di
  inc     eax
  inc     eax
  mov     [eax],si
  inc     eax
  inc     eax
  pop     edi
  pop     esi
  pop     ecx
  pop     ebx
  ret
@@Error:
  pop     edi
  pop     esi
  pop     ecx
  pop     ebx
  xor eax,eax
  ret
end;

procedure Free_;code;
asm
  push    esi
  push    edi
  push    eax
  mov     di,[eax-4]
  mov     si,[eax-2]
  mov     ah,05
  mov     al,02
  int     31h
  pop     eax
  pop     edi
  pop     esi
  ret
end;

Function USS_SetTimer(TimerAddress : Pointer; TicksNum : DWord) : Boolean; Assembler;
Asm
 MOV  EAX,[TimerAddress]
 MOV  EBX,TicksNum
 CALL Timer_Start_
 XOR  eax,eax
 JNC  @Exit
      INC EAX
 @Exit:
End;

Function USS_StopTimer(TimerAddress : Pointer) : Boolean; Assembler;
Asm
 MOV  EAX,[TimerAddress]
 CALL Timer_Stop_
 XOR  EAX,EAX
 JNC  @Exit
      INC EAX
 @Exit:
End;

End.