
// BUZZPLAY version v0.1 (Jan 29, 1999)
// Copyright (C) 1999 Oskari Tammelin (ot@iki.fi)
// Use freely for freeware applications

#ifndef __BUZZ_PLAY_H
#define __BUZZ_PLAY_H


extern "C"
{

#define MT_GENERATOR							1
#define MT_EFFECT                               2

struct BP_MachineFuncs
{
	void * (__stdcall *GetInfo)();
	void * (__stdcall *CreateMachine)();
};

struct BP_FileReader
{
	int (__stdcall *Read)(void *pbuf, int numbytes);	// ret: 1 = ok, 0 = error
	int (__stdcall *Seek)(int position);				// ret: 1 = ok, 0 = error
	
};

// ---------------------------------------------------------------
DI int __stdcall BP_Init(int samplerate);
// initalize buzzplay
// in:
//	samplerate - 11025..96000, 44100 recommended
// out:
//	1 = ok
//	0 = error


// ---------------------------------------------------------------
DI int __stdcall BP_AddMachineLib(char const *name, int type, BP_MachineFuncs *pmf);
// add machine .DLL to the player
// in:
//	name - name of the machine without extension (eg. "Jeskola Tracker")
//  type - MT_GENERATOR or MT_EFFECT
//  pmf - pointer to the exported DLL functions (see sample)
// out:
//	1 = ok
//	0 = error


// ---------------------------------------------------------------
DI int __stdcall BP_OpenSong(BP_FileReader *pfr);
// open song
// in:
//  pfr - pointer to your file reading/seeking function table
// out:
//	1 = ok
//	0 = error


// ---------------------------------------------------------------
DI float * __stdcall BP_Generate(int *numsamples);
// generate stereo floating point sample data
// in:
//  *numsamples - number of bytes wanted
// out:
//	*numsamples - number of bytes got
//	ret: pointer to samples

DI void __stdcall BP_CloseSong();
DI void __stdcall BP_DeInit();


}

#endif
