#ifndef _AE3DSCLASS_
#define _AE3DSCLASS_

#include "AE.h"

typedef struct {
	word	ID;
	dword	len;      
} TChunkHeader, *PChunkHeader;

class AE3DS:public AE
{
public:
	AESTRING FileName;
	FILE	*File;

	int Load3ds();
	int Load3ds(char *FName);
	int Scan3ds();
	int Scan3ds(char *FName);


private:
	AESTRING  *MapLoad;
	AESTRING  ObjName;
	FCol	FColLoad;
	float	PercentFLoad;
	char	PercentBLoad;
	unsigned char	BColLoad[3];
	int		*Mapnum;

	int	CurrMat,CurrMap;
	int	CurrObj,CurrCam,CurrTrimesh,CurrLight,CurrAmbient;
	int	CurrNode;
	int	CurrObjNode;
	int	CurrCamNode,CurrCTargetNode;
	int	CurrLightNode,CurrSpotlightNode,CurrLTargetNode;
	int	CurrAmbientNode;

	void ASCIIZReader (AESTRING &ch);
	void ASCIIZReader2 () ;
	int  FindMap(char *mit);
	int  FindMaterial(char *mit);
	void PercentFReader(long p);
	void PercentBReader(long p);
	void ColorFReader(long p);
	void ColorBReader(long p);

	void ChunkReader (long p);
	void ScanChunks (long p);

	void ObjBlockReader (long p);
	void TriMeshReader (long p);
	void VertListReader (long p);
	void FaceListReader (long p);
	void FaceMatReader (long p);
	void MapListReader (long p);
	void SmooListReader (long p);
	void TrMatrixReader(long p);
	void AXPNameReader(long pc);

	void LightReader(long p);
	void SpotLightReader(long p);
	void InnerRangeReader(long p);
	void OuterRangeReader(long p);
	
	void CameraReader(long p);

	void TexMapReader (long p);
	void EnvMapReader (long p);
	void MapFileReader(long p);
	void MatNameReader (long p);
	void MaterialReader (long p);
	void MatAmbientReader(long p);
	void MatDiffuseReader(long p);
	void MatSpecularReader(long p);
	void TranspReader (long p);

	
	void CurFrameReader (long p);
	void FramesReader(long p);
	void AmbientBlockReader (long p);
	void ObjTrackInfoReader(long p);
	void CamTrackInfoReader(long p);
	void TargetTrackInfoReader(long p);
	void LightTrackInfoReader(long p);
	void SpotlightTrackInfoReader(long p);
	void LTargetTrackInfoReader(long p);
	void AmbientTrackInfoReader(long p);
	void ObjNumberReader(long p);
	void TrackInstNameReader(long p);
	void TrackObjNameReader(long p);
	void PivotPointReader(long p);
	void TrackPosReader(long p);
	void TrackRotReader(long p);
	void TrackScaleReader(long p);
	void TrackFovReader(long p);
	void TrackRollReader(long p);
	void TrackColorReader(long p);
	void TrackHideReader(long p);
	void TrackHotspotReader(long p);
	void TrackFalloffReader(long p);
	void SplineFlagsReader(AESPLINE *Spline);

	void BuildTree(AENODE *prev);
};



#endif

