#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>

#include "..\h\FCol.h"
#include "..\h\console.h"

void FCol::printf() 
{
	conprintf("r:%3.2f g:%3.2f b:%3.2f\n",r,g,b);
}

void FCol::Clamp()
{
	if (r>1) r=1;
	if (g>1) g=1;
	if (b>1) b=1;
}

FCol FCol::operator-() 
{
	return (FCol(-r,-g,-b));
}

FCol FCol::operator+(const FCol &a) 
{
	return (FCol(a.r+r,a.g+g,a.b+b));
}

FCol FCol::operator-(const FCol &a) 
{
	return (FCol(r-a.r,g-a.g,b-a.b));
}

FCol FCol::operator*(const FCol &a) 
{
	return (FCol(r*a.r,g*a.g,b*a.b));
}

FCol FCol::operator+=(const FCol &a) 
{
	r+=a.r;
	g+=a.g;
	b+=a.b;
	return *this;
}

FCol FCol::operator-=(const FCol &a) 
{
	r-=a.r;
	g-=a.g;
	b-=a.b;
	return *this;
}

FCol FCol::operator*=(const FCol &a) 
{
	r*=a.r;
	g*=a.g;
	b*=a.b;
	return *this;
}

FCol FCol::operator*=(const float &a) 
{
	r*=a;
	g*=a;
	b*=a;
	return *this;
}

FCol FCol::operator/=(const float &a)
{
	float bb=(float)1./a;
	r*=bb;
	g*=bb;
	b*=bb;
	return *this;
}

FCol FCol::operator*(const float &a)
{
	return FCol(a*r,a*g,a*b);
}

FCol FCol::operator/(const float &a)
{
	float bb=(float)1./a;
	return FCol(bb*r,bb*g,bb*b);
}
