#include <windows.h>
#include <math.h>
#include <GL/gl.h>
#include <GL/glext.h>
#include "..\h\AE.h"
#include "..\h\console.h"

// calculates the bounding box of the mesh
void AETRIMESH::CalcBBox()
{
	Vector Min((float)99999.,(float)99999.,(float)99999.);
	Vector Max((float)-99999.,(float)-99999.,(float)-99999.);

	for(int j=0;j<NumVert;j++)
	{
		if (Vertices[j].x<Min.x) Min.x=Vertices[j].x;
		if (Vertices[j].x>Max.x) Max.x=Vertices[j].x;
		if (Vertices[j].y<Min.y) Min.y=Vertices[j].y;
		if (Vertices[j].y>Max.y) Max.y=Vertices[j].y;
		if (Vertices[j].z<Min.z) Min.z=Vertices[j].z;
		if (Vertices[j].z>Max.z) Max.z=Vertices[j].z;
	}
	BBox[0]=Min;
	BBox[1]=Vector(Min.x,Min.y,Max.z);
	BBox[2]=Vector(Min.x,Max.y,Min.z);
	BBox[3]=Vector(Max.x,Min.y,Min.z);
	BBox[4]=Vector(Max.x,Min.y,Max.z);
	BBox[5]=Vector(Max.x,Max.y,Min.z);
	BBox[6]=Vector(Min.x,Max.y,Max.z);
	BBox[7]=Max;
}
	   
AETRIMESH::AETRIMESH() 
{
	memset(this,0,sizeof(AETRIMESH));
}

// calculates the face/vertex normals of the mesh
void AETRIMESH::CalcNormals()
{
	Vector v,v1,v2,normal;
	float len;
	int j;
	
	for (j=0;j<NumVert;j++) Normals[j].Set(0,0,0);

	for (j=0;j<NumFaces;j++)
	{
		v1=(Vertices[Faces[j].b])-(Vertices[Faces[j].a]);
		v2=(Vertices[Faces[j].c])-(Vertices[Faces[j].a]);
		Faces[j].Normal=v1%v2;
		len=-Faces[j].Normal.Length();
		if (len != 0) Faces[j].Normal/=len;
		Faces[j].CullPoint=Vertices[Faces[j].a]*Faces[j].Normal;

		Normals[Faces[j].a]+=Faces[j].Normal;
		Normals[Faces[j].b]+=Faces[j].Normal;
		Normals[Faces[j].c]+=Faces[j].Normal;
	}
			
	for (j=0;j<NumVert;j++) Normals[j].Normalize();
}


AETRIMESH::~AETRIMESH()
{
	delete Faces;
	delete Vertices;
	delete Normals;
	if (MapCoords) delete MapCoords;
	if (ProcessName) delete ProcessName;
}


// hmm what does this aelight constructor do here ???? :)))
AELIGHT::AELIGHT()
{
	Spotlight=FALSE;
	Active=true;
	Draw=false;
}

