#include <windows.h>
#include <math.h>
#include <GL/gl.h>
#include <GL/glext.h>
#include "..\h\AE.h"
#include "..\h\console.h"

extern PFNGLACTIVETEXTUREARBPROC          glActiveTextureARB;
extern PFNGLMULTITEXCOORD2FARBPROC        glMultiTexCoord2fARB;
extern PFNGLCLIENTACTIVETEXTUREARBPROC	   glClientActiveTextureARB;

AENODE::AENODE()
{
	PosTrack.NumKeys=0;
	RotTrack.NumKeys=0;
	ScaleTrack.NumKeys=0;
	HideTrack.NumKeys=0;
	RollTrack.NumKeys=0;
	FovTrack.NumKeys=0;
	ColTrack.NumKeys=0;
	HotspotTrack.NumKeys=0;
	FalloffTrack.NumKeys=0;
	LocalToWorld.Identity();
	Obj=NULL;
	Rotated=NULL;
	RotatedNormals=NULL;
	PostColors=NULL;
	Hidden=FALSE;
	Shaded=TRUE;
	LightDistanceCounts=FALSE;
	FogEnabled=FALSE;
	MasterColor=FALSE;
	PostColor=FALSE;
	LightMapped=FALSE;
	DoubleMapped=FALSE;
	WireFrame=FALSE;
	MCol.Set(1,1,1);
	swfiller=NULL;
	FirstDaughter=NULL;
	PrevSister=NULL;
	NextSister=NULL;
	ID=65535;
	Name=NULL;
}

AENODE::~AENODE()
{
/*//	conprintf("%s\n",Name);

	if (Name) delete Name;

//	conprintf("PosTrack NumKeys %d\n",PosTrack.NumKeys);
	if (PosTrack.NumKeys>0) delete PosTrack.Key;
//	conprintf("PosTrack deleted\n");

	if (ScaleTrack.NumKeys>0) delete ScaleTrack.Key;
//	conprintf("ScaleTrack deleted\n");

	if (RotTrack.NumKeys>0) delete RotTrack.Key;
//	conprintf("RotTrack deleted\n");

	if (RollTrack.NumKeys>0) delete RollTrack.Key;
//	conprintf("RollTrack deleted\n");

	if (ColTrack.NumKeys>0) delete ColTrack.Key;
//	conprintf("ColTrack deleted\n");
	
	if (FovTrack.NumKeys>0) delete FovTrack.Key;
//	conprintf("FovTrack deleted\n");
	
	if (FalloffTrack.NumKeys>0) delete FalloffTrack.Key;
//	conprintf("FalloffTrack deleted\n");
	
	if (HotspotTrack.NumKeys>0) delete HotspotTrack.Key;
//	conprintf("HotspotTrack deleted\n");

	if (HideTrack.NumKeys>0) delete HideTrack.Key;
//	conprintf("HideTrack deleted\n");
	
	delete PostColors;
//	conprintf("PostColors deleted\n");
  
	delete RotatedNormals;
//	conprintf("RotatedNormals deleted\n");

	delete Rotated;
//	conprintf("Rotated deleted\n");
	
//	conprintf("Finished\n");*/
}

// renders the current object
void AENODE::Render(AECAMERA *ActiveCamera,AEAMBIENT *Ambient, AELIGHT **Light, int NumLights, int StampNum)
{
	Stamp=StampNum;
	TempNearPlane=ActiveCamera->NearClippingPlane;
	TempFarPlane=ActiveCamera->FarClippingPlane;

	LocalToScreen=LocalToWorld*ActiveCamera->WorldToScreen;
	LocalToCamera=LocalToWorld*ActiveCamera->WorldToCamera;

	if (Obj->Type==TRIMESH && !CheckBBox()) {
		WorldToLocal=LocalToWorld.Invert2();
		InverseCamPos=WorldToLocal*ActiveCamera->Pos;
		Rotate();
		Shade(Ambient,Light,NumLights);
		Draw();
	}
}

// bounding box visibility checking
bool AENODE::CheckBBox()
{
	int     i;
	Wector	bpoint;
	AETRIMESH *tmesh;

	tmesh=((AETRIMESH *)(Obj));

	ClipPlaneAND=-1;
	ClipPlaneOR=0;

	for (i=0;i<8;i++) 
	{
		tmesh->BBoxFlags[i]=0;
		bpoint=LocalToScreen*Wector(tmesh->BBox[i].x,tmesh->BBox[i].y,tmesh->BBox[i].z,1);
		
				if (bpoint.x <-bpoint.w) tmesh->BBoxFlags[i]|=CLIPLEFT;
		else	if (bpoint.x > bpoint.w) tmesh->BBoxFlags[i]|=CLIPRIGHT;
				if (bpoint.y <-bpoint.w) tmesh->BBoxFlags[i]|=CLIPBOTTOM;
		else	if (bpoint.y > bpoint.w) tmesh->BBoxFlags[i]|=CLIPTOP;
				if (bpoint.z <-bpoint.w) tmesh->BBoxFlags[i]|=CLIPNEAR;
		else	if (bpoint.z > bpoint.w) tmesh->BBoxFlags[i]|=CLIPFAR;
		
		ClipPlaneAND&=tmesh->BBoxFlags[i];
		ClipPlaneOR|=tmesh->BBoxFlags[i];
	}
	if (ClipPlaneAND==0) return FALSE;
	else return TRUE;
}

// originally this routine rotated the vertices,
// but as i moved to opengl transformations,
// the only purpose it serves is envmap UV
// calculation and vertexcolor initalization
void AENODE::RotateVertex(AEVERTEX *Vertex, int a, AETRIMESH *Source)
{

	Vertex->Stamp=Stamp;
	Vertex->Col.Set(0,0,0);
	
	if (Source->Material)
	if (Source->Material->EnvMap) {
		RotatedNormals[a]=LocalToCamera%Source->Normals[a];
		Vertex->MapCoords2.u=RotatedNormals[a].x+0.5f;
		Vertex->MapCoords2.v=RotatedNormals[a].y+0.5f;
	}
}


// another misleading name, it doesnt rotate anything,
// only tags frontfaced faces/connecting vertices
void AENODE::Rotate()
{
	int     i;
	AETRIMESH	*Source;
	AEFACE		*Face;

	Source=(AETRIMESH*)Obj;

	Face=&Source->Faces[0];
    for (i=0;i<Source->NumFaces;i++) 
	{
		if (Face->Flag & VISIBLE) Face->Flag-=VISIBLE;
		if (!(Face->Flag & DISABLED)) {
		if ((Source->TwoSided) || (Face->Normal*InverseCamPos > Face->CullPoint))
		{	//	frontfacing
			Face->Flag|=VISIBLE;
			AEVERTEX *a=&Rotated[Face->a];
			AEVERTEX *b=&Rotated[Face->b];
			AEVERTEX *c=&Rotated[Face->c];
			if (a->Stamp!=Stamp) RotateVertex(a,Face->a,Source);
			if (b->Stamp!=Stamp) RotateVertex(b,Face->b,Source);
			if (c->Stamp!=Stamp) RotateVertex(c,Face->c,Source);
		}
		}
		Face++;
	}
}

// software vertex-lighting
// i've tried opengl's built in lighting, but it proved to be
// too slow, so i came up with this.
// light distance counting is extremely unrealistic, but looks
// good.
void AENODE::Shade(AEAMBIENT *Ambient, AELIGHT **Light, int NumLights)
{
	int			i,j;
	AETRIMESH	*Source;
	AEMAT		*Material;
	AEVERTEX	*Vertex;
	FCol		Amb,Col;
	Vector		LightLocal,VertexToLight;
	float		Intensity, Distance, Distance2, t;

	Source=(AETRIMESH*)Obj;
	Material=Source->Material;

	if (Material) { // if no material present, skip it
		if (Shaded) {
			Amb=Ambient->Col;

			if (LightDistanceCounts) { // calculate WITH light distances (slower)
				for (j=0;j<NumLights;j++) {
					if (Light[j]->Active)
					{
						LightLocal=WorldToLocal*Light[j]->Pos;
						for (i=0;i<Source->NumVert;i++) {
							VertexToLight=LightLocal-Source->Vertices[i];
							Distance2=VertexToLight.Length2();
							if (Light[j]->OuterRange2>=Distance2) { // the vertex is illuminated by the current light
								Distance=(float)sqrt(Distance2);
								VertexToLight*=(float)1.0/Distance;
								Intensity=VertexToLight*Source->Normals[i];
								if (Intensity>0) {
									if (Light[j]->InnerRange2>Distance2) { // the vertex is fully illuminated (within the inner range)
										Rotated[i].Col+=Light[j]->Col*Intensity;
									} else { // the vertex is inbetween the inner and outer range, distance factor applies
										t=(Distance-Light[j]->InnerRange)*(Light[j]->FadingRange);
										Rotated[i].Col+=Light[j]->Col*(Intensity*t);
									}
								}
							}
						}
					}
				}
			} else { // simple dot-product shading, no distance calculations
				for (j=0;j<NumLights;j++) {
					if (Light[j]->Active)
					{
						LightLocal=WorldToLocal*Light[j]->Pos;
						for (i=0;i<Source->NumVert;i++) {
							if (Rotated[i].Stamp==Stamp) {
								VertexToLight=LightLocal-Source->Vertices[i];
								VertexToLight.Normalize();
								Intensity=VertexToLight*Source->Normals[i];
								if (Intensity>0) Rotated[i].Col+=Light[j]->Col*Intensity;
							}
						}
					}
				}
			}
		} else Amb.Set(1,1,1);

		// applying calculated vertex-colors
		// to material attributes
		Vertex=&Rotated[0];
		for (i=0;i<Source->NumVert;i++) {
			if (Vertex->Stamp==Stamp) {
				if (Material->TextureMap==NULL) {
					// no texture
					Vertex->Col+=Amb*Material->Ambient;
					Vertex->Col.Clamp();
					Vertex->Col*=Material->Diffuse;
				} else {
					Vertex->Col+=Amb;
					Vertex->Col.Clamp();
				}
			}
			Vertex++;
		}
	}

	// secondary pass for pre-coloring
	if (MasterColor || PostColor) {
		Vertex=&Rotated[0];
		for (i=0;i<Source->NumVert;i++) {
			if (Vertex->Stamp==Stamp) {
				// postcoloring means a special array of colors to be applied after lighting calculations (for special effects, or anything)
				if (PostColor) Vertex->Col*=PostColors[i];
				// mastercolor is like postcoloring, but it's a global RGB for the given object (fading in/out for example)
				if (MasterColor) Vertex->Col*=MCol;
			}
			Vertex++;
		}
	}
}


// draws the mesh
// notes: i use a custom 3d frontface calculating (see Rotate)
// because opengl's own was way too slow
// (driver dependent??)
void AENODE::Draw()
{
	int i;
	AETRIMESH	*Source;
	AEFACE		*Face;

	// save modelview matrix (currently holding camera information)
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();

	// multiply modelview matrix by the current object's local-to-world matrix
	glMultMatrixf(&LocalToWorld.m[0][0]);

	Source=(AETRIMESH*)Obj;
	Face=&Source->Faces[0];
	glBegin(GL_TRIANGLES);
	for (i=0;i<Source->NumFaces;i++)
	{
		if (Face->Flag&VISIBLE) { // current face is FRONTFACE
			if (Source->NumMapped) { // texture coordinates applied
				glColor3f(Rotated[Face->a].Col.r,Rotated[Face->a].Col.g,Rotated[Face->a].Col.b);
				glTexCoord2f(Source->MapCoords[Face->a].u,Source->MapCoords[Face->a].v);
				glVertex3f(Source->Vertices[Face->a].x,Source->Vertices[Face->a].y,Source->Vertices[Face->a].z);
				glColor3f(Rotated[Face->b].Col.r,Rotated[Face->b].Col.g,Rotated[Face->b].Col.b);
				glTexCoord2f(Source->MapCoords[Face->b].u,Source->MapCoords[Face->b].v);
				glVertex3f(Source->Vertices[Face->b].x,Source->Vertices[Face->b].y,Source->Vertices[Face->b].z);
				glColor3f(Rotated[Face->c].Col.r,Rotated[Face->c].Col.g,Rotated[Face->c].Col.b);
				glTexCoord2f(Source->MapCoords[Face->c].u,Source->MapCoords[Face->c].v);
				glVertex3f(Source->Vertices[Face->c].x,Source->Vertices[Face->c].y,Source->Vertices[Face->c].z);
			} else { // no texture coordinates
				glColor3f(Rotated[Face->a].Col.r,Rotated[Face->a].Col.g,Rotated[Face->a].Col.b);
				glVertex3f(Source->Vertices[Face->a].x,Source->Vertices[Face->a].y,Source->Vertices[Face->a].z);
				glColor3f(Rotated[Face->b].Col.r,Rotated[Face->b].Col.g,Rotated[Face->b].Col.b);
				glVertex3f(Source->Vertices[Face->b].x,Source->Vertices[Face->b].y,Source->Vertices[Face->b].z);
				glColor3f(Rotated[Face->c].Col.r,Rotated[Face->c].Col.g,Rotated[Face->c].Col.b);
				glVertex3f(Source->Vertices[Face->c].x,Source->Vertices[Face->c].y,Source->Vertices[Face->c].z);
			}
		}
		Face++;
	}
	glEnd();

	// restore modelview matrix to camera information only
	glPopMatrix();
}

