;// Chip Trixx
;// (C)oded by Sergey Chaban

.486p
LOCALS @@


;;__DEBUG=1
;;__MEMCHECK=1

cseg segment para use16
 assume cs:cseg, ds:cseg

  org 100h

_FARCLUT=1
_INVOKESYSTEMTIMER=1

IFDEF __DEBUG
 __STATISTICS=1
ENDIF


include mydefs.def
include fixed.mac
include matrix.def
include engine.def
include keyframe.def
include camera.def
include world.mac
include en_fast.mac
include spot.mac
include landscap.def
include div0.def
include debug.def

include palette.asm ; pal macroses


COMMENT ~

>>Memory layout
   main code/data   -  64k
   frame buffer     -  64k
   track data       -  16k
   textures         -  128k (32*4k)
   animation buffer -  48k
   landscape maps:
    *height field   -  64k
    *color map      -  64k
   stack            -  32k/64k  (depending on _FARCLUT)
   (optional)
   debug buffer     -  16k
  --------------------------------
   total:           =  480k/512k (496k/528k)
~

Start:
 ;****************************
 ;*     General setup        *
 ;****************************
 cld
 xor sp,sp
 fninit
 mov ax,cs
 mov es,ax
 ;>> Clear unitialized data area
 sub bx,bx
 xchg ax,bx
 mov di,offset __DataAreaOrigin
 mov cx,__DataAreaSize
 rep stosb
 xchg ax,bx
 ;>> Allocate memory using segment arithmetic
 add ah,10h     ; +64k (for the main code/data seg)
 mov word ptr ds:[Frame_Buf],ax
 add ah,10h     ; +64k (for the frame buffer)
 mov word ptr ds:[TrackData],ax
 add ah,4       ; +16k (for the track frames)
 fnstcw word ptr ds:[FPU_Temp]
 mov bx,word ptr ds:[FPU_Temp]
 and bh,NOT 3   ; 24 bit precision is enough
 mov word ptr ds:[FPUCW_Normal],bx
 or bh,0Ch      ; Rounding to 0 mode
 mov word ptr ds:[FPUCW_RoundToZero],bx
 fldcw word ptr ds:[FPUCW_Normal]
 CalcDeltaXReciprocals
 mov di,offset Textures
 mov cl,32
CalcTxtPtrs:
 stosw
 inc ah  ; +4k
 loop CalcTxtPtrs
 mov word ptr ds:[Landscape_HeightMap],ax
 add ah,10h
 mov word ptr ds:[Landscape_ColorMap],ax
 add ah,10h
 mov word ptr ds:[Animation_Buffer],ax ; 48k?
 add ah,0Ch                            ; 48k for the animation buffer
 IFDEF __MEMCHECK
  cmp ax,word ptr ds:[2]
  ja __memAbort
  mov dx,cs
  cmp ax,dx
  ja __memOk
 __memAbort:
  int 20h
 __memOk:
 ENDIF
 mov ss,ax
 IFDEF __DEBUG
  add ah,4
  mov word ptr ds:[DebugBuffer],ax
 ENDIF
 ; Set SP so that the span structures, passed through the stack,
 ; will be properly aligned for max speed!
 IFDEF _FARCLUT
 mov sp,0-0Eh
 ELSE
 mov sp,8000h-0Eh
 ENDIF
 mov di,offset Screen_Table
 mov ch,2 ;mov cx,200h
 sub ax,ax
Init_ScrTab:
 stosw
 add ax,320
 loop Init_ScrTab
 Gen_Palette
 Gen_CLUT
 ;*******************************

 xor al,al                 ; Use Euler angles
 mov si,offset Camera_Data
 call Init_Camera

 Landscape_SetVars
 Landscape_CalcFOV
 CalcLandscapeMaps
 CreateSpot

 call CreateWorld


 mov si,offset TextureMakersPtrs
GenerateTextures:
 lodsw
 test ax,ax      ; NULL pointer?
 jz TexturesDone 
 push si
 Temp=offset TextureMakersPtrs + 2 - offset Textures
 Temp=-Temp
 mov es,word ptr ds:[si+Temp]
 call ax
 pop si
 jmp GenerateTextures
TexturesDone:

 mov ax,13h     ;* Enter graphics video mode
 int 10h
 Set_VGA_Pal    ;* Initialize VGA palette DACs

 mov ax,1130h   ; * Grab VGA 8x16 ROM fonts
 mov bh,6
 int 10h        ; Function returns ROM fonts ptr in ES:BP
 mov ax,es
 shl eax,16
 xchg ax,bp
 mov dword ptr ds:[VGAROMFonts_Ptr],eax

 call SetupSpotPic


 mov al,CamFlag_QUATERNIONS
 mov si,offset Camera_Data
 call Init_Camera

 mov si,offset CameraTrack
 mov di,SIZE KeyFrame
 mov cx,PointsPerTrack
 call PrepareTrack
 mov word ptr ds:[CurrentTrackPointPtr],SIZE KeyFrame
 mov dword ptr ds:[TimeCounter],0

 OpenDumpFile

 IFDEF __STATISTICS
 mov dword ptr ds:[minFPS],12345678h
 ORG $-4
 dd 9999.99
 mov dword ptr ds:[maxFPS],0
 ENDIF



 Set_Div0

 mov cx,cs
 shl ecx,16
 mov cx,offset Timer_Proc
 mov dx,1193    ; 1kHz
 call Set_User_Timer  ; (!)



; <<<<<<<< Main loop >>>>>>>>
__MainLoop:
 mov eax,dword ptr ds:[TimeCounter]
 mov ebx,eax
 mov edx,dword ptr ds:[OldTime]
 mov dword ptr ds:[OldTime],eax
 sub eax,edx
 jz __MainLoop   ; For very fast processors :-)
 mov dword ptr ds:[TimePassed],eax
 fild dword ptr ds:[TimePassed]
 fdiv dword ptr ds:[TimeDiv]
 fst dword ptr ds:[TimeFactor]
 fmul dword ptr ds:[fp_Scale16]
 fistp dword ptr ds:[TimeFactor_fix16]

 mov ax,offset DemoFXNum
 xchg eax,ebx
 ; this is the right place for the 'high-level' asm constructions,
 ; such as .if eax==x etc, but for the sake of compatibility with
 ; older TASM versions (<=4.x) I used good old spaghetti code instead :)
 cmp eax,Event_1*1000
 jb __nofx
 cmp eax,Event_2*1000
 mov al,1
 jb __setfxn
 mov al,2
__setfxn:
 mov [bx],al
__nofx:
 movzx ax,byte ptr [bx]
 dec ax
 js __skipFX     ; 0
 jz __FX1  ; 1
 ;FX2
 call DrawLandscape
 Landscape_Move
 call PrintTitle
 jmp __skipFX
__FX1:
 call Do_Spot
 Move_Spot
__skipFX:

 mov es,word ptr ds:[Frame_Buf]
 push ds
 push 0A000h
 push es
 xor eax,eax
 mov di,ax
 mov cx,320*200 SHR 2
 push cx di
 rep stosd
 mov si,offset Camera_Data
 call InterpolateTrack
 call Rotate_Points
 call Render_Scene

IF 0  ; too slow -> REMOVED!
 mov dx,3DAh
@@w1:
 in al,dx
 test al,8
 jnz @@w1
@@w2:
 in al,dx
 test al,8
 jz @@w2
ENDIF ;---------------------

 mov dx,3DAh
 mov cx,100
Wait_VR:
 in al,dx
 test al,8
 loopz Wait_VR
 pop di cx
 pop ds
 pop es
 mov si,di
 rep movsd
 pop ds

 IFDEF __STATISTICS
 inc dword ptr ds:[FramesDone]

 mov eax,dword ptr ds:[TimeCounter]
 mov edx,dword ptr ds:[PrevFPSTime]
 neg edx
 add edx,eax
 cmp edx,1000
 jbe SkipFPScalc
 mov dword ptr ds:[PrevFPSTime],eax
 mov dword ptr ds:[FPS_TimeInterval],edx
 mov eax,dword ptr ds:[FramesDone]
 mov edx,dword ptr ds:[FramesAtLastSecond]
 mov dword ptr ds:[FramesAtLastSecond],eax
 sub eax,edx
 enter 4+2,0
 mov [bp-4],eax
 mov word ptr [bp-6],1000
 fild dword ptr [bp-4]
 fimul word ptr [bp-6]
 fidiv dword ptr ds:[FPS_TimeInterval]
 fcom dword ptr ds:[minFPS]
 GetFPUFlags
 jae noMinFPS
 fst dword ptr ds:[minFPS]
noMinFPS:
 fcom dword ptr ds:[maxFPS]
 GetFPUFlags
 jbe noMaxFPS
 fst dword ptr ds:[maxFPS]
noMaxFPS:
 fstp st(0)
 leave
SkipFPScalc:
 ENDIF

;; add dword ptr ds:[TimeCounter],1000/100 ; (!)
 cmp word ptr ds:[CurrentTrackPointPtr],PointsPerTrack*(SIZE KeyFrame)
 jae FinishIt


 in al,60h
 cmp al,1         ; [ESC] pressed?
 jnz __MainLoop   ; Nope, continue...

FinishIt:
 IFDEF __STATISTICS
 push es
 _PrintMode 2
 enter 8,0
 mov word ptr [bp-2],1000
 fild qword ptr ds:[FramesDone]
 fimul word ptr [bp-2]
 fild qword ptr ds:[PolysDone]
 fimul word ptr [bp-2]
 fild qword ptr ds:[TimeCounter]
 fdivr dword ptr ds:[fp_One]
 mov es,word ptr ds:[DebugBuffer]
 xor di,di
 push bp
 fmul st(2),st
 fmulp st(1),st
 fstp dword ptr [bp-8] ; pps
 fstp dword ptr [bp-4] ; fps
 printl <Vertices: >,ushort,[NumPoints]
 printl <Faces: >,ushort,[Num3DPolys]
 print <min engine speed: >,float,[minFPS]
 print < fps\n>
 print <max engine speed: >,float,[maxFPS]
 print < fps\n>
 pop bp
 _PrintMode 4
 print <Average engine speed: >,float,[bp-4]
 print < fps, >,float,[bp-8]
 print < pps\n>
 SaveBytes di
 leave
 pop es
 ENDIF

 call Reset_DOS_Timer ; (!)
 Reset_Div0

 CloseDumpFile
 mov ax,3
 int 10h
 mov ax,0C00h  ; flash kbd buffer
 int 21h
 mov dx,offset FinMsg
 DOSCALL 9
 int 20h


include camera.asm
include engine.asm
include matrix.asm
include vecmath.asm
include quatmath.asm
include keyframe.asm
include spot.asm
include landscape.asm
include txtgen.asm
include world.asm
include vgaprint.asm
include timer.asm
include titles.asm
include div0.asm
IFDEF __DEBUG
 include numprint.asm
 include debug.asm
ENDIF

include consts.asm

;;db 50 dup (0)

include datas.asm


IFNDEF _FARCLUT
CLUT LABEL word
ENDIF

db 'DATA:'
dw __DataAreaOrigin
dw __DataAreaSize


cseg ends
end Start
