
static gmpInformation   *info;
static unsigned    sync;                /* Screen synchronization magic */
static gmpModule   *module;             /* Da module */
int    error;
unsigned        position;               /* Current position */
unsigned        pattern;                /* Current pattern number */
unsigned        row;                    /* Current row number */
int             syncInfo;               /* Music synchronization info */
char            *moduleName = "808state.s3m";
volatile unsigned   frameCount;

void CALLING prevr(void)
{
    frameCount++;
}


/****************************************************************************\
*
* Function:     void Error(char *msg)
*
* Description:  Displays an error message and exits to DOS
*
* Input:        char *msg               error message
*
\****************************************************************************/

void Error(char *msg)
{
    printf("Error: %s\n", msg);
#ifndef NOMUSIC
    midasClose();           /* IMPORTANT! */
#endif
    exit(EXIT_FAILURE);
}




/****************************************************************************\
*
* Function:     void Errorcode(int errorcode)
*
* Description:  Displays an error message related to a MIDAS error code and
*               exits to DOS
*
* Input:        int errorcode           MIDAS error code
*
\****************************************************************************/

void Errorcode(int errorcode)
{
    Error(errorMsg[errorcode]);
}



/****************************************************************************\
*
* Function:     void UpdateInfo(void)
*
* Description:  Updates song playing information (defined at the beginning of
*               this file)
*
* Note:         To use the position information from Assembler, do the
*               following (almost - get the idea?)
*
*               INCLUDE "midas.inc"
*               ...
*               GLOBAL  UpdateInfo : LANG
*               ...
*               EXTRN   position : dword
*               EXTRN   pattern : dword
*               EXTRN   row : dword
*               EXTRN   syncInfo : dword
*               ...
*               CODESEG
*               ...
*               PROC    SuperRoutine    NEAR
*               ...
*               call    UpdateInfo C
*               cmp     [position],17
*               je      @@design
*               ...
*
\****************************************************************************/

void CALLING UpdateInfo(void)
{
    int         error;

    /* Get GMP playing information: (this can't fail but let's just play it
       safe) */
    gmpGetInformation(midasPlayHandle, &info);
 //   if ( (error = gmpGetInformation(midasPlayHandle, &info)) != OK )
 //       midasError(error);

    /* Store interesting information in easy-to-access variables: */
    position = info->position;
    pattern = info->pattern;
    row = info->row;
    syncInfo = info->syncInfo;
}

void startmusic(void)
{
#ifndef NOMUSIC
    /* Call this first: */
    midasSetDefaults();

    /* Run MIDAS Sound System setup: */
    midasConfig();
    set80x25x16();
    info = malloc(1000);
#endif

#ifndef NOMUSIC
    /* Get screen synchronization value: (ie. time per frame) */
    if ( (error = tmrGetScrSync(&sync)) != OK )
        midasError(error);
#endif

    /* Now we could return to text mode for setup and stuff */

#ifndef NOMUSIC

    midasOutputMode |= sdMono;
    midasOutputMode &= ~sdStereo;
    midasInit();
    printf("Using %s\n%s, using port %X, IRQ %i and DMA %i\n",
        midasSD->name, midasSD->cardNames[midasSD->cardType-1],
        midasSD->port, midasSD->IRQ, midasSD->DMA);
    puts("Loading music");
    if ( (error = gmpLoadS3M(moduleName, 1, NULL, &module)) != OK )
        midasError(error);
#endif
#ifndef NOMUSIC
    if ( (error = tmrSyncScr(sync, &prevr, NULL, NULL)) != OK )
        midasError(error);
    midasPlayModule(module, 0);
#endif

}

void stopmusic(void)
{
#ifndef NOMUSIC
    midasStopModule(module);
    if ( (error = gmpFreeModule(module)) != OK )
        midasError(error);
    midasClose();
    free(info);
#endif
}
