
//-----------------------------------------------------------------------------
//                            MAYHEM 
//                      An Incognita production
//                              1997 (c)
//            Da Winner at Euskal Party V held in Donostia
//
//-----------------------------------------------------------------------------

#include <types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <stdarg.h>
#include <keyb_hnd.h>
#include <dpmi.h>
#include <graphs.h>
#include <graph.h>
#include <icp.h>
#include <arg.h>
#include <misc.h>
#include <log.h>

#include "world\land.h"
#include "world\surface.h"
#include "world\scan.h"
#include "zoom.h"
#include "seal\music.h"
#include "tga.h"
#include "mayhem.h"

BYTE *virtual;
BOOLEAN icg_boss=FALSE,alt=FALSE;

void main(DWORD argc, BYTE **argv) {

    MEM_INFO dpmi;
    BYTE dpmi_cpu,dpmi_vh,dpmi_vl;
    BOOLEAN dpmi_virtual;
    BYTE *logo,*logo_r,*back,*back_r,error;
    FILEINFO finfo;
    DWORD xres=DEFX,yres=DEFY;
    BOOLEAN _320x200_avail=FALSE;

    lib_parms(argc,argv);

    if(lib_check_parm("/h")!=-1) {
        show_help();
        exit(1);
    }

    if(lib_check_parm("/x")!=-1) {
        xres=atoi(lib_get_parm(lib_check_parm("/x")+1));
        alt=TRUE;
    }

    if(lib_check_parm("/y")!=-1) {
        yres=atoi(lib_get_parm(lib_check_parm("/y")+1));
        alt=TRUE;
    }

    if(lib_check_parm("/log")!=-1) lib_log_start("log.txt");

    if(lib_check_parm("/icgrulez")!=-1) icg_boss=TRUE;

    DPMI_get_memory_info(&dpmi);
    DPMI_getversion(&dpmi_vh,&dpmi_vl,&dpmi_cpu,&dpmi_virtual);

    draw_intro(icg_boss);

    lib_log(0,"Mayhem v%d.%d - Compiled at %s",VH,VL,__DATE__);
    printf("\n\n    Demo Version: %d.%d\n",VH,VL);
    printf("\n    Checking mayhem.dat\n");
    error=lib_load_icp("mayhem.dat");
    switch(error) {
        case ICP_NOTFOUND :      fatal_error("Mayhem.dat not found");
        case ICP_CORRUPT  :      fatal_error("Mayhem.dat is corrupt");
        case ICP_NOMEMORY :      fatal_error("Not enough memory");
        case ICP_CRCERROR :      fatal_error("Mayhem.dat : CRC error %d",error);
    }
    lib_log(0,"mayhem.dat checked");

    printf("\n    DPMI v%d.%d found\n",dpmi_vh,dpmi_vl);
    lib_log(0,"DPMI v%d.%d found",dpmi_vh,dpmi_vl);

    printf("      + Largest Block Available is %d bytes",dpmi.LargestBlockAvail);
    if(dpmi.LargestBlockAvail<6700000) printf(" (Warning!!)\n");
    else printf("\n");
    lib_log(0,"Largest Block Available: %d bytes",dpmi.LargestBlockAvail);

    printf("\n    Initializing keyboard driver\n");
    lib_keyb_on(NULL);

    printf("    Initializing graphics system\n");
    if(lib_check_parm("/safe")!=-1) {

        if(lib_init_gfx_engine(TNSYNC)) fatal_error("lib_init_gfx_engine");

    }
    else
        if(lib_init_gfx_engine(TRSYNC)) fatal_error("lib_init_gfx_engine");

    printf("      + Vesa Version: %d.%d\n",graphics_system.versionh,
        graphics_system.versionl);
    lib_log(0,"Vesa v%d.%d found",graphics_system.versionh,graphics_system.versionl);

    printf("      + Video Ram available: %d  bytes\n",graphics_system.video_memory);
    lib_log(0,"Vram: %d",graphics_system.video_memory);

    printf("      + Handler set at %d Hz",frequency);
    lib_log(0,"Timer set to %d Hz",frequency);

    if(detect_windows95()) printf(" ( Win95 mode )\n");
    else printf(" ( DOS mode )\n");

    if(detect_windows95()) lib_log(0,"Windows 95");

    if(lib_set_mode(xres,yres,16,GINFO)!=NULL) {

        printf("      + %dx%d %d bits mode found\n",xres,yres,graphics_system.bbp);
        printf("        - Size (RGB): %d%d%d\t- Pos (RGB): %2d %2d %2d\n",
            graphics_system.redsize,graphics_system.greensize,
            graphics_system.bluesize,graphics_system.redpos,
            graphics_system.greenpos,graphics_system.bluepos);

        lib_log(0,"%dx%d %d bits mode found",xres,yres,graphics_system.bbp);
        lib_log(0,"Size (RGB): %d%d%d\t- Pos (RGB): %2d %2d %2d",
            graphics_system.redsize,graphics_system.greensize,
            graphics_system.bluesize,graphics_system.redpos,
            graphics_system.greenpos,graphics_system.bluepos);

    }
    else fatal_error("Can't init %dx%d graphic mode",xres,yres);

    if(lib_set_mode(320,200,16,GINFO|GNODUP)!=NULL)
        lib_log(0,"320x200 NoEmulate mode");
    if(lib_set_mode(320,200,16,GINFO)==NULL) _320x200_avail=FALSE;
    else _320x200_avail=TRUE;
    lib_log(0,"320_200 avail = %s",_320x200_avail==TRUE?"TRUE":"FALSE");

    if(lib_set_mode(DEFX,DEFY,16,GINFO)==NULL)
        fatal_error("Can't init 640x480x16 graphics mode");

    printf("\n    Initializing sound system\n");
    config_music(TRUE);
    finfo=lib_getfileinfo("euskal.xm");
    load_song(finfo.name,finfo.offset);

    lib_log(0,"euskal.xm loaded");

    while(K_L_SHIFT) ;

    printf("\n    Loading. Please wait...\n");
    lib_log(0,"");

    if(alt) {

        lib_log(0,"Alt mode");

        // Fondo del Metaballs

        back_r=malloc(DEFX*DEFY*sizeof(WORD));
        if(back_r==NULL) fatal_error("Can't load Background");
        if(read_tga_picture("back.tga",back_r,DEFX,DEFY))
            fatal_error("Can't open Background");

        lib_log(0,"read_tga_picture('back.tga')");

        back=malloc(xres*yres*sizeof(WORD));
        if(back==NULL) fatal_error("Can't load BackGround");

        // Ttulo de la demo

        logo_r=malloc(DEFX*DEFY*sizeof(WORD));
        if(logo_r==NULL) fatal_error("Can't load logo");
        if(read_tga_picture("title.tga",logo_r,DEFX,DEFY))
             fatal_error("Can't open logo");

        lib_log(0,"read_tga_picture('title.tga')");

        logo=malloc(xres*yres*sizeof(WORD));
        if(logo==NULL) fatal_error("Can't load logo");

        lib_set_mode(xres,yres,16,GINFO);
        lib_log(0,"lib_set_mode(xres,yres)");

        scale_bitmap(back_r,back);
        free(back_r);
        lib_log(0,"scale_bitmap(back)");

        scale_bitmap(logo_r,logo);
        free(logo_r);
        lib_log(0,"scale_bitmap(logo)");

    }
    else {

        lib_log(0,"Normal mode");

        back=malloc(DEFX*DEFY*sizeof(WORD));
        if(back==NULL) fatal_error("Can't load Background");
        if(read_tga_picture("back.tga",back,DEFX,DEFY))
            fatal_error("Can't open Background");

        lib_log(0,"read_tga_picture('back.tga')");

        logo=malloc(DEFX*DEFY*sizeof(WORD));
        if(logo==NULL) fatal_error("Can't load Background");
        if(read_tga_picture("title.tga",logo,DEFX,DEFY))
            fatal_error("Can't open Background");

        lib_log(0,"read_tga_picture('title.tga')");

        lib_set_mode(xres,yres,16,GINFO);
        lib_log(0,"lib_set_mode(xres,yres)");

    }

    lib_log(0,"");
    lib_log(0,"init_bump3d()");
    init_bump3d();

    virtual=lib_set_mode(xres,yres,16,GLFB|GBANKS|GVIRTUAL);
    if(virtual==NULL) fatal_error("Can't init graphics mode");

//------------------------------------------------------------------------------
//                      Comienzo de Mayhem
//------------------------------------------------------------------------------

    lib_log(0,"");
    lib_log(0,"start()");
    start();

//------------------------------------------------------------------------------
//                      Ttulo de la Demo
//------------------------------------------------------------------------------

    lib_log(0,"");
    lib_log(0,"title(logo)");
//    play_music();
//    set_song_pos(0x50000);
    title(logo);

//------------------------------------------------------------------------------
//                      Jarrn con Bump 3d
//------------------------------------------------------------------------------

    lib_log(0,"");
    lib_log(0,"bump3d(logo)");
//    play_music();
//    set_song_pos(0x70000);
    bump3d(logo);
    free(logo);

//------------------------------------------------------------------------------
//                         MetaBalls 3D
//------------------------------------------------------------------------------

    lib_log(0,"");
    lib_log(0,"metaballs(back)");
//    play_music();
//    set_song_pos(0xd0000);
    metaballs(back);
    free(back);

//------------------------------------------------------------------------------
//                    Real Time Ray Tracing
//------------------------------------------------------------------------------

    lib_log(0,"");
    lib_log(0,"ray(_320x200_avail)");
//    play_music();
//    set_song_pos(0x120000);
    ray(_320x200_avail);

//------------------------------------------------------------------------------
//                      Demonio & Karateka
//------------------------------------------------------------------------------

    lib_log(0,"lib_set_mode");
    virtual=lib_set_mode(xres,yres,16,GLFB|GBANKS|GVIRTUAL);
    if(virtual==NULL) fatal_error("Can't init graphics mode");

    lib_log(0,"");
    lib_log(0,"karateka()");
//    play_music();
//    set_song_pos(0x1c0000);
    karateka();

//------------------------------------------------------------------------------
//                            Cueva
//------------------------------------------------------------------------------

    lib_log(0,"");
    lib_log(0,"cueva()");
//    play_music();
//    set_song_pos(0x280000);
    cueva();

//------------------------------------------------------------------------------
//                    Sistema de Partculas
//------------------------------------------------------------------------------

    lib_log(0,"");
    lib_log(0,"part(_320x200_avail)");
//    play_music();
//    set_song_pos(0x360000);
    part(_320x200_avail);

    lib_log(0,"");
    lib_log(0,"stop_music()");
    stop_music();
    lib_log(0,"unload_song()");
    unload_song();
    lib_log(0,"end_music()");
    end_music();

    config_music(FALSE);
    finfo=lib_getfileinfo("euskal2.xm");
    load_song(finfo.name,finfo.offset);

    lib_log(0,"euskal2.xm loaded");

//------------------------------------------------------------------------------
//                        Planos Splines
//------------------------------------------------------------------------------

    lib_log(0,"play_music");
    play_music();
    lib_log(0,"blanket(xres,yres)");
    blanket(xres,yres);

    credits();

}

void draw_intro(BOOLEAN tweaked) {

    _clearscreen(0);
    _setbkcolor(_BLUE);
    _settextcolor(14);
    _outtext("\
                                 MAYHEM                         (C) Incognita'97");
    _settextposition(24,0);
    _settextcolor(14);

    if(tweaked)
    _outtext("\
                               Hello Boss!!                                     ");
    else
    _outtext("\
                                                                                ");

    _setbkcolor(_BLACK);
    _settextcolor(8);

    _settextcolor(13);
    _settextposition(3,5);
    _outtext("Type mayhem /h for command line help. Press 'F1' to take photos");

}

void show_help(void) {

    _clearscreen(0);
    _setbkcolor(_BLUE);
    _settextcolor(14);
    _outtext("\
                                 MAYHEM                         (C) Incognita'97");

    _setbkcolor(_BLACK);
    _settextcolor(13);

    _settextposition(3,4);
    _outtext("Format: ");
    printf("    mayhem.exe [/h] [/x X] [/y Y] [/d x] [/8b] [/mono] [/nofilter]\n");
    printf("                          [/r xxxx] [/safe] [/log]\n");

    _settextposition(5,4);
    _outtext("Switches: ");
    printf("\n\n     /x X /y Y     : Change resolution to X x Y (X,Y=pixels)\n");
    printf("     /8b           : Force Music to 8 bits\n");
    printf("     /mono         : Change from stereo to mono\n");
    printf("     /r xxxx       : Set sampling rate to xxxx Hz\n");
    printf("     /nofilter     : Disable sound filter\n");
    printf("     /d x          : Select sound device :\n");
    show_devices();
    printf("     /safe         : Try this if you can't run the demo\n");
    printf("     /log          : Generate a log");

    _setbkcolor(_BLACK);
    _settextcolor(8);

}

void config_music(BOOLEAN show) {

    // Valores por defecto

    SBYTE device=AUDIO_AUTODETECT;
    WORD bits=MUSIC_16BITS;
    WORD stereo=MUSIC_STEREO;
    WORD filter=MUSIC_FILTER;
    DWORD srate=44100;

    if(lib_check_parm("/d")!=-1) {
        device=atoi(lib_get_parm(lib_check_parm("/d")+1));
    }

    if(lib_check_parm("/8b")!=-1) bits=MUSIC_8BITS;
    if(lib_check_parm("/mono")!=-1) stereo=MUSIC_MONO;
    if(lib_check_parm("/nofilter")!=-1) filter=MUSIC_NFILTER;
    if(lib_check_parm("/r")!=-1) {
        srate=atoi(lib_get_parm(lib_check_parm("/r")+1));
    }

    if(show) {
        printf("      + %s at %d-bits %s %d Hz\n",
            init_music(device,bits,stereo,filter,srate),
            bits==MUSIC_16BITS?16:8,
            stereo==MUSIC_STEREO?"stereo":"mono",
            srate);
        lib_log(0,"%s at %d-bits %s %d Hz",
            init_music(device,bits,stereo,filter,srate),
            bits==MUSIC_16BITS?16:8,
            stereo==MUSIC_STEREO?"stereo":"mono",
            srate);
    }
    else lib_log(0,"%s at %d-bits %s %d Hz",
            init_music(device,bits,stereo,filter,srate),
            bits==MUSIC_16BITS?16:8,
            stereo==MUSIC_STEREO?"stereo":"mono",
            srate);

//    init_music(device,bits,stereo,filter,srate);

}

void capture_screen(void) {

    DWORD i;
    BYTE name[20];
    FILE *fp;

    for(i=0;i<100;i++) {
        sprintf(name,"mayhem%02d.tga",i);
        if((fp=fopen(name,"rb"))==NULL) {
            take_photo(virtual,name);
            lib_log(2,"Photo!");
            return;
        }
        else fclose(fp);
    }
}

void scale_bitmap(BYTE *bin, BYTE *bout) {

    BYTE *old_v;
    VERTEX screen[4];

    screen[0].x=0;
    screen[0].y=0;
    screen[0].slope=0;

    screen[1].x=0;
    screen[1].y=graphics_system.yresolution;
    screen[1].slope=0;

    screen[2].x=graphics_system.xresolution;
    screen[2].y=graphics_system.yresolution;
    screen[2].slope=0;

    screen[3].x=graphics_system.xresolution;
    screen[3].y=0;
    screen[3].slope=0;

    Ha=(float)DEFX/graphics_system.xresolution;
    Va=0.0;

    Hb=0.0;
    Vb=(float)DEFY/graphics_system.yresolution;

    Hc=0.0;
    Vc=0.0;

    a0=0.0;
    b0=0.0;
    c0=1.0;

    uadjust=0;
    vadjust=0;

    ulimit=DEFX*65536.0-1.0;
    vlimit=DEFY*65536.0-1.0;

    iwidth=DEFX;

    texel=(WORD *)bin;

    old_v=virtual;
    virtual=bout;
    scan_poly(screen,4);
    virtual=old_v;


}

void start(void) {

    float pfrm;
    DWORD cur_frm;
    BYTE *virtual3,*old_v;

    initworld("start.wrl","start.cam",615*1024);
    virtual3=malloc(graphics_system.image_size);
    if(virtual3==NULL) fatal_error("Not enough memory (start)");

    lib_log(1,"init_zoom()");
    init_zoom();


    lib_log(1,"play_music()");
    play_music();

    lib_log(1,"Start Loop: %d",get_song_pos());

    pfrm=lib_get_time();
    cur_frm=0;

    while(get_song_pos()<0x50000) {
        if(K_ESC) credits();
        cur_frm=(DWORD)((lib_get_time()-pfrm)*40);

        old_v=virtual;
        virtual=virtual3;
        frame_world(cur_frm);
        virtual=old_v;

        if(graphics_system.bbp==15) {

            blur15(virtual3,virtual3,last_virtual_frame_buffer,graphics_system.image_size);
            zoom_frame_asm_15(virtual3);

        }
        else {

            blur16(virtual3,virtual3,last_virtual_frame_buffer,graphics_system.image_size);
            zoom_frame_asm_16(virtual3);

        }


        if(K_F1) capture_screen();
        virtual=lib_flush_vga();

    }

    lib_log(1,"shut_down_world()");
    shut_down_world();
    free(virtual3);

}

void title(BYTE *logo) {

    DWORD xres,yres;

    memset(virtual,0xffff,graphics_system.image_size);
    virtual=lib_flush_vga();

    memset(virtual,0xffff,graphics_system.image_size);
    virtual=lib_flush_vga();

    xres=graphics_system.xresolution;
    yres=graphics_system.yresolution;

    memcpy(virtual,logo,graphics_system.image_size);
    virtual=lib_flush_vga();

    lib_log(1,"Show Title");
    memcpy(virtual,logo,graphics_system.image_size);

    while(get_song_pos()<0x70000) {
        if(K_ESC) credits();
        if(K_F1) capture_screen();
    }

}

void bump3d(BYTE *logo) {

    lib_log(1,"init_bump3d_2()");
    init_bump3d_2();

    while(get_song_pos()<0xd0000) {
        if(K_ESC) credits();
        if(get_song_pos()<0xb0000) frame_bump3d(logo);
        else frame_bump3d(NULL);
        if(K_F1) capture_screen();
        virtual=lib_flush_vga();
    }

    lib_log(1,"end_bump3d()");
    end_bump3d();
}


void metaballs(BYTE *pic) {

    memset(virtual,0xffff,graphics_system.image_size);
    virtual=lib_flush_vga();

    memset(virtual,0xffff,graphics_system.image_size);
    virtual=lib_flush_vga();

    memcpy(virtual,pic,graphics_system.image_size);
    virtual=lib_flush_vga();

    lib_log(1,"init_meta(pic)");
    init_meta(pic);

    while(get_song_pos()<0x120000) {
        if(K_ESC) credits();
        frame_meta();
        if(K_F1) capture_screen();
        virtual=lib_flush_vga();
    }

    lib_log(1,"end_meta()");
    end_meta();
}

void ray(BOOLEAN _320x200_avail) {

    float pfrm;
    DWORD cur_frm;
    DWORD xres,yres;

    xres=graphics_system.xresolution;
    yres=graphics_system.yresolution;

    lib_log(1,"init_ray");
    if(alt) init_ray(xres,yres);
    else if(_320x200_avail) init_ray(320,200);
    else init_ray(320,240);

    pfrm=lib_get_time();
    cur_frm=0;
    lib_log(1,"ray loop");
    while(get_song_pos()<0x1c0000) {
        if(K_ESC) credits();
        cur_frm=(DWORD)((lib_get_time()-pfrm)*10.0);
        frame_ray(cur_frm);
        if(K_F1) capture_screen();
        virtual=lib_flush_vga();
    }

    lib_log(1,"end_ray");
    end_ray();

}

void karateka(void) {

    BYTE *blur,*old_v;
    float pfrm;
    DWORD cur_frm;
    DWORD xres,yres;
    BYTE *demon_r,*demon;

    xres=graphics_system.xresolution;
    yres=graphics_system.yresolution;

    if(xres!=DEFX || yres!=DEFY) {
        lib_set_mode(DEFX,DEFY,16,GINFO);

        demon=malloc(xres*yres*sizeof(WORD));
        if(demon==NULL) fatal_error("Can't load Demon Tga");

        demon_r=malloc(DEFX*DEFY*sizeof(WORD));
        if(demon_r==NULL) fatal_error("Can't load Demon.tga");
        if(read_tga_picture("demon.tga",demon_r,DEFX,DEFY))
            fatal_error("Can't open Demon Tga");

        virtual=lib_set_mode(xres,yres,16,GLFB|GBANKS|GVIRTUAL);

        scale_bitmap(demon_r,demon);
        free(demon_r);

    }
    else {

        demon=malloc(DEFX*DEFY*sizeof(WORD));
        if(demon==NULL) fatal_error("Can't load Demon Tga");
        if(read_tga_picture("demon.tga",demon,DEFX,DEFY))
            fatal_error("Can't open Background");
    }

    memcpy(virtual,demon,xres*yres*sizeof(WORD));
    virtual=lib_flush_vga();

    memcpy(virtual,demon,xres*yres*sizeof(WORD));
    free(demon);

    blur=malloc(graphics_system.image_size);
    if(blur==NULL) fatal_error("Not enough memory (karateka)");

    init_karateka();
    init_karateka2();
    initworld("tatami.wrl","karate.cam",130*1024);

    while(get_song_pos()<0x1e0000) {
        if(K_ESC) credits();
        if(K_F1) capture_screen();
    }

    init_karateka3();
    initworld2();
    pfrm=lib_get_time();
    cur_frm=0;

    while(get_song_pos()<0x280000) {

        if(K_ESC) credits();

        old_v=virtual;
        virtual=blur;

        cur_frm=(DWORD)((lib_get_time()-pfrm)*29.2);
        frame_world(cur_frm);
        frame_karateka();

        virtual=old_v;

        if(graphics_system.bbp==15)
            blur15(virtual,blur,last_virtual_frame_buffer,graphics_system.image_size);
        else
            blur16(virtual,blur,last_virtual_frame_buffer,graphics_system.image_size);

        if(K_F1) capture_screen();
        virtual=lib_flush_vga();

    }

    memset(virtual,0,xres*yres*sizeof(WORD));
    virtual=lib_flush_vga();

    shut_down_world();
    end_karateka();
    free(blur);

}

void cueva(void) {

    float pfrm;
    DWORD cur_frm;

    initworld("cueva.wrl","cueva.cam",1350*1024);

    pfrm=lib_get_time();
    cur_frm=0;
    while(get_song_pos()<0x360000) {

        if(K_ESC) credits();
        cur_frm=(DWORD)((lib_get_time()-pfrm)*40);
        frame_world(cur_frm);

        if(K_F1) capture_screen();
        virtual=lib_flush_vga();
    }

    shut_down_world();

}

void part(BOOLEAN _320x200_avail) {

    DWORD xres,yres;

    xres=graphics_system.xresolution;
    yres=graphics_system.yresolution;

    if(alt) init_part(xres,yres);
    else if(_320x200_avail) init_part(320,200);
    else init_part(320,240);

    while(get_song_pos()<0x3a0000) {

        if(K_ESC) credits();
        frame_part();
        if(K_F1) capture_screen();
        virtual=lib_flush_vga();

    }

    memset(virtual,0,graphics_system.image_size);
    virtual=lib_flush_vga();

    end_part();

}

extern BYTE next;

void blanket(DWORD xres, DWORD yres) {


    init_blanket("manta.tga","credit.tga","greet1.tga","greet2.tga",xres, yres);

    while(get_song_pos()<0x140000) {

        if(K_ESC) credits();
        frame_blanket();

        if(K_F1) capture_screen();
        virtual=lib_flush_vga();

    }

    end_blanket();

}

void fatal_error(const BYTE *msg, ...) {

    static BYTE error[50];
    va_list arg;

    unload_song();
    end_music();
    lib_keyb_off();
    lib_end_gfx_engine();
    lib_unload_icp();

    va_start(arg,msg);
    vsprintf(error,msg,arg);
    printf("\n Total Mayhem: %s!!\n",error);

    lib_log(0,"");
    lib_log(0,"Total Mayhem: %s!!",error);
    lib_log_end();

    va_end(arg);

    _setbkcolor(_BLACK);
    _settextcolor(8);

    exit(1);

}

void credits(void) {

    unload_song();
    end_music();
    lib_keyb_off();
    lib_end_gfx_engine();
    lib_unload_icp();

    printf("\n Mayhem by Incognita. (C) 1997\n");

    _setbkcolor(_BLACK);
    _settextcolor(8);

    lib_log_end();

    exit(1);

}
