//#define AMBIENT 0.3
//#define DIFFUSE 0.3
//#define SPECULAR 0.6
//#define COEFFICIENT 20

#define AMBIENT 0.4
#define DIFFUSE 0.4
#define SPECULAR 0.4
#define COEFFICIENT 20

#define WIRE 0
#define FLAT 1
#define GOURAUD 2
#define ENVMAP 3
#define TEXTURE 4
#define GOUR_TEXTURE 5

#define Z_CLIPPING FALSE
#define HITHER  5                   // Plano de clipping Z
#define NSHADES 256                 // Nmero de intensidades

#define EPSILON 0.001

#define PI 3.141592653589793238462643383279502884197169399375105820975

typedef struct {
         SDWORD x,y;
}PIXEL;

typedef struct {
        SDWORD u,v;
}TEXT;

typedef struct {
        float u,v;
}RTEXT;

#pragma pack(1)
typedef struct {
        SDWORD x,y;
        SDWORD u,v;
        DWORD color;
}VERTEX;
#pragma pack()          // Lo dejamos como estaba otra vez

typedef struct {
       short a,b,c;
}PTOS_TRI;

typedef struct {
        float a,b,c,d;
}EQ_TRI;

typedef struct {
    BYTE *name[20];
    BYTE *bitmap;
}MATERIAL;

typedef struct {
        float orgx,orgy,orgz;
        WORD n_vertices,n_tri,n_text;
        MATRIZ o_space,e_space;
        VECTOR *vertices;
        BYTE *flags;
        VECTOR *rot_vertices;
        PIXEL *proyecciones;
        PTOS_TRI *tri;
        EQ_TRI *ecuaciones;
        VECTOR *normal;         // Normal a cada punto
        BYTE *color;            // Color de cada punto
        TEXT *env;              // Coordenada de env_mapping
        TEXT *map;              // Coordenadas de textura (si existen)
        BYTE *texel;            // Textura a cada plano
}OBJECT;

#define MAX_OBJECTS 200
#define MAX_DUMMIES 500

#define ENTITY struct entity

ENTITY{
        DWORD w_object;
        DWORD no_child;
        ENTITY **child;
};

typedef struct {
        WORD n_objects;             // Nmero de objetos cargados
        WORD n_tri;                 // Nmero de tringulos cargados
        WORD n_materials;           // Nmero de texturas cargadas
        WORD n_dummies;             // Polgonos que pasan el plano z=HITHER
        MATRIZ camara;              // Posicin del observador
        OBJECT object[MAX_OBJECTS]; // Todos los objetos
        OBJECT dummy;               // Necesario para z-clipping
        ENTITY *entity;
        BYTE render;                // Tipo de Render
        VECTOR light;
        MATERIAL **material;
            // chapuzas
            DWORD frames;
            DWORD entidades;
            float *track;
}WORLD;

typedef struct {
    VECTOR pos;
    VECTOR target;
    float roll;
}CAMERA_FRAME;

struct TRI_TMP{
        OBJECT *n_object;
        PTOS_TRI *n_tri;
        WORD color;             // Para Flat
        WORD depth;
        BYTE bitmap;
        struct TRI_TMP *next_tri;   // Los tringulos estn enlazados unos a
                                    //  otros para que puedan ser ordenados
                                    //  fcilmente
};

typedef struct TRI_TMP TRI;


DWORD filesize(FILE *);
void init_the_world(void);
void load_object(WORD *,float,float,float);
void load_camera(BYTE *);
void update_camera(DWORD);
void rotar_objects(void);
void draw_objects();
void radix_sort();
BYTE read_tga_map(BYTE *,BYTE *,BYTE *);
void convert_pal(BYTE *pal);
BYTE precalc_gouraud(BYTE *, BYTE *, BYTE *, float, float, float, float);

// 3d_cr.asm
void back_face(WORD ,BYTE *,VECTOR *,EQ_TRI *,PTOS_TRI *,BYTE *);
#pragma aux back_face parm [ecx][edx][ebx][edi][esi][eax];
void transform_pts(WORD, BYTE * ,VECTOR * ,VECTOR * ,MATRIZ *,PIXEL *);
#pragma aux transform_pts parm [ecx][eax][esi][edi][ebx][edx];
// gtexture.asm
void draw_gtexture_poly(VERTEX *, BYTE *);
#pragma aux draw_gtexture_poly parm [esi][eax];


void draw_line(DWORD, DWORD, DWORD, DWORD, DWORD);
#pragma aux draw_line parm [ecx][eax][esi][ebx][edx];
void draw_clip_line(DWORD, DWORD, DWORD, DWORD, DWORD);
#pragma aux draw_clip_line parm [ecx][eax][esi][ebx][edx];

extern BOOLEAN icg_boss;

void draw_frame(void);
void credits(void);
void fatal_error(const BYTE *, ...);
void clrscr(DWORD);
void transform(VECTOR *,VECTOR *, MATRIZ);
void hierarchical_transform(ENTITY *, MATRIZ, BYTE);
void hierarchical_render(ENTITY *, VECTOR, VECTOR, BYTE);
void zclipping(OBJECT *, PTOS_TRI *, SDWORD, DWORD);
void one_clip(OBJECT *, DWORD, DWORD, DWORD, SDWORD);
void two_clip(OBJECT *, DWORD, DWORD, DWORD, SDWORD);
void point_cam(WORD);
void make_env(void);
void draw_poly(VERTEX *, char);
void gouraud_poly(VERTEX *);
void env_poly(VERTEX *);
