#include <types.h>
#include "matrix.h"

#define BLUR_MOTION TRUE

#define AMBIENT 0.1
#define DIFFUSE 0.4
#define SPECULAR 0.7
#define COEFFICIENT 15

#define TRANSITION 20

#define WIRE 0
#define FLAT 1
#define GOURAUD 2
#define ENVMAP 3
#define TEXTURE 4
#define GOUR_TEXTURE 5
#define ENV_TEXTURE 6

#define Z_CLIPPING FALSE
#define HITHER  5
#define NSHADES 256

#define EPSILON 0.001

#define PI 3.141592653589793238462643383279502884197169399375105820975

typedef struct {
    BYTE a,b,g,r;
}RGB_32;

typedef struct {
    RGB_32 pal_32[256];
}PAL_32;

typedef struct {
    SDWORD b,g,r;
}RGB_FIXED;

typedef struct {
         SDWORD x,y;
}PIXEL;

typedef struct {
        SDWORD u,v;
}TEXT;

typedef struct {
        float u,v;
}RTEXT;

#pragma pack(1)         // Debe coincidir con VERTEX.INC
typedef struct {
        SDWORD x,y;
        SDWORD u,v;
        SDWORD u2,v2;
        DWORD color;
}VERTEX;
#pragma pack()

typedef struct {
       short a,b,c;
}PTOS_TRI;

typedef struct {
        float a,b,c,d;
}EQ_TRI;

typedef struct {
    BYTE *name[20];
    BYTE *bitmap;
}MATERIAL;

typedef struct {
        float orgx,orgy,orgz;
        WORD n_vertices,n_tri,n_text;
        MATRIZ o_space,e_space;
        VECTOR *vertices;
        BYTE *flags;
        VECTOR *rot_vertices;
        PIXEL *proyecciones;
        PTOS_TRI *tri;
        EQ_TRI *ecuaciones;
        VECTOR *normal;         // Normal a cada punto
        BYTE *color;            // Color de cada punto
        TEXT *env;              // Coordenada de env_mapping
        TEXT *map;              // Coordenadas de textura (si existen)
        BYTE *texel;            // Textura a cada plano
}OBJECT;

#define MAX_OBJECTS 200
#define MAX_DUMMIES 500

#define ENTITY struct entity

ENTITY{
        DWORD w_object;
        DWORD no_child;
        ENTITY **child;
};

typedef struct {
        WORD n_objects;             // Nmero de objetos cargados
        WORD n_tri;                 // Nmero de tringulos cargados
        WORD n_materials;           // Nmero de texturas cargadas
        WORD n_dummies;             // Polgonos que pasan el plano z=HITHER
        MATRIZ camara;              // Posicin del observador
        OBJECT object[MAX_OBJECTS]; // Todos los objetos
        OBJECT dummy;               // Necesario para z-clipping
        ENTITY *entity;
        BYTE render;                // Tipo de Render
        VECTOR light;
        MATERIAL **material;

        DWORD frames;
        DWORD entidades;
        float *track;
}WORLD;

typedef struct {
    VECTOR pos;
    VECTOR target;
    float roll;
}CAMERA_FRAME;

typedef struct TRI_S{
        OBJECT *n_object;
        PTOS_TRI *n_tri;
        WORD color;
        WORD depth;
        BYTE bitmap;
        struct TRI_S *next_tri;
}TRI;


DWORD filesize(FILE *);
void init_the_world(void);
void load_object(WORD *,float,float,float);
void load_camera(BYTE *);
void update_camera(DWORD);
void rotar_objects(void);
void draw_objects();
void radix_sort();
void draw_frame(void);
void fatal_error(const BYTE *, ...);
void clrscr(BYTE *,DWORD);
void transform(VECTOR *,VECTOR *, MATRIZ);
void hierarchical_transform(ENTITY *, MATRIZ, BYTE);
void hierarchical_render(ENTITY *, VECTOR, VECTOR, BYTE);
void zclipping(OBJECT *, PTOS_TRI *, DWORD);
void one_clip(OBJECT *, DWORD, DWORD, DWORD);
void two_clip(OBJECT *, DWORD, DWORD, DWORD);
void make_env(BYTE *, PAL_32 *);
void make_bump(BYTE *, BYTE *);
void make_light(PAL_32 *, BYTE *, float, float, float);
WORD get_high(WORD);
void filter_texture(BYTE *);
void filter_pal(BYTE *);
void calc_transition(PAL_32 *, RGB_FIXED *, RGB_FIXED *);
void do_transition(DWORD *, float, RGB_FIXED *, RGB_FIXED *);

BYTE read_tga_map(BYTE *,BYTE *,BYTE *);
BYTE read_tga_picture(BYTE *, BYTE *, DWORD, DWORD);
void convert_pal(BYTE *pal);
void convert_pal_8(BYTE *palin, BYTE *palout);
BYTE precalc_gouraud(BYTE *, BYTE *, BYTE *, float, float, float, float);

void back_face(WORD ,BYTE *,VECTOR *,EQ_TRI *,PTOS_TRI *,BYTE *);
#pragma aux back_face parm [ecx][edx][ebx][edi][esi][eax];
void transform_pts(WORD, BYTE * ,VECTOR * ,VECTOR * ,MATRIZ *,PIXEL *);
#pragma aux transform_pts parm [ecx][eax][esi][edi][ebx][edx];
void draw_ptexture_poly(VERTEX *, BYTE *);
#pragma aux draw_ptexture_poly parm [esi][eax];
void blur15(BYTE *, BYTE *, BYTE *, DWORD);
#pragma aux blur15 parm [edi][esi][edx][ecx];
void blur16(BYTE *, BYTE *, BYTE *, DWORD);
#pragma aux blur16 parm [edi][esi][edx][ecx];

void init_bump3d(void);
void frame_bump3d(BYTE *);
void end_bump3d(void);

extern BOOLEAN icg_boss;
