// FracturedView.cpp : implementation of the CFracturedView class
//

#include "stdafx.h"
#include "Fractured.h"
#include "FracturedDoc.h"
#include "FracturedView.h"
#include "Star.h"
#include "StarDensityDialog.h"
#include "StarVelocityDialog.h"
#include "Hints.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static const unsigned int STAR_TIMER = 1;
static const unsigned int INITIAL_DENSITY = 500;
static const unsigned int INITIAL_VELOCITY = 200;

/////////////////////////////////////////////////////////////////////////////
// CFracturedView

IMPLEMENT_DYNCREATE(CFracturedView, CView)

BEGIN_MESSAGE_MAP(CFracturedView, CView)
	//{{AFX_MSG_MAP(CFracturedView)
	ON_WM_TIMER()
	ON_WM_ERASEBKGND()
	ON_COMMAND(ID_STARS_REVERSE, OnStarsReverse)
	ON_UPDATE_COMMAND_UI(ID_STARS_REVERSE, OnUpdateStarsReverse)
	ON_COMMAND(ID_STARS_COLOR_NONE, OnStarsColorNone)
	ON_UPDATE_COMMAND_UI(ID_STARS_COLOR_NONE, OnUpdateStarsColorNone)
	ON_COMMAND(ID_STARS_COLOR_RED, OnStarsColorRed)
	ON_UPDATE_COMMAND_UI(ID_STARS_COLOR_RED, OnUpdateStarsColorRed)
	ON_COMMAND(ID_STARS_COLOR_GREEN, OnStarsColorGreen)
	ON_UPDATE_COMMAND_UI(ID_STARS_COLOR_GREEN, OnUpdateStarsColorGreen)
	ON_COMMAND(ID_STARS_COLOR_BLUE, OnStarsColorBlue)
	ON_UPDATE_COMMAND_UI(ID_STARS_COLOR_BLUE, OnUpdateStarsColorBlue)
	ON_COMMAND(ID_STARS_DENSITY, OnStarsDensity)
	ON_COMMAND(ID_STARS_PAUSE, OnStarsPause)
	ON_UPDATE_COMMAND_UI(ID_STARS_PAUSE, OnUpdateStarsPause)
	ON_COMMAND(ID_STARS_VELOCITY, OnStarsVelocity)
	ON_COMMAND(ID_STARS_SMOOTH, OnStarsSmooth)
	ON_UPDATE_COMMAND_UI(ID_STARS_SMOOTH, OnUpdateStarsSmooth)
	ON_WM_LBUTTONDBLCLK()
	ON_WM_RBUTTONDBLCLK()
	ON_COMMAND(ID_STARS_VERTICAL, OnStarsVertical)
	ON_UPDATE_COMMAND_UI(ID_STARS_VERTICAL, OnUpdateStarsVertical)
	ON_COMMAND(ID_STARS_RESTART_HORIZONTAL, OnStarsRestartHorizontal)
	ON_COMMAND(ID_STARS_RESTART_VERTICAL, OnStarsRestartVertical)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFracturedView construction/destruction

CFracturedView::CFracturedView() : density(INITIAL_DENSITY), velocity(INITIAL_VELOCITY), pause(false)
{
	this->stars = new CStar[this->density];
}

CFracturedView::~CFracturedView()
{
	delete [] this->stars;
}

BOOL CFracturedView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CFracturedView drawing

void CFracturedView::OnDraw(CDC* pDC)
{
	CFracturedDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	pDC->SetBkColor(RGB(0, 0, 0));

	CRect rect;
	this->GetClientRect(rect);

	// allow each existing star an update
	// this will get called when invalidate is called from ontimer
	for (unsigned int i = 0; i < this->density; i++)
	{
		this->stars[i].update(pDC, rect);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CFracturedView diagnostics

#ifdef _DEBUG
void CFracturedView::AssertValid() const
{
	CView::AssertValid();
}

void CFracturedView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CFracturedDoc* CFracturedView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CFracturedDoc)));
	return (CFracturedDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFracturedView message handlers

void CFracturedView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();

	this->SetTimer(STAR_TIMER, this->velocity, 0);
}

void CFracturedView::OnTimer(UINT nIDEvent) 
{
	if (nIDEvent == STAR_TIMER)
	{
		if (!this->pause)
		{
			this->Invalidate(FALSE);
		}
	}
	
	CView::OnTimer(nIDEvent);
}

BOOL CFracturedView::OnEraseBkgnd(CDC* pDC) 
{
	// this is just to make the background black

	CBrush backgroundBrush(RGB(0, 0, 0));
	CBrush* pOldBrush = pDC->SelectObject(&backgroundBrush);
	
	CRect rect;
	pDC->GetClipBox(&rect);
	
	pDC->PatBlt(rect.left, rect.top, rect.Width(), rect.Height(), PATCOPY);
	
	pDC->SelectObject(pOldBrush);

	return TRUE;
}

void CFracturedView::OnStarsReverse() 
{
	this->stars[0].setReverse(!this->stars[0].getReverse());
	
	this->Invalidate(TRUE);
}

void CFracturedView::OnUpdateStarsReverse(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(this->stars[0].getReverse());
}

void CFracturedView::OnStarsColorNone() 
{
	if (this->stars[0].getRed() || this->stars[0].getGreen() || this->stars[0].getBlue())
	{
		this->stars[0].setRed(false);
		this->stars[0].setGreen(false);
		this->stars[0].setBlue(false);
		
		this->Invalidate(TRUE);
	}
}

void CFracturedView::OnUpdateStarsColorNone(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(!this->stars[0].getRed() && !this->stars[0].getGreen() && !this->stars[0].getBlue());
}

void CFracturedView::OnStarsColorRed() 
{
	if (!this->stars[0].getRed())
	{
		this->stars[0].setRed(true);
		this->stars[0].setGreen(false);
		this->stars[0].setBlue(false);
		
		this->Invalidate(TRUE);
	}
	else
	{
		this->OnStarsColorNone();
	}
}

void CFracturedView::OnUpdateStarsColorRed(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(this->stars[0].getRed() && !this->stars[0].getGreen() && !this->stars[0].getBlue());
}

void CFracturedView::OnStarsColorGreen() 
{
	if (!this->stars[0].getGreen())
	{
		this->stars[0].setRed(false);
		this->stars[0].setGreen(true);
		this->stars[0].setBlue(false);
		
		this->Invalidate(TRUE);
	}
	else
	{
		this->OnStarsColorNone();
	}
}

void CFracturedView::OnUpdateStarsColorGreen(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(!this->stars[0].getRed() && this->stars[0].getGreen() && !this->stars[0].getBlue());
}

void CFracturedView::OnStarsColorBlue() 
{
	if (!this->stars[0].getBlue())
	{
		this->stars[0].setRed(false);
		this->stars[0].setGreen(false);
		this->stars[0].setBlue(true);

		this->Invalidate(TRUE);
	}
	else
	{
		this->OnStarsColorNone();
	}
}

void CFracturedView::OnUpdateStarsColorBlue(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(!this->stars[0].getRed() && !this->stars[0].getGreen() && this->stars[0].getBlue());
}

void CFracturedView::OnStarsDensity() 
{
	CStarDensityDialog starDensityDialog(this);
	if (starDensityDialog.DoModal() == IDOK)
	{
		this->density = starDensityDialog.density;
		
		delete [] this->stars;
		this->stars = new CStar[this->density];
	}

	this->Invalidate(TRUE);
}

void CFracturedView::OnStarsPause() 
{
	this->pause = !this->pause;

	this->Invalidate(TRUE);
}

void CFracturedView::OnUpdateStarsPause(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(this->pause);
}

void CFracturedView::OnStarsVelocity() 
{
	CStarVelocityDialog starVelocityDialog(this);
	if (starVelocityDialog.DoModal() == IDOK)
	{
		this->velocity = starVelocityDialog.velocity;

		this->SetTimer(STAR_TIMER, this->velocity, 0);
	}

	this->Invalidate(TRUE);
}

void CFracturedView::OnStarsSmooth() 
{
	// reset timing for optimum performance depending on which mode we are in
	// the user can change this from the velocity menu
	if (this->stars[0].getSmooth())
	{
		this->stars[0].setSmooth(false);
		this->velocity = 200;
		this->SetTimer(STAR_TIMER, this->velocity, 0);
	}
	else
	{
		this->stars[0].setSmooth(true);
		this->velocity = 50;
		this->SetTimer(STAR_TIMER, this->velocity, 0);
	}

	this->Invalidate(TRUE);
}

void CFracturedView::OnUpdateStarsSmooth(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(this->stars[0].getSmooth());
}

void CFracturedView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	this->OnStarsPause();
	
	CView::OnLButtonDblClk(nFlags, point);
}

void CFracturedView::OnRButtonDblClk(UINT nFlags, CPoint point) 
{
	this->OnStarsReverse();
	
	CView::OnRButtonDblClk(nFlags, point);
}

void CFracturedView::OnStarsVertical() 
{
	this->stars[0].setVertical(!this->stars[0].getVertical());

	this->Invalidate(TRUE);
}

void CFracturedView::OnUpdateStarsVertical(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(this->stars[0].getVertical());
}

void CFracturedView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	if (lHint == HINT_CLOSE_DOCUMENT)
	{
		this->stars[0].reset();
	}
}

void CFracturedView::OnStarsRestartHorizontal() 
{
	for (unsigned int i = 0; i < this->density; i++)
	{
		this->stars[i].restartHorizontal();
	}

	this->Invalidate(TRUE);
}

void CFracturedView::OnStarsRestartVertical() 
{
	for (unsigned int i = 0; i < this->density; i++)
	{
		this->stars[i].restartVertical();
	}

	this->Invalidate(TRUE);
}
