/**************************************************************************************************

Title:  DDRAW RotoZoomer Code
From :  Dallas Nutsch ynb53@ttu.edu
Desc :

  Main example file for Roto Zoomer
 
Notes:

Revisions:

	6-1-98 First Release

Disclaimer:

	THIS SOFTWARE IS NOT SUPPORTED. THE AUTHOR IS NOT RESPONSIBLE OR LIABLE FOR ANY USE OF THIS CODE.
	THE AUTHOR IS NOT LIABLE FOR ANY DAMAGE, MISUSE, OR BAD STUFF THAT HAPPENS WHEN YOU USE THIS 
	CODE.

*************************************************************************************************/

#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <math.h>
#include "DDRAW.H"
#include "DDROTATE.H"

#pragma warning( disable : 4244)

HANDLE GError;

void GlobalError (char * str,va_list argList)
{
	if (GError == INVALID_HANDLE_VALUE) 
	{
		return;		
	}

	DWORD wlength;
	char * FormatBuffer = new char [500];

	int length = vsprintf(FormatBuffer, str, argList);

	if (str==NULL)
	{
		WriteFile (GError,"Global: Error - Null Error",strlen("Global: Error - Null Error"),&wlength,NULL);
	}
	else
	{
		WriteFile (GError,FormatBuffer,strlen(FormatBuffer),&wlength,NULL);
	}
	delete [] FormatBuffer;
}
void GlobalError (char * str,...)
{
	va_list argList;
	va_start(argList, str);
	GlobalError(str, argList);
	va_end(argList);
}


LPDIRECTDRAW2 lpDD;
LPDIRECTDRAWSURFACE lpDDSFront;
LPDIRECTDRAWSURFACE lpDDSBack;
LPDIRECTDRAWSURFACE lpImage;
LPDIRECTDRAWSURFACE lpImage2;


int Frame;


BOOL bActive=FALSE;



long PASCAL WinProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{

		case WM_SYSKEYDOWN:
		case WM_SYSKEYUP:
		case WM_SYSCHAR:
			 return (0);
			 break;
		case WM_SYSCOMMAND:
			switch (wParam &0xfff0)
			{
				case SC_SCREENSAVE:
				case SC_MONITORPOWER:
					return 0;
					break;
				default:
					break;
			};
			break;
		case WM_ERASEBKGND:
			//return 1;
			break;
		case WM_KILLFOCUS:
			Sleep (1000); //sleep to let windows resize
			break;
		case WM_ACTIVATEAPP:
			bActive = wParam;
			break;

		case WM_CREATE:
			break;

		case WM_SETCURSOR:
				SetCursor(NULL);
				return TRUE;
			break;

		case WM_KEYDOWN:
			PostQuitMessage(0);
			break;

		case WM_DESTROY:
			PostQuitMessage(0);
			break;
	}

	return DefWindowProc(hWnd, message, wParam, lParam);
}

void DDError(HRESULT hErr, void* hWnd)
{
	char dderr[256];
	char err[1024];

	switch (hErr)
	{
		case DDERR_ALREADYINITIALIZED : sprintf(dderr, "DDERR_ALREADYINITIALIZED"); break;
		case DDERR_CANNOTATTACHSURFACE : sprintf(dderr, "DDERR_CANNOTATTACHSURFACE"); break;
		case DDERR_CANNOTDETACHSURFACE : sprintf(dderr, "DDERR_CANNOTDETACHSURFACE"); break;
		case DDERR_CURRENTLYNOTAVAIL : sprintf(dderr, "DDERR_CURRENTLYNOTAVAIL"); break;
		case DDERR_EXCEPTION : sprintf(dderr, "DDERR_EXCEPTION"); break;
		case DDERR_GENERIC : sprintf(dderr, "DDERR_GENERIC"); break;
		case DDERR_HEIGHTALIGN : sprintf(dderr, "DDERR_HEIGHTALIGN"); break;
		case DDERR_INCOMPATIBLEPRIMARY : sprintf(dderr, "DDERR_INCOMPATIBLEPRIMARY"); break;
		case DDERR_INVALIDCAPS : sprintf(dderr, "DDERR_INVALIDCAPS"); break;
		case DDERR_INVALIDCLIPLIST : sprintf(dderr, "DDERR_INVALIDCLIPLIST"); break;
		case DDERR_INVALIDMODE : sprintf(dderr, "DDERR_INVALIDMODE"); break;
		case DDERR_INVALIDOBJECT : sprintf(dderr, "DDERR_INVALIDOBJECT"); break;
		case DDERR_INVALIDPARAMS : sprintf(dderr, "DDERR_INVALIDPARAMS"); break;
		case DDERR_INVALIDPIXELFORMAT : sprintf(dderr, "DDERR_INVALIDPIXELFORMAT"); break;
		case DDERR_INVALIDRECT : sprintf(dderr, "DDERR_INVALIDRECT"); break;
		case DDERR_LOCKEDSURFACES : sprintf(dderr, "DDERR_LOCKEDSURFACES"); break;
		case DDERR_NO3D : sprintf(dderr, "DDERR_NO3D"); break;
		case DDERR_NOALPHAHW : sprintf(dderr, "DDERR_NOALPHAHW"); break;
		case DDERR_NOCLIPLIST : sprintf(dderr, "DDERR_NOCLIPLIST"); break;
		case DDERR_NOCOLORCONVHW : sprintf(dderr, "DDERR_NOCOLORCONVHW"); break;
		case DDERR_NOCOOPERATIVELEVELSET : sprintf(dderr, "DDERR_NOCOOPERATIVELEVELSET"); break;
		case DDERR_NOCOLORKEY : sprintf(dderr, "DDERR_NOCOLORKEY"); break;
		case DDERR_NOCOLORKEYHW : sprintf(dderr, "DDERR_NOCOLORKEYHW"); break;
		case DDERR_NODIRECTDRAWSUPPORT : sprintf(dderr, "DDERR_NODIRECTDRAWSUPPORT"); break;
		case DDERR_NOEXCLUSIVEMODE : sprintf(dderr, "DDERR_NOEXCLUSIVEMODE"); break;
		case DDERR_NOFLIPHW : sprintf(dderr, "DDERR_NOFLIPHW"); break;
		case DDERR_NOGDI : sprintf(dderr, "DDERR_NOGDI"); break;
		case DDERR_NOMIRRORHW : sprintf(dderr, "DDERR_NOMIRRORHW"); break;
		case DDERR_NOTFOUND : sprintf(dderr, "DDERR_NOTFOUND"); break;
		case DDERR_NOOVERLAYHW : sprintf(dderr, "DDERR_NOOVERLAYHW"); break;
		case DDERR_NORASTEROPHW : sprintf(dderr, "DDERR_NORASTEROPHW"); break;
		case DDERR_NOROTATIONHW : sprintf(dderr, "DDERR_NOROTATIONHW"); break;
		case DDERR_NOSTRETCHHW : sprintf(dderr, "DDERR_NOSTRETCHHW"); break;
		case DDERR_NOT4BITCOLOR : sprintf(dderr, "DDERR_NOT4BITCOLOR"); break;
		case DDERR_NOT4BITCOLORINDEX : sprintf(dderr, "DDERR_NOT4BITCOLORINDEX"); break;
		case DDERR_NOT8BITCOLOR : sprintf(dderr, "DDERR_NOT8BITCOLOR"); break;
		case DDERR_NOTEXTUREHW : sprintf(dderr, "DDERR_NOTEXTUREHW"); break;
		case DDERR_NOVSYNCHW : sprintf(dderr, "DDERR_NOVSYNCHW"); break;
		case DDERR_NOZBUFFERHW : sprintf(dderr, "DDERR_NOZBUFFERHW"); break;
		case DDERR_NOZOVERLAYHW : sprintf(dderr, "DDERR_NOZOVERLAYHW"); break;
		case DDERR_OUTOFCAPS : sprintf(dderr, "DDERR_OUTOFCAPS"); break;
		case DDERR_OUTOFMEMORY : sprintf(dderr, "DDERR_OUTOFMEMORY"); break;
		case DDERR_OUTOFVIDEOMEMORY : sprintf(dderr, "DDERR_OUTOFVIDEOMEMORY"); break;
		case DDERR_OVERLAYCANTCLIP : sprintf(dderr, "DDERR_OVERLAYCANTCLIP"); break;
		case DDERR_OVERLAYCOLORKEYONLYONEACTIVE : sprintf(dderr, "DDERR_OVERLAYCOLORKEYONLYONEACTIVE"); break;
		case DDERR_PALETTEBUSY : sprintf(dderr, "DDERR_PALETTEBUSY"); break;
		case DDERR_COLORKEYNOTSET : sprintf(dderr, "DDERR_COLORKEYNOTSET"); break;
		case DDERR_SURFACEALREADYATTACHED : sprintf(dderr, "DDERR_SURFACEALREADYATTACHED"); break;
		case DDERR_SURFACEALREADYDEPENDENT : sprintf(dderr, "DDERR_SURFACEALREADYDEPENDENT"); break;
		case DDERR_SURFACEBUSY : sprintf(dderr, "DDERR_SURFACEBUSY"); break;
		case DDERR_CANTLOCKSURFACE : sprintf(dderr, "DDERR_CANTLOCKSURFACE"); break;
		case DDERR_SURFACEISOBSCURED : sprintf(dderr, "DDERR_SURFACEISOBSCURED"); break;
		case DDERR_SURFACELOST : sprintf(dderr, "DDERR_SURFACELOST"); break;
		case DDERR_SURFACENOTATTACHED : sprintf(dderr, "DDERR_SURFACENOTATTACHED"); break;
		case DDERR_TOOBIGHEIGHT : sprintf(dderr, "DDERR_TOOBIGHEIGHT"); break;
		case DDERR_TOOBIGSIZE : sprintf(dderr, "DDERR_TOOBIGSIZE"); break;
		case DDERR_TOOBIGWIDTH : sprintf(dderr, "DDERR_TOOBIGWIDTH"); break;
		case DDERR_UNSUPPORTED : sprintf(dderr, "DDERR_UNSUPPORTED"); break;
		case DDERR_UNSUPPORTEDFORMAT : sprintf(dderr, "DDERR_UNSUPPORTEDFORMAT"); break;
		case DDERR_UNSUPPORTEDMASK : sprintf(dderr, "DDERR_UNSUPPORTEDMASK"); break;
		case DDERR_VERTICALBLANKINPROGRESS : sprintf(dderr, "DDERR_VERTICALBLANKINPROGRESS"); break;
		case DDERR_WASSTILLDRAWING : sprintf(dderr, "DDERR_WASSTILLDRAWING"); break;
		case DDERR_XALIGN : sprintf(dderr, "DDERR_XALIGN"); break;
		case DDERR_INVALIDDIRECTDRAWGUID : sprintf(dderr, "DDERR_INVALIDDIRECTDRAWGUID"); break;
		case DDERR_DIRECTDRAWALREADYCREATED : sprintf(dderr, "DDERR_DIRECTDRAWALREADYCREATED"); break;
		case DDERR_NODIRECTDRAWHW : sprintf(dderr, "DDERR_NODIRECTDRAWHW"); break;
		case DDERR_PRIMARYSURFACEALREADYEXISTS : sprintf(dderr, "DDERR_PRIMARYSURFACEALREADYEXISTS"); break;
		case DDERR_NOEMULATION : sprintf(dderr, "DDERR_NOEMULATION"); break;
		case DDERR_REGIONTOOSMALL : sprintf(dderr, "DDERR_REGIONTOOSMALL"); break;
		case DDERR_CLIPPERISUSINGHWND : sprintf(dderr, "DDERR_CLIPPERISUSINGHWND"); break;
		case DDERR_NOCLIPPERATTACHED : sprintf(dderr, "DDERR_NOCLIPPERATTACHED"); break;
		case DDERR_NOHWND : sprintf(dderr, "DDERR_NOHWND"); break;
		case DDERR_HWNDSUBCLASSED : sprintf(dderr, "DDERR_HWNDSUBCLASSED"); break;
		case DDERR_HWNDALREADYSET : sprintf(dderr, "DDERR_HWNDALREADYSET"); break;
		case DDERR_NOPALETTEATTACHED : sprintf(dderr, "DDERR_NOPALETTEATTACHED"); break;
		case DDERR_NOPALETTEHW : sprintf(dderr, "DDERR_NOPALETTEHW"); break;
		case DDERR_BLTFASTCANTCLIP : sprintf(dderr, "DDERR_BLTFASTCANTCLIP"); break;
		case DDERR_NOBLTHW : sprintf(dderr, "DDERR_NOBLTHW"); break;
		case DDERR_NODDROPSHW : sprintf(dderr, "DDERR_NODDROPSHW"); break;
		case DDERR_OVERLAYNOTVISIBLE : sprintf(dderr, "DDERR_OVERLAYNOTVISIBLE"); break;
		case DDERR_NOOVERLAYDEST : sprintf(dderr, "DDERR_NOOVERLAYDEST"); break;
		case DDERR_INVALIDPOSITION : sprintf(dderr, "DDERR_INVALIDPOSITION"); break;
		case DDERR_NOTAOVERLAYSURFACE : sprintf(dderr, "DDERR_NOTAOVERLAYSURFACE"); break;
		case DDERR_EXCLUSIVEMODEALREADYSET : sprintf(dderr, "DDERR_EXCLUSIVEMODEALREADYSET"); break;
		case DDERR_NOTFLIPPABLE : sprintf(dderr, "DDERR_NOTFLIPPABLE"); break;
		case DDERR_CANTDUPLICATE : sprintf(dderr, "DDERR_CANTDUPLICATE"); break;
		case DDERR_NOTLOCKED : sprintf(dderr, "DDERR_NOTLOCKED"); break;
		case DDERR_CANTCREATEDC : sprintf(dderr, "DDERR_CANTCREATEDC"); break;
		case DDERR_NODC : sprintf(dderr, "DDERR_NODC"); break;
		case DDERR_WRONGMODE : sprintf(dderr, "DDERR_WRONGMODE"); break;
		case DDERR_IMPLICITLYCREATED : sprintf(dderr, "DDERR_IMPLICITLYCREATED"); break;
		case DDERR_NOTPALETTIZED : sprintf(dderr, "DDERR_NOTPALETTIZED"); break;
		case DDERR_UNSUPPORTEDMODE : sprintf(dderr, "DDERR_UNSUPPORTEDMODE"); break;
		case DDERR_NOMIPMAPHW : sprintf(dderr, "DDERR_NOMIPMAPHW"); break;
		case DDERR_INVALIDSURFACETYPE : sprintf(dderr, "DDERR_INVALIDSURFACETYPE"); break;
		case DDERR_DCALREADYCREATED : sprintf(dderr, "DDERR_DCALREADYCREATED"); break;
		case DDERR_CANTPAGELOCK : sprintf(dderr, "DDERR_CANTPAGELOCK"); break;
		case DDERR_CANTPAGEUNLOCK : sprintf(dderr, "DDERR_CANTPAGEUNLOCK"); break;
		case DDERR_NOTPAGELOCKED : sprintf(dderr, "DDERR_NOTPAGELOCKED"); break;
		case DDERR_NOTINITIALIZED : sprintf(dderr, "DDERR_NOTINITIALIZED"); break;

		default : sprintf(dderr, "Unknown Error"); break;
	}

	sprintf(err, "DirectDraw Error %s\n", dderr);
	GlobalError (&err[0]);
	PostQuitMessage(0);
}

/**************************************************************************************************
InitApp
*************************************************************************************************/
BOOL InitApp(HINSTANCE hInst, int nCmdShow)
{

	GError = CreateFile("Error.out",
				GENERIC_WRITE,
				FILE_SHARE_WRITE,
				NULL,
				CREATE_ALWAYS,
				FILE_ATTRIBUTE_NORMAL|FILE_FLAG_WRITE_THROUGH,
				NULL);


	WNDCLASS WndClass;
	HWND hWnd;

	WndClass.style = CS_HREDRAW | CS_VREDRAW;
	WndClass.lpfnWndProc = WinProc;
	WndClass.cbClsExtra = 0;
	WndClass.cbWndExtra = 0;
	WndClass.hInstance = hInst;
	WndClass.hIcon = NULL;
	WndClass.hCursor = NULL;
	WndClass.hbrBackground = GetStockObject(BLACK_BRUSH);
	WndClass.lpszMenuName = "Roto Zoomer";
	WndClass.lpszClassName = "Roto Zoomer";
	RegisterClass(&WndClass);

#ifdef _DEBUG
	hWnd = CreateWindowEx(
		0,
		"Roto Zoomer",
		"Roto Zoomer",
		WS_POPUP,
		0,0,
		GetSystemMetrics(SM_CXSCREEN),
		GetSystemMetrics(SM_CYSCREEN),
		NULL,
		NULL,
		hInst,
		NULL);
#else
	hWnd = CreateWindowEx(
		0,
		"Roto Zoomer",
		"Roto Zoomer",
		WS_POPUP,
		0,0,
		640,
		480,
		NULL,
		NULL,
		hInst,
		NULL);

#endif

	if(!hWnd) return FALSE;

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);


	HRESULT rval;
	DDSURFACEDESC ddsd;
	LPDIRECTDRAW DDraw;
	DDSCAPS ddscaps;


	rval = DirectDrawCreate(NULL, &DDraw, NULL);
	if (rval!= DD_OK) 	
	{
		GlobalError ("Display - Can't get DD interface for full screen\n");
		DDError(rval, hWnd);

		return FALSE;
	}

	rval = DDraw->QueryInterface(IID_IDirectDraw2, (LPVOID*)&lpDD);
	if (rval!= DD_OK) 	
	{
		GlobalError ("Display - Can't get DD2 interface for full screen\n");
		DDError(rval, hWnd);
		return FALSE;
	}

	DDraw->Release();

#ifdef _DEBUG
	//Create Windowed For Debug Mode

	rval = lpDD->SetCooperativeLevel((HWND)hWnd, DDSCL_NORMAL);
	if (rval!= DD_OK) 	
	{
		GlobalError ("Display - Can't set coop level for windowed\n");
		DDError(rval, hWnd);

		return FALSE;
	}

	//Create front buffer

	setupDDSD (ddsd);
	ddsd.dwFlags = DDSD_CAPS;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;

	rval = lpDD->CreateSurface(&ddsd, &lpDDSFront, NULL);
	if (rval!= DD_OK) 	
	{
		GlobalError ("Display - Can't create front buffer for windowed");
		DDError(rval, hWnd);
		return FALSE;
	}

	//Create back buffer

	lpDDSBack=lpDDSFront;
#else
	//Create Full Screen
	rval = lpDD->SetCooperativeLevel((HWND)hWnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN);
	if (rval!= DD_OK) 	
	{
		GlobalError ("Display - Can't set coop level for full screen\n");
		DDError(rval, hWnd);

		return FALSE;
	}

	rval = lpDD->SetDisplayMode(640, 480, 8, 0, 0);
	if (rval!= DD_OK) 	
	{
		GlobalError ("Display - Can't Set Fullscreen display mode 640X480X8");
		DDError(rval, hWnd);

		return FALSE;
	}


	//Create front buffer

	setupDDSD (ddsd);
	ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|DDSCAPS_COMPLEX;
	ddsd.dwBackBufferCount = 1;

	rval = lpDD->CreateSurface(&ddsd, &lpDDSFront, NULL);
	if (rval!= DD_OK) 	
	{
		GlobalError ("Display - Can't create front buffer for full screen");
		DDError(rval, hWnd);
		return FALSE;
	}

	//Create back buffer

	ddscaps.dwCaps = DDSCAPS_BACKBUFFER |DDSCAPS_VIDEOMEMORY|DDSCAPS_FLIP |	DDSCAPS_COMPLEX;
	rval = lpDDSFront->GetAttachedSurface(&ddscaps, &lpDDSBack);
	if(rval != DD_OK)
	{
    	ddscaps.dwCaps = DDSCAPS_BACKBUFFER |DDSCAPS_SYSTEMMEMORY|DDSCAPS_FLIP |DDSCAPS_COMPLEX;
		rval = lpDDSFront->GetAttachedSurface(&ddscaps, &lpDDSBack);
		if (rval!= DD_OK) 	
		{
			GlobalError ("Display - Can't get attached back buffer for Fullscreen\n");
			DDError(rval, hWnd);
			return FALSE;
		}
	}

	IDirectDrawPalette * pal;
	pal = DDLoadPalette (lpDD, "IMAGE");
	rval = lpDDSFront->SetPalette (pal);



#endif

	lpImage = DDLoadBitmap (lpDD,"IMAGE", 320,240);
	if (lpImage == NULL) return FALSE;
	lpImage2 = DDLoadBitmap (lpDD,"URL", 100,20);
	if (lpImage2 == NULL) return FALSE;

	Frame = 0;
	return TRUE;
}

/**************************************************************************************************
WinMain
*************************************************************************************************/


int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow)
{
	float scale;
	HRESULT rval;
	MSG msg;
	RECT src,dest,src2;
	int err =0;
	DDBLTFX ddbltfx;


	src . left = 0;
	src . right = 320;
	src . top = 0;
	src . bottom = 240;

	src2 . left = 0;
	src2 . right = 100;
	src2 . top = 0;
	src2 . bottom = 20;


	dest . left = 0;
	dest . right = 640;
	dest . top = 0;
	dest . bottom = 480;

	if(!InitApp(hInst, nCmdShow)) return FALSE;

	while(1)
	{
		if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if(!GetMessage(&msg, NULL, 0, 0 )) return msg.wParam;
			TranslateMessage(&msg); 
			DispatchMessage(&msg);
		}
		else if(bActive)
		{

			scale = (sin ((double)Frame/3 * 3.14/180)+1.25);
			ddbltfx.dwSize = sizeof(ddbltfx);
			ddbltfx.dwFillColor = 0;
			lpDDSBack->Blt(&dest, NULL, NULL, DDBLT_WAIT | DDBLT_COLORFILL, &ddbltfx);

			DrawRotatedZoomed (lpImage, lpDDSBack,src, dest, 320,240, Frame,scale,scale*1.2, false);	
			scale = (sin ((double)Frame*2 * 3.14/180)+1.25);
			DrawRotatedZoomed (lpImage2, lpDDSBack,src2, dest, 500,420, 0,scale,scale*1.2, false);	

			Frame += 3;
#ifndef _DEBUG
			err =0;
			while (1)
			{
				rval = lpDDSFront->Flip(NULL, DDFLIP_WAIT);
				if (rval == DDERR_SURFACEBUSY) 
				{
					err++;
					if (err>1000) break;
				}
				else if (rval!=DD_OK)
				{
					//GlobalError ("Display - Can't Flip Fullscreen\n");
				    return 0;
				}
				else break;
			}
#endif
		}
		else WaitMessage();
	}	
}
