/************************************************************************/
/* bstructs.h, basic structures.                                        */
/************************************************************************/

#ifndef _chem_bstructs_h
#define _chem_bstructs_h


/************************************************************************/
/* defines                                                              */
/************************************************************************/
#define maxtextures 8


/************************************************************************/
/* vertextype, verteksin x, y ja z -koordinaatit.                       */
/************************************************************************/
typedef struct
{
 float x, y, z;
} vertextype;


/************************************************************************/
/* matriisi, matriisin tyyppi. kytmme 3x3 matriiseja.                 */
/************************************************************************/
typedef float matriisi[3][3];


/************************************************************************/
/* uv_type, verteksin u ja v -koordinaatit (texturelle).                */
/************************************************************************/
typedef struct
{
 float u, v; // texture u, texture v
} uv_type;


/************************************************************************/
/* facetype, facen kyttmt verteksit (a,b ja c) ja flags, facen       */
/* kyttm pinnoitusmenetelm plus muut attribuutit.                   */
/************************************************************************/
typedef struct
{
 int a, b, c;
 vertextype facenormal;
 unsigned int flags;
} facetype;

/************************************************************************/
/* flags:                                                               */
/*  bitit 0-3: (eli 4-bittinen numero)                                  */
/*   switch (flags&15) {                                                */
/*    case 0:flat                                                       */
/*    case 1:gouraud                                                    */
/*    case 2:texture                                                    */
/*    case 3:gouraud+texture                                            */
/*    case 4:phong                                                      */
/*    case 5:envmap                                                     */
/*    default:reserved for future expansions                            */
/*   }                                                                  */
/*  bitit 4-7:                                                          */
/*   bitti 4 pll: hidden face removal enabled                        */
/*  bitit 8-31:                                                         */
/*    flat: polygonin vri, 8-bittiset r,g ja b.                        */
/*    gouraud: polygonin vri, 8-bittiset r,g ja b.                     */
/*    texture: mit texturea kytetn                                  */
/************************************************************************/


/************************************************************************/
/* valon tyyppimrittely.                                              */
/************************************************************************/
/* paremmat valot tulevat hamassa tulevaisuudessa.                      */
/************************************************************************/
typedef struct
{
 vertextype direction; // suuntavektori
} valo_type;


/************************************************************************/
/* pol_vertex_type, sytestruktuuri polygonirutiineille.                */
/************************************************************************/
/* hlineillekin kannattaisi olla vastaava.                              */
/************************************************************************/
typedef struct
{
 int x, y, z, u, v, c, r, g, b;  // r,g,b=c(olor)
 float nx, ny, nz; // normal x, normal y, normal z
} pol_vertex_type;


/************************************************************************/
/* kuvan tyyppimrittely.                                              */
/************************************************************************/
typedef struct
{
 char *filename;
 unsigned char *palette;
 unsigned char *data;
 unsigned short xkoko, ykoko;
} kuva;


/************************************************************************/
/* z-sortin kyttn.                                                   */
/************************************************************************/
typedef struct
{
 int order, face; // mik face piirretn
 unsigned short object; // mille objektille face kuuluu
} order_struct; // piirtojrjestys


/************************************************************************/
/* kameran tyyppimrittely.                                            */
/************************************************************************/
typedef struct
{
 float xpos, ypos, zpos, perspective, center_x, center_y, x_suhde, y_suhde;
 int screen_left,screen_right,screen_up,screen_down;
 matriisi kam;
} kamera_type;


/************************************************************************/
/* objektin perusta, verteksit, normaalit, facet, texturekoordinaatit,  */
/* tiedot verteksien ja facejen lukumrst.                           */
/************************************************************************/
typedef struct
{
 vertextype *vertex;
 vertextype *normal;
 uv_type *uv;
 facetype *face;
 unsigned int vertices, faces;
} objtype;


/************************************************************************/
/* objektin "linkki" muuhun engineen.                                   */
/************************************************************************/
typedef struct
{
 objtype objekti; /* vertices, faces, normals */
 unsigned int vertex_index; /* index to rot */
 unsigned int face_index; /* index to order */
 float xpos, ypos, zpos; /* object's position */
 matriisi obj_matrix;
 vertextype origin; /* object's position presented as a vertex */
 int hidden; // 1 yes, 0 no
} opjtaip;


/************************************************************************/
/* scenen posaset.                                                    */
/************************************************************************/
typedef struct
{
 opjtaip *obut;   // objektit
 valo_type valo;  // valo
 vertextype *rot; // rotatoidut verteksit
 vertextype *nor; // rotatoidut normaalit (turha)
 unsigned int total_objects;      // objektien mr
 unsigned int faces_in_scene;     // facejen mr
 unsigned int vertices_in_scene;  // verteksien mr
 kuva textm[maxtextures];         // texturemapit
 int perspektiivi_korjaus_paalla;

 unsigned int total_rot_vertices; // enginen sisll
 unsigned int total_faces;        // enginen sisll
} scene_type;

/************************************************************************/
/* vesa defines.                                                        */
/************************************************************************/

typedef struct
{
    int wingran;
    unsigned int linearaddress;
    unsigned int linearselector,bytesperline,bytesperpixel;
    unsigned int width,height;
    unsigned char *LFBptr;
} VBECurrentMode_type;

#endif
