
// TOSTADOR.CPP  --  Ejemplo de animacin por cuadros  --  por FAC

#include <iostream.h>        // cout
#include <conio.h>           // clrscr, getch
#include <stdlib.h>          // randomize, random
#include <dos.h>             // MK_FP
#include "mode13.h"
#include "mode13.cpp"

#define CambiaCuadro 100
#define NumSprites 10


typedef byte ToastPic[28][38];

typedef struct
        {   int x, y;
            byte cuadro;
            byte velocidad;
            word cont;
            int velx, vely;
        } TSprite;


ToastPic Tostador[4];
TSprite Sprite[NumSprites];
PTVirtual FondoScr, VirScr;
word FondoSeg, VirSeg;
TPalette pal;


void CargaImagenes()
{
     int x, y, i;
     PTVirtual tempScr;
     word tempSeg;
     TPalette tempPal;
     char *fn;

     FadeOut(0);
     for (i = 0; i < 4; i++)
     {
          fn = "toast .pcx";
          fn[5] = i + 49;
          LoadPCX(fn, VGA, 38, 28, 0, 0, tempPal);
          for (y = 0; y < 28; y++)
              for (x = 0; x < 38; x++)
                  Tostador[i][y][x] = GetPixel(x, y, VGA);
     }
}


void DibujaTostadores(word where)
{
     word x, y;
     byte i, cuadro;

     for (i = 0; i < NumSprites; i++)
     {
          cuadro = Sprite[i].cuadro;
          for (y = 0; y < 28; y++)
          {
               for (x = 0; x < 38; x++)
               {
                   if (Tostador[cuadro][y][x])
                      PutPixel(x + Sprite[i].x, y + Sprite[i].y,
                               Tostador[cuadro][y][x], where);
               }
          }
     }
}


void MueveTostadores()
{
     for (byte i = 0; i < NumSprites; i++)
     {
          if ((Sprite[i].cont += Sprite[i].velocidad) > CambiaCuadro)
          {
               Sprite[i].cont = 0;
               Sprite[i].cuadro = (Sprite[i].cuadro + 1) % 4;
          }

          if (((Sprite[i].x += Sprite[i].velx) < 0) ||
              ((Sprite[i].y += Sprite[i].vely) > 176))
          {
               Sprite[i].y = 0;
               Sprite[i].x = random(160) + 120;
          }
     }
}


void IniciaTostadores()
{
     randomize();
     for (byte i = 0; i < NumSprites; i++)
     {
          Sprite[i].x = random(160) + 120;
          Sprite[i].y = random(170);
          Sprite[i].cuadro = random(4);
          Sprite[i].cont = 0;
          Sprite[i].velocidad = (i % 10) + 10;
          Sprite[i].velx = -(i % 2) - 1;
          Sprite[i].vely = random(3) + 1;
     }
}


void main()
{
     clrscr();
     cout << "\nEjemplo de animacin simple por cuadros\n"
          << "\nPresiona una tecla para continuar...\n";
     getch();

     SetMode13();
     IniciaTostadores();
     CargaImagenes();
     SetupVirtual(FondoScr, FondoSeg);
     SetupVirtual(VirScr, VirSeg);
     if ((!FondoScr) || (!VirScr)) exit(1);
     LoadPCX("sky.pcx", FondoSeg, 320, 200, 0, 0, pal);
     SetPalette(pal);

     while (!kbhit())
     {
          CopyScreen(FondoSeg, VirSeg);
          DibujaTostadores(VirSeg);
          VRetrace();
          CopyScreen(VirSeg, VGA);
          MueveTostadores();
     }

     getch();
     FadeOut(5);
     SetTextMode();
     ShutDownVirtual(FondoScr);
     ShutDownVirtual(VirScr);
}
