
program ScrollV;
{ Programa que muestra cmo hacer el scroll vertical de pantalla completa
  en el modo 13.

  Por: FAC productions.
}


uses Mode_13, Crt;

var VirScr : PTVirtual; { Apuntador a la pantalla virtual }
    VirSeg : word;      { Segmento de la pantalla virtual }


procedure DibujaFondo;
{ Dibuja un fondo ajedrezado en la pantalla virtual (sin comentarios) }
var x, y, i : word;
    color : byte;

begin
     color := 1;
     for y := 0 to 7 do
     begin
         for x := 0 to 9 do
         begin
              for i := 0 to 24 do
                  hline(x * 32, x * 32 + 31, y * 25 + i, color, VirSeg);
              inc(color);
              if color > 2 then color := 1;
         end;
         inc(color);
         if color > 2 then color := 1;
     end;
end;


procedure ScrollHaciaArriba;
{ Hace un scroll hacia arriba y mueve la lnea superior a la inferior }

var buffer : array[0..319] of byte; { buffer temporal para guardar la }
    i : word;                       { lnea superior }

begin
     for i := 0 to 319 do buffer[i] := mem[VirSeg:i]; { Guarda la lnea
                                                        superior }
     Move(mem[VirSeg:320], mem[VirSeg:0], 63680); { mueve la pantalla
                                                    una lnea hacia arriba }

     for i := 0 to 319 do mem[VirSeg:63680+i] := buffer[i];
     { copia la lnea superior a la inferior }

     VRetrace; { Espera al retrazado vertical }
     CopyScreen(VirSeg, VGA); { Y copia la pantalla virtual a VGA }
end;


procedure ScrollHaciaAbajo;
{ Hace un scroll hacia abajo y mueve la lnea inferior a la superior }
{ La idea es la misma que en el procedimiento anterior }

var buffer : array[0..319] of byte;
    i : word;

begin
     for i := 0 to 319 do buffer[i] := mem[VirSeg:63680+i];
     Move(mem[VirSeg:0], mem[VirSeg:320], 63680);
     for i := 0 to 319 do mem[VirSeg:i] := buffer[i];
     VRetrace;
     CopyScreen(VirSeg, VGA);
end;



begin
     clrscr;
     writeln;
     writeln(' Programa de ejemplo de scroll vertical de pantalla completa.');
     writeln;
     writeln(' El programa dibuja un fondo ajedrezado y luego hace un scroll');
     writeln(' de pantalla completa hacia arriba. Al oprimir una tecla, la');
     writeln(' direccin del scroll cambia hacia abajo.');
     writeln;
     writeln(' oPrImE uNa TeClA...');
     readkey;


     SetupVirtual(VirScr, VirSeg); { inicializamos la pantalla virtual }

     DibujaFondo; { dibujamos el fondo ajedrezado (en la pantalla virtual) }

     SetMode13; { iniciamos el modo grfico }

     while keypressed do readkey; { Esto sirve para borrar el buffer
                                    del teclado (por si se haba oprimido
                                    alguna tecla) }

     { Se hace scroll hacia arriba hasta que se oprima una tecla }
     while not keypressed do ScrollHaciaArriba;
     readkey;

     { Se hace scroll hacia abajo hasta que se oprima una tecla }
     while not keypressed do ScrollHaciaAbajo;
     readkey;

     SetTextMode; { regresa al modo texto }
     ShutDownVirtual(VirScr); { y libera la memoria de la pantalla virtual }
     clrscr;
end.