/*
   OpenGL GlutDemo

   File		: glutdemo.c
   Date		: 28/10/00
   Author	: Mustata Bogdan (LoneRunner)
   Contact	: lonerunner@planetquake.com
*/
#include <io.h>
#include <wchar.h>
#include <stdio.h>
#include <process.h>
#include <gl/glut.h>
#include "tga.h"

typedef float vec_t;
typedef vec_t vec3_t[3];

enum {
    LEFT = 0, 
    RIGHT,
};

int mButton = -1;
int mOldY, mOldX;

vec3_t eye = {0.0f, 0.0f, 4.0f};
vec3_t rot = {45.0f, 45.0f, 0.0f};

float alpha = 0.5f;

void glutResize(int width, int height)
{   
	glViewport(0, 0, width, height);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(55.0, (float)width/(float)height, 1.0, 300.0);
	glMatrixMode(GL_MODELVIEW);
}

void glutKeyboard(unsigned char key, int x, int y)
{
	switch (key)
	{
		case 27:
			exit(0);

		case 'A':
		case 'a':
			alpha += 0.1f;
			printf("alpha %f\n", alpha);
			return;

		case 'Z':
		case 'z':
			alpha -= 0.1f;
			printf("alpha %f\n", alpha);
			return;
	}
}

void clamp(vec3_t v)
{
    int i;
    
    for (i = 0; i < 3; i ++)
        if (v[i] > 360 || v[i] < -360)
            v[i] = 0;
}

void glutMotion(int x, int y) 
{
    if (mButton == LEFT) 
    {
        rot[0] -= ((mOldY - y) * 180.0f) / 200.0f;
        rot[1] -= ((mOldX - x) * 180.0f) / 200.0f;
        clamp (rot);
    }
	else if (mButton == RIGHT) 
    {
        eye[2] -= ((mOldY - y) * 180.0f) / 200.0f;
        clamp (rot);
    } 

    mOldX = x; 
    mOldY = y;
}

void glutMouse(int button, int state, int x, int y) 
{
    if(state == GLUT_DOWN) 
    {
        mOldX = x;
        mOldY = y;
        switch(button)  
        {
            case GLUT_LEFT_BUTTON:
                mButton = LEFT;
            break;
            case GLUT_RIGHT_BUTTON:
                mButton = RIGHT;
            break;
        }
        } else if (state == GLUT_UP) 
            mButton = -1;
}

void glutMenu(int value)
{
	switch (value)
	{
		case 1:
			glutFullScreen();
			return;
		
		case 2:
			exit(0);
	}
}

void glutDisplay(void)
{   
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    glPushMatrix();
	glTranslatef (-eye[0], -eye[1], -eye[2]);	  

    glRotatef(rot[0], 1.0f, 0.0f, 0.0f);
    glRotatef(rot[1], 0.0f, 1.0f, 0.0f);
    glRotatef(rot[2], 0.0f, 0.0f, 1.0f);

	glColor4f(1.0f, 1.0f, 1.0f, alpha);
	glBindTexture(GL_TEXTURE_2D, 1);
	
	glBegin(GL_QUADS);
		// Front Face
		glNormal3f( 0.0f, 0.0f, 1.0f);
		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);
		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);
		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  1.0f);
		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  1.0f);
		// Back Face
		glNormal3f( 0.0f, 0.0f,-1.0f);
		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f, -1.0f);
		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);
		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);
		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f, -1.0f);
		// Top Face
		glNormal3f( 0.0f, 1.0f, 0.0f);
		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);
		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f,  1.0f,  1.0f);
		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f,  1.0f,  1.0f);
		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);
		// Bottom Face
		glNormal3f( 0.0f,-1.0f, 0.0f);
		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f, -1.0f, -1.0f);
		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f, -1.0f, -1.0f);
		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);
		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);
		// Right face
		glNormal3f( 1.0f, 0.0f, 0.0f);
		glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f, -1.0f);
		glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f, -1.0f);
		glTexCoord2f(0.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  1.0f);
		glTexCoord2f(0.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);
		// Left Face
		glNormal3f(-1.0f, 0.0f, 0.0f);
		glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f, -1.0f);
		glTexCoord2f(1.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);
		glTexCoord2f(1.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  1.0f);
		glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f, -1.0f);
	glEnd();
	glPopMatrix();

	glFlush();
	glutSwapBuffers();
}

int main(int argc, char *argv[])
{   
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
	glutInitWindowSize(400, 300);
	glutInitWindowPosition(100, 100);
	glutCreateWindow("glutdemo");

	glutReshapeFunc(glutResize);
	glutDisplayFunc(glutDisplay);
	glutIdleFunc(glutDisplay);
    glutKeyboardFunc(glutKeyboard);
	glutMouseFunc(glutMouse);
    glutMotionFunc(glutMotion);

	glEnable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);

	glutCreateMenu(glutMenu);
	glutAttachMenu(GLUT_MIDDLE_BUTTON);
	glutAddMenuEntry("Full Screen", 1);
	glutAddMenuEntry("Exit", 2);
		
	loadTGA("face.tga", 1);

	glutMainLoop();
	
	return 0;
}