#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <i86.h>
#include <dos.h>

/*****************************************\
|* TextFX (c) 1997 Jari Komppa            *\
|*                                         *\
|* Textmode low-level functions (80x43,nb)  *|
\********************************************/

/********************/
/* Data & variables */
/********************/

char palette[16*3]={ /* IBM basic palette, 16c, for calcpal */
 0, 0, 0,  0, 0,42,  0,42, 0,  0,42,42, 42, 0, 0, 42, 0,42, 42,21, 0, 42,42,42,
21,21,21, 21,21,63, 21,63,21, 21,63,63, 63,21,21, 63,21,63, 63,63,21, 63,63,63};

/**************/
/* Prototypes */
/**************/

void set80x43(void); /* Sets up 80x43, no blink, no cursor. */

void set80x25(void); /* Resets 80x25, blink, cursor. */

short int calcpal(float red, float green, float blue);
    /* Finds the closest color/char combo for any 0:63,0:63,0:63 value.
       NOT MEANT FOR REALTIME USE! */

void border(char color); /* _ONLY_ for debugging! */

void vrc(void); /* Although most if not all should be timer-synced.. */

/*************/
/* Functions */
/*************/

void vrc(void) {
    while ((inp(0x3da)&8)==0) {}
    while ((inp(0x3da)&8)!=0) {}
}

void border(char color) {
    inp(0x3da);
    outp(0x3c0,17+32);
    outp(0x3c0,color);
}

#define EXP(a) ((a)*(a))

short int calcpal(float red, float green, float blue) {
/* Slight changes from last version.. */
int b,c,ch,co;
double lastdist,dist,c1,c2,c3;
        c1=red;
        c2=green;
        c3=blue;
        lastdist=100000000;
        for (c=0;c<16;c++)
        for (b=0;b<16;b++) {
            dist=EXP((float)palette[b*3+0]-c1)+
                 EXP((float)palette[b*3+1]-c2)+
                 EXP((float)palette[b*3+2]-c3);
            if (dist<lastdist) {
                lastdist=dist;
                co=b;
                ch=219; // 
            }
            dist=EXP(((palette[b*3+0]+palette[c*3+0])/2.0)-c1)+
                 EXP(((palette[b*3+1]+palette[c*3+1])/2.0)-c2)+
                 EXP(((palette[b*3+2]+palette[c*3+2])/2.0)-c3);
            if (dist<lastdist) {
                lastdist=dist;
                co=b+(c*16);
                ch=177; // 
            }
            dist=EXP((palette[b*3+0]*0.75+palette[c*3+0]*0.25)-c1)+
                 EXP((palette[b*3+1]*0.75+palette[c*3+1]*0.25)-c2)+
                 EXP((palette[b*3+2]*0.75+palette[c*3+2]*0.25)-c3);
            if (dist<lastdist) {
                lastdist=dist;
                co=b+(c*16);
                ch=178; // 
            }

        }
    return((co<<8)+ch);
}


void set80x43(void) {
union REGS regs;
        regs.w.ax=0x1201; /* Set scanlines */
        regs.h.bl=0x30;
        int386(0x10,&regs,&regs);
        regs.w.ax=0x3;    /* Set text mode */
        int386(0x10,&regs,&regs);
        regs.w.ax=0x1112; /* Set font */
        regs.w.bx=0;
        int386(0x10,&regs,&regs);
        regs.h.bh=0;      /* Kill cursor - doesn't seem to work.. */
        regs.h.ah=3;
        int386(0x10,&regs,&regs);
        regs.w.cx=0x2000;
        regs.h.ah=1;
        int386(0x10,&regs,&regs);
        regs.w.ax=0x1003; /* Kill blink */
        regs.h.bl=0;
        int386(0x10,&regs,&regs);
        regs.w.ax=0x0200;   /* Position cursor to 51,80 */
        regs.w.bx=0x0033;
        regs.w.dx=0x004f;
        int386(0x10,&regs,&regs);
}

void set80x25(void) {
union REGS regs;
        regs.w.ax=0x1202; /* Set scanlines */
        regs.h.bl=0x30;
        int386(0x10,&regs,&regs);
        regs.w.ax=0x3;    /* Set text mode */
        int386(0x10,&regs,&regs);
        regs.w.ax=0x1114; /* Set font */
        regs.w.bx=0;
        int386(0x10,&regs,&regs);
        regs.h.bh=0;      /* Ressurrect cursor */
        regs.h.ah=3;
        int386(0x10,&regs,&regs);
        regs.w.cx&=0xdfff;
        regs.h.ah=1;
        int386(0x10,&regs,&regs);
        regs.w.ax=0x1003; /* Enable blink */
        regs.h.bl=1;
        int386(0x10,&regs,&regs);
}
