DEF eacno = 1, pin = 2, amount = 3,           -- display codes
    timeout = ???,                  -- keyboard time out data response
    touttime = ???,                 -- time out interval
    on = ???, off = ???,            -- defs for display on or off
    secs = ??? :

CHAN activatecd, dispeacno, disppin,
     dispamount, dispagain,         -- i/o channels
     kch,                           -- data channel to keyboard
     db,dbreply :                   -- channels to database process

PROC controller =
     WHILE TRUE                     -- loop forever
        VAR tmout,rply :
        SEQ
           display(eacno,tmout,rply) -- display enter acc no
           IF
             NOT(tmout)             -- if not timed out
                SEQ
                   display(pin,tmout,rply) -- display enter PIN
                   IF
                     NOT(tmout)
                       SEQ
                          display(amount,tmout,rply) -- enter display amount
                          IF
                            NOT(tmout)
                              activatcd ! rply   -- start cash disp'er
                            TRUE
                              SKIP
                     TRUE
                       SKIP
             TRUE
                SKIP  :

PROC display(VALUE type, VAR tmout,rplv) =
   VAR doagain :
   SEQ
      doagain := TRUE
      WHILE doagain
         VAR val :
         SEQ
           IF
             type = eacno            -- send message to light display
                dispeacno ! on
             type = pin
                disppin ! on
             type = amount
                dispamount ! on
             TRUE
                SKIP
         keyboard(val)              -- read value from keyboard
         dispagain ! off            -- set display of
         IF
             type = eacno           -- set other display off
                dispeacno ! off
             type = pin
                disppin ! off
             type = amount
                dispamount ! off
             TRUE
                SKIP
         IF
             val = timeout          -- if keyboard timed out
                SEQ
                   doagain := FALSE -- exit loop
                   tmout := TRUE    -- with tmout true
             TRUE
                VAR torf :
                SEQ
                tmout := FALSE      -- else tmout is false
                db ! type ; val     -- send to database
                dbreply ? torf      -- reply true of false
                IF
                   NOT(torf)        -- reply false
                      dispagain ! on -- ask user to reinput
                   TRUE
                      SEQ
                         doagain := FALSE -- reply true so
                         rply := val.     -- exit loop

PROC keyboard(VAR digval) =
  VAR ndig :
  SEQ
    ndig := 0           -- no of digits input
    digval := 0         -- and integer value
    WHILE ndig < 4      -- user has to input 4 digits
       VAR curtime,d :
       SEQ
          TIME ? curtime
          ALT
            kch ? d     -- read value at update total
               SEQ
                 ndig := ndig + 1
                 digval := (digval * 10) + d - '0'
            TIME ? AFTER curtime + (touttime * secs)   -- time out
               SEQ
                 ndig := 5      -- get out of loop
                 digval := timeout  :  -- with time out value

SEQ
  controller
