--
-- occam 1 program to simulate circuit of figure 7.1
--
DEF Endbuffer = -3 :
CHAN Screen AT 1 :
CHAN Keyboard AT 2 :
--
-- process definitions
--
-- buffer processes
--
PROC wire(CHAN in,out)=
   VAR buffer :
   WHILE TRUE
     SEQ
       in?buffer
       out!buffer
--
-- process to simulate n input OR gate
--
PROC orgate(VALUE n,CHAN in[],out,counterdown)=
   VAR inp[n],outp :
   SEQ
     SEQ i=[0 FOR n]
        inp[i] := 0
     outp := 0
     WHILE TRUE
        VAR temp :
        SEQ
           temp := 0
           SEQ j=[0 FOR n]
              temp := temp \/ inp[j]
           IF
              temp <> outp
                SEQ
                   outp := temp
                   out!outp
              TRUE
                counterdown!1
           ALT i=[0 FOR n]
              in[i]?inp[i]
                 SKIP  :
--
-- process to simulate n input AND gate
--
PROC andgate(VALUE n,CHAN in[],out,counterdown)=
   VAR inp[n],outp :
   SEQ
     SEQ i=[0 FOR n]
       inp[i] := 0
     outp := 0
     WHILE TRUE
       VAR temp :
       SEQ
          temp := 1
          SEQ j=[0 FOR n]
             temp := temp /\ inp[j]
          IF
             temp <> outp
                SEQ
                   outp := temp
                   out!outp
             TRUE
                counterdown!1
          ALT i=[0 FOR n]
             in[i]?inp[i]
                SKIP  :
--
-- process to count events
--
PROC counter(VALUE nstart,ninc,ndec,nout,CHAN incount,
             inc[],dec[],out[])=
-- nstart is initialised count
-- ninc is no of increment channels
-- ndec is no of decrement channels
-- nout is no of output channels

  VAR count :
  SEQ
    count := nstart
    WHILE TRUE
       SEQ
          WHILE count <> 0
              VAR x :
              SEQ
                 ALT
                    ALT i=[0 FOR ninc]
                      inc[i]?x
                        SEQ
                           count := count+x
                    ALT i=[0 FOR ndec)
                      dec[i]?x
                        SEQ
                           count := count-x
              SEQ i=[1 FOR nout]
                 out[i]!ANY
              out[0]!ANY
              incount?count
              out[0]!ANY   :
--
-- output process
--
PROC outputmodule(CHAN in,controlin,counterdown)=
  VAR lastout :
  SEQ
    lastout := 0
    WHILE TRUE
       ALT
          in?lastout
             counterdown!1
          controlin? ANY
             SEQ
               Screen!(lastout+'0')             -- convert to ASCII
               Screen!#A                        -- send CR (hex 10)
               Screen!#D                        -- send LF (hex 13)
               Screen!Endbuffer :               -- flush VDU buffer
--
-- process to translate from circuit inputs to
-- transitions(events)
--
PROC inputmodule(VALUE ninp,CHAN inchar,out[],
                 controlin,counterout)=
  VAR outv [ninp]  :
  SEQ
     SEQ i=[0 FOR ninp]
         outv[i]:=0
     WHILE TRUE
         VAR trans,newval[ninp] :
         SEQ
            controlin?ANY
         trans := 0
         SEQ i=[0 FOR ninp]
            inchar?newval[i]
            IF
               newval[i] <> outv[i]
                  trans := trans + 1
               TRUE
                  SKIP
         counterout!trans
         controlin?ANY
         SEQ i=[0 FOR ninp]
            IF
               newval[i] <> outv[i]
                  SEQ
                     outv[i] := newval[i]
                     out[i]!outv[i]
               TRUE
                  SKIP  :
--
-- process to input a char from terminal
--
PROC input(CHAN outchar)=
  WHILE TRUE
    VAR character :
    SEQ
       Keyboard?character
       character := character - '0'   -- convert to no from ASCII
       outchar!character  :
--
-- channels as in figure
--
CHAN a,b[3],d[2],e,cnt,cu[3],cd[3],co[2]
--
-- process instantiations
--
-- do processes concurrently
--
PAR
   input (a)
   inputmodule(3,a,b,co[0],cnt)
   andgate(2,b,d[0),cd[0])
   orgate (2,d,e,cd[1])
   wire(b[2],d[1])
   outputmodule(e,co[1),cd[2])
   counter (2,0,3,1,cnt,cu,cd,co)
