DEF maxval=20,termin=99 :

PROC originnode(VALUE m,CHAN out[])=
-- outputs path length to internal nodes
-- and then terminator tokens
  SEQ
    SEQ i=[0 FOR m]
      out[i]!1
    SEQ i=[0 FOR m]
      out[i]!termin   :

PROC internalnode(VALUE n,m,CHAN in[],out[])=
-- stores minimum input path length on any input
-- broadcasts any received value
-- less than the current minimum
-- broadcasts terminator token after
-- receipt of same from all input channels
  VAR minval,endcount  :
  SEQ
    minval:=maxval            -- initially 'infinity'
    endcount:=0
    WHILE TRUE
       VAR val :
       ALT i=[0 FOR n]
         in[i]?val            -- accept any input
           IF
             val=termin
               IF
                 endcount=n-1 -- all termin recd
                   SEQ i=[0 FOR n]
                      out[i]!termin -- broadcast termin
                 TRUE
                   endcount:=endcount+1
             val<minval
               PAR
                 minval:=val
                 SEQ i=[0 FOR m]
                   out[i]!(val+1)   -- broadcast minval
             TRUE
               SKIP :

PROC destinationnode(VALUE n,CHAN in[],numberout)=
-- stores the minimum value input and
-- outputs this minimum when all terminators received
  VAR mindist   :
  SEQ
    mindist:=maxval        -- initially 'infinity'
    WHILE TRUE
      VAR val :
      ALT i=[0 FOR n]
          in[i]?val -- accept any input
             IF
               val=termin
                 IF
                   endcount=n-1 -- all termin recd
                      SEQ
                         numberout!mindist -- output min
                         STOP -- and stop
                   TRUE
                     IF
                       val<mindist
                         mindist:=val
                       TRUE
                         SKIP   :

PROC arc(CHAN in,out)=
  WHILE TRUE
    VAR val :
    SEQ
      in?val
      out!val   :

CHAN aout[2],bin[1],bout[2],cin[1],cout[2],din[2],
     dout [1], ein [2], eout [1], fin [ 2 ], screenout    :
PAR
  originnode(2,aout) -- set up nodes
  internalnode(1,2,bin,bout)
  int.ernalnode(1,2,cin,cout)
  internalnode(2,1,din,dout)
  internalnode(2,1,ein,eout)
  destinationnode(2,fin,screenout) -- not Screenout
  arc(aout[0],cin[0])              -- set up arcs
  arc(aout[1],bin[0])
  arc(bout[0],din[0])
  arc(bout[1],ein[0])
  arc(cout[0],din[1])
  arc(cout[1],ein[1])
  arc(dout[0],fin[0])
  arc(eout[0],fin[1])

-- plus module to print contents of screenout channel
