/*-----------------------------------------------------------------
 Non Rectangular window example :                                

 file   : XWindow.c

 date   : 26/11/2000
 author : MooZ/Blockos (CRUZ Vincent)                                         
                       (email: blockos@planet-d.net)                        
                       (url  : http://blockos.planet-d.net)                 

 Here's the famous GPL :
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with This program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

----------------------------------------------------------------------*/

#include "XWindow.h"

void InitXWindow    ( char *displayName, char *windowName, char *xpmFileName, XWindow *xWin ){
  /* Attributes of the xpm files */
  XpmAttributes attributes;

  /* ---- Connect to the X server ---- */
  if((xWin->display = XOpenDisplay( displayName ) ) == NULL){
    fprintf(stderr,"void InitXWindow( char*, char*, unsigned int, unsigned int, XWindow* );");
    fprintf(stderr,":: Can't connect to X server %s\n",XDisplayName(displayName));
    
    exit(1);
  }


  /* Get the default screen */
  xWin->screen = DefaultScreen ( xWin->display );
  
  /* Get the display depth */
  xWin->depth  = DefaultDepth(xWin-> display ,xWin->screen);
  
  /* Get the root window (= default root window) */
  xWin->winRoot = DefaultRootWindow (xWin->display);
 
  /* #####Important##### : The xpm attributes value mask must be set to zero otherwise you will get a core dump. */
  attributes.valuemask = 0;
  /* Read the Xpm file */
  XpmReadPixmapFile(xWin->display, xWin->winRoot, xpmFileName, &xWin->bgPix, &xWin->bgMask, &attributes);
  
  /* Display resolution */
  xWin->screenWidth  = DisplayWidth  ( xWin->display , xWin->screen );
  xWin->screenHeight = DisplayHeight ( xWin->display , xWin->screen );
 
  /* window size = xpm image size */
  xWin->width  = attributes.width;
  xWin->height = attributes.height;
  

  /* ---- Window attributes initialisation ---- */
  /* background pixmap = xpm image */
  xWin->winAttr.background_pixmap= xWin->bgPix;
  /* window border color */
  xWin->winAttr.border_pixel     = BlackPixel(xWin->display ,xWin->screen);
  /* auto refresh */
  xWin->winAttr.save_under       = True; 
  xWin->winAttr.backing_store    = Always;
  xWin->winMask                  = CWBorderPixel | CWBackPixmap | CWBackingStore | CWSaveUnder;

 
  /* ---- Window Creation ---- */
  if( (xWin->win = XCreateWindow (xWin->display , xWin->winRoot , 
				  0 ,0 , 
				  xWin->width , xWin->height ,
				  0 ,xWin->depth , InputOutput , 
				  CopyFromParent , xWin->winMask , 
				  &(xWin->winAttr))) == 0 ){ 
    
    fprintf(stderr,"void InitXWindow( char*, char*, unsigned int, unsigned int, XWindow* );");
    fprintf(stderr,":: Can't create window\n");
    
    exit(1);
  }
   
  /* ---- Window Geometry ----*/ 
  xWin->winHint.flags                  = PPosition | PMinSize | PMaxSize ;
  xWin->winHint.x                      = 0;
  xWin->winHint.y                      = 0;
  xWin->winHint.max_width  = xWin->winHint.min_width  = xWin->width;
  xWin->winHint.max_height = xWin->winHint.min_height = xWin->height;
  XSetWMNormalHints (xWin->display ,xWin->win ,&(xWin->winHint) );
       
  /* Set the window name */
  XStoreName (xWin->display ,xWin->win , windowName);
  
  /* Select events (keyboard, mouse ...) */
  XSelectInput ( xWin->display, xWin->win, KeyPressMask );
   
  /* ---- GC initialisation and creation ---- */
  xWin->gcVal.foreground = WhitePixel(xWin->display, xWin->screen);
  xWin->gcVal.background = BlackPixel(xWin->display, xWin->screen);
  xWin->gcVal.graphics_exposures = False;
  xWin->gcMask           = GCForeground|GCBackground;
  
  xWin->gc = XCreateGC(xWin->display, xWin->win, xWin->gcMask, &(xWin->gcVal));

  
/*
 +---------------------------------+ 
 |    Non rectangular Window Init  | 
 +---------------------------------+------------------------------------------------------------+ */
  XShapeCombineMask(xWin->display, xWin->win, ShapeBounding, 0, 0, xWin->bgMask, ShapeSet);  /* | */ 
  XShapeCombineMask(xWin->display, xWin->win, ShapeBounding, 0, 0, xWin->bgMask, ShapeUnion);/* | 
 +----------------------------------------------------------------------------------------------+ */  

  
/* Raise Window */
  XMapRaised (xWin->display ,xWin->win);
  /* Flush all events */
  XFlush     (xWin->display);
}

void CloseXWindow   ( XWindow *xWin ){
  /* Free all pixmaps */
  XFreePixmap    (xWin->display, xWin->bgPix);
  XFreePixmap    (xWin->display, xWin->bgMask);

  XFreeGC        (xWin->display, xWin->gc);  /* destroy GC */
  XDestroyWindow (xWin->display, xWin->win); /* destroy Window */

  XCloseDisplay  (xWin->display);            /* close window */
   
  xWin->display = NULL;
  xWin->win     = 0;
}


