%{
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "example.h"

char*	title	= NULL;
char*	data	= NULL;
int	fontsize= FONTSIZE;
int	blink	= 0;

void putData(char* text);
%}

%token DATA
%token oHTML	cHTML	oHEAD	cHEAD	oTITLE	cTITLE	
%token oBODY	cBODY	oBLINK	cBLINK	oBIG	cBIG	oBR	cBR


%start file

%%

file		: waste oHTML waste head waste body waste cHTML waste
		;

head		: oHEAD title cHEAD
		;

title		: DATA  { free(title); title=strdup($1); }
		| /* empty */
		;

body		: oBODY bodydata cBODY
		| oBODY cBODY
		;

bodydata	: bodydata bodydata2
		| bodydata2
		;

bodydata2	: oBIG		{ if (fontsize<FONTMAX) fontsize++; }
		| cBIG		{ if (fontsize>FONTMIN) fontsize--; }
		| oBLINK	{ blink=1; }
		| cBLINK	{ blink=0; }
		| oBR		{ putData("\n"); }
		| cBR
		| DATA		{ putData($1); }
		;

waste		: DATA
		| /* empty */
		;
%%

void putData(char* data)
{
  printf(data);
}

void yyerror(char* s)
{
  fprintf(stderr, "line %d: %s\n",yylineno, s);
}

int main()
{
  yyparse();
  return 0;
}
