    Program MyWave;
    Uses Crt, { For the keypressed function }
         Cel; { Read my article about the .CEL Format. There you }
              { can find this unit. }

    Type Screen = Array[0..63999] of byte;

    Var SinTable : Array[1..360] of ShortInt;
        VScreen  : ^Screen;          { Using a pointer will free more }
                                     { memory for your variables }
        S_VCel   : CelFormat;        { Better read the CEL.PAS }


    Procedure BuildSinTables;
    Var i : Word;
    Begin
    For i:=1 to 360 do
        Begin
        { Just for the records...Pi=3.1415926535897932385 }
        SinTable[i]:=Round(Sin(i*Pi/180)*127);
        End;
    End;


    Procedure Init13; Assembler;
    Asm mov ax, 13h; int 10h end;


    Procedure InitText; Assembler;
    Asm mov ax, 3h; int 10h end;


    Procedure SetupVirtualScreen;
       { Get memory for our virtual screen }
       Begin
       GetMem(VScreen, SizeOf(VScreen));
       End;


    Procedure FreeVirtualScreen;
       { Free the memory used by our virtual screen }
       Begin
       FreeMem(VScreen, SizeOf(VScreen));
       End;


    Procedure CopyVertLine(Y,Y1:Integer;Var From, Dest);Assembler;
       Asm
       Push Ds        { Better saving DS because it will be destroyed }
       Lds Si,From    { We move into [Ds:Si] our position of the VScreen }
       Mov Ax,320     { Ax:=320 }
       Mul Y          { Ax:=Y * 320 }
       Add Si,Ax      { Si:=Ax }
       Les Di,Dest    { We move into [Es:Di] our position of the real screen }
       Mov Ax,320     { Ax:=320 }
       Mul Y1         { Ax:=Y1 * 320 }
       Add Di,Ax      { Di:=Ax }
       Mov Cx,160     { Cx:=160 -> This means that we will do something }
                      { 160 times }
       Rep MovSw      { We copy the 2 pixels and inc Di & Si 2 times }
       Pop Ds         { We restore Ds 'cause he was destroyed }
       End;

    Const Waves      = 4;    { Number of waves }
          SinusWaves = 6;    { Depth/size of waves }
          YStart     = 10;   { YPos of start waving }
          YEnd       = 180;  { YPos of end waving }

    Var	Y      : Word;
        TLine1 : Integer;
        TLine2 : Integer;


    Begin
    Init13;
    SetupVirtualScreen;
    BuildSinTables;
    LoadCel('SV.CEL', S_VCel, VScreen, 0);
    UsePalette(S_VCel.Palette);

    { The SV.CEL is a little raytrace that i made some weeks ago. }
    { I know it's a lame one, but i'm a beginner in raytracing }

    Repeat
    For Y:=YStart To YEnd Do
        Begin
        TLine1:=TLine1+Waves;
        TLine2:=(SinTable[TLine1 mod 360]*SinusWaves) div 127;
        CopyVertLine(Y+TLine2,Y,VScreen^,Mem[$a000:0000]);
        End;
    TLine1:=TLine1-(YEnd-YStart)*Waves+1;
    Until Keypressed;


    FreeVirtualScreen;
    InitText;
    End.